/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.exportararquivos;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.exportararquivos.ExportarArquivoContabilidadeWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.exportararquivos.JobExportarArquivoContabilidade;
import java.time.temporal.Temporal;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/exportar-aquivos-contabil"})
@SubMenuMapping(MENU="SubMenuPainelContadorGeral", NOME="Exportar lan\u00e7amentos financeiros para a contabilidade", ICONE="icon-exportar-doc", ROTA="/notas-fiscais/exportar-aquivos-contabil", PROGRAMA=924)
public class ExportacaoArquivoContabilSimpleController
extends SimpleController
implements ICreateTask {
    private final TaskManager taskManager;

    public ExportacaoArquivoContabilSimpleController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.EXPORTACAO_ARQUIVO_CONTABILIDADE;
    }

    public Class<? extends AbstractJob> job() {
        return JobExportarArquivoContabilidade.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/exportar"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarArquivo(@RequestBody ExportarArquivoContabilidadeWrapper arquivoCont) throws UnicoMensagemUsuarioException {
        String detalhe = "Per\u00edodo: " + StringUtil.formataDataHora((Temporal)arquivoCont.getDataInicio(), (String)"dd/MM/yy") + " \u00e0 " + StringUtil.formataDataHora((Temporal)arquivoCont.getDataFim(), (String)"dd/MM/yy");
        this.createTask((Object)arquivoCont, detalhe);
    }
}

