/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.exportararquivos;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.contabilidade.enums.SistemaContabilEnum;
import br.intelidata.commons.modulo.contabilidade.regranegocio.integracao.UnicoIntegracaoContabilidade;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.exportararquivos.ExportarArquivoContabilidadeWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class JobExportarArquivoContabilidade
extends AbstractPrepareJob {
    private Remessa remessa;

    public JobExportarArquivoContabilidade(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, "Arquivo para contabilidade gerado com sucesso");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, "N\u00e3o foi poss\u00edvel gerar o arquivo para contabilidade");
    }

    public void execute() throws Exception {
        Long idEmpresa;
        ExportarArquivoContabilidadeWrapper arquivoCont = (ExportarArquivoContabilidadeWrapper)this.getObjetoDeserializado(ExportarArquivoContabilidadeWrapper.class);
        SistemaContabilEnum sistemaContabilEnum = arquivoCont.getTipoDispositivo();
        if (sistemaContabilEnum == null) {
            throw new UnicoMensagemUsuarioException("WCTB23392", "Sistema cont\u00e1bil n\u00e3o informado!");
        }
        String numeroEmpresaContabilidade = String.valueOf(arquivoCont.getNumEmpresaContabilidade());
        if (sistemaContabilEnum.isInformaNumeroEmpresaContabilidade() && Util.stringNullOrEmpty((String)numeroEmpresaContabilidade)) {
            throw new UnicoMensagemUsuarioException("WCTB23412", "N\u00famero da empresa na contabilidade n\u00e3o foi informado!");
        }
        Long l = idEmpresa = Util.longNullOuZero((Long)arquivoCont.getIdEmpresa()) ? SessaoUtil.getSessao().getFilial().getIdEmpresa() : arquivoCont.getIdEmpresa();
        if (ListMapUtil.listNullOrEmpty((List)arquivoCont.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WCTB23415", "Nenhuma filial selecionada para a exporta\u00e7\u00e3o! Verifique.");
        }
        boolean contasReceber = arquivoCont.isReceber();
        boolean contasPagar = arquivoCont.isPagar();
        boolean caixas = arquivoCont.isCaixas();
        boolean bancos = arquivoCont.isBancos();
        LocalDate periodoInicial = arquivoCont.getDataInicio();
        if (periodoInicial == null) {
            throw new UnicoMensagemUsuarioException("WCTB23393", "Per\u00edodo inicial n\u00e3o informado!");
        }
        LocalDate periodoFinal = arquivoCont.getDataFim();
        if (periodoFinal == null) {
            throw new UnicoMensagemUsuarioException("WCTB23394", "Per\u00edodo final n\u00e3o informado!");
        }
        UnicoIntegracaoContabilidade integracaoContabilidade = new UnicoIntegracaoContabilidade(sistemaContabilEnum, true);
        this.remessa = integracaoContabilidade.exportarDados(idEmpresa, SessaoUtil.getSessao().getFilial(), arquivoCont.getIdFilial(), numeroEmpresaContabilidade, periodoInicial, periodoFinal, contasReceber, contasPagar, caixas, bancos);
        this.saveFile(this.getFile());
    }

    protected File getFile() throws Exception {
        if (this.remessa != null) {
            File scratchFile = new File(FileUtils.getTempDirectory().getAbsolutePath(), "contabilidade.zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (Map.Entry entry : this.remessa.getMalote().getMapArquivos().entrySet()) {
                    if (((String)entry.getKey()).toLowerCase().endsWith(".txt")) {
                        FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])((byte[])entry.getValue()), (String)"LANCAMENTOS_CONTABEIS.txt");
                        continue;
                    }
                    FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])((byte[])entry.getValue()), (String)"Criticas referente a exportacao.pdf");
                }
            }
            return scratchFile;
        }
        return null;
    }
}

