/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contagemestoque;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.AjusteEstoque;
import br.intelidata.commons.domain.pojo.AjusteEstoqueContagem;
import br.intelidata.commons.domain.pojo.AjusteEstoqueContagemRealizada;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.FinalizacaoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueContagemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueContagemRealizadaRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RetiradaRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImpressaoCrudWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contagemestoque.ContagemEstoqueWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="contagemestoque", QUANTIDADE=QuantidadeCampoExtra.CONTAGEM_ESTOQUE)
@RestController
@RequestMapping(value={"/api/contagens-estoque"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Contagens de estoque", ICONE="icon-comanda", ROTA="/estoques/contagens-estoque", PROGRAMA=1488)
public class ContagemEstoqueCrudController
extends CrudController<AjusteEstoque, AjusteEstoqueRN> {
    @Autowired
    public ContagemEstoqueCrudController() {
        super((AbstractRegraNegocio)AjusteEstoqueRN.getInstance(), AjusteEstoque::new, true, true);
        this.setItemSupplier(AjusteEstoqueItem::new);
    }

    @PostMapping(value={"/estornar"})
    @DBTransaction
    public void estornar(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        AjusteEstoque ajuste = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
        if (ajuste == null) {
            throw new UnicoMensagemUsuarioException("WWW125", "N\u00e3o foi poss\u00edvel estornar o documento");
        }
        if (StatusAjusteEstoque.ESTORNADO.equals((Object)ajuste.getStatus())) {
            throw new UnicoMensagemUsuarioException("WWW123", "Ajuste de estoque j\u00e1 estornado.");
        }
        boolean isEstornou = AjusteEstoqueRN.getInstance().estornar(SessaoUtil.getSessao(), id);
        if (!isEstornou) {
            throw new UnicoMensagemUsuarioException("WWW124", "N\u00e3o foi poss\u00edvel estornar o documento.");
        }
        AjusteEstoque ajusteEstoqueAlterado = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
        this.gravarAuditoriaRegistro(id, ajusteEstoqueAlterado, 1);
    }

    @RequestMapping(value={"/permite-alterar"})
    @DBAutoCommit
    public boolean permiteAlterar(@RequestParam Long idAjuste) {
        return AjusteEstoqueRN.getInstance().permiteAlterar(idAjuste);
    }

    @RequestMapping(value={"/buscar-contagens-para-finalizar"})
    @DBAutoCommit
    public FinalizacaoAjusteEstoque buscarContagensParaFinalizar(@RequestParam Long idAjuste) throws UnicoMensagemUsuarioException {
        if (AjusteEstoqueRN.getInstance().permiteAlterar(idAjuste)) {
            FinalizacaoAjusteEstoque finalizacao = AjusteEstoqueRN.getInstance().iniciaFinalizacaoContagem(idAjuste);
            if (ListMapUtil.listNullOrEmpty((List)finalizacao.getItensContados()) && ListMapUtil.listNullOrEmpty((List)finalizacao.getItensNaoContados())) {
                throw new UnicoMensagemUsuarioException("WEST13", "N\u00e3o h\u00e1 itens para fazer acerto. Por favor verifique.");
            }
            return finalizacao;
        }
        throw new UnicoMensagemUsuarioException("WWW126", "N\u00e3o \u00e9 permitido alterar esta contagem de estoque");
    }

    @PostMapping(value={"/finalizar"})
    @DBTransaction
    public void finalizarContagem(@RequestBody ContagemEstoqueWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (!AjusteEstoqueRN.getInstance().permiteAlterar(wrapper.getIdAjuste())) {
            throw new UnicoMensagemUsuarioException("WWW131", "N\u00e3o \u00e9 permitido alterar esta contagem de estoque");
        }
        AjusteEstoqueRN.getInstance().finalizarContagem(SessaoUtil.getSessao(), wrapper.getIdAjuste(), wrapper.getItens());
    }

    @PostMapping(value={"/gravar-contagem"})
    @DBTransaction
    public ContagemEstoqueWrapper gravarContagem(@RequestBody ContagemEstoqueWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        AjusteEstoque ajusteEstoque = wrapper.getAjusteEstoque();
        ajusteEstoque.setIdUsuario(sessao.getIdUsuario());
        ajusteEstoque.setIdFilial(sessao.getIdFilial());
        ajusteEstoque.setStatus(StatusAjusteEstoque.PENDENTE);
        ajusteEstoque.setTipoMovimento(TipoAjusteEstoque.CONTAGEM);
        if (Util.longNullOuZero((Long)ajusteEstoque.getId())) {
            ajusteEstoque.setCodigo(AjusteEstoqueRN.getInstance().getCodigoUnico(sessao));
            Long id = AjusteEstoqueRN.getInstance().gravar(0, ajusteEstoque, sessao);
            ajusteEstoque.setId(id);
        } else {
            AjusteEstoqueRN.getInstance().gravar(1, ajusteEstoque, sessao);
        }
        AjusteEstoqueContagem contagem = wrapper.getContagem();
        contagem.setIdAjusteEstoque(ajusteEstoque.getId());
        contagem.setId(AjusteEstoqueContagemRN.getInstance().gravar(0, (AbstractPojo)contagem, sessao));
        ContagemEstoqueWrapper retorno = new ContagemEstoqueWrapper();
        retorno.setContagem(contagem);
        retorno.setAjusteEstoque(ajusteEstoque);
        return retorno;
    }

    @PostMapping(value={"/excluir-contagem"})
    @DBTransaction
    public void excluirContagem(@RequestBody Long idContagem) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        AjusteEstoqueContagem contagem = (AjusteEstoqueContagem)AjusteEstoqueContagemRN.getInstance().buscarPorId(idContagem);
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(contagem.getIdAjusteEstoque());
        if (!Util.listNullOrEmpty((List)itens)) {
            throw new UnicoMensagemUsuarioException("WEST147", "N\u00e3o \u00e9 poss\u00edvel excluir a contagem, pois j\u00e1 existem itens lan\u00e7ados. Verifique!");
        }
        AjusteEstoqueContagemRN.getInstance().excluir((AbstractPojo)contagem, sessao);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody AjusteEstoque ajusteEstoque, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ajusteEstoque.setIdUsuario(sessao.getIdUsuario());
        ajusteEstoque.setIdFilial(sessao.getIdFilial());
        ajusteEstoque.setStatus(StatusAjusteEstoque.PENDENTE);
        ajusteEstoque.setTipoMovimento(TipoAjusteEstoque.CONTAGEM);
        if (Util.longNullOuZero((Long)ajusteEstoque.getId())) {
            ajusteEstoque.setCodigo(AjusteEstoqueRN.getInstance().getCodigoUnico(sessao));
            Long id = AjusteEstoqueRN.getInstance().gravar(0, ajusteEstoque, sessao);
            ajusteEstoque.setId(id);
        } else {
            AjusteEstoqueRN.getInstance().gravar(1, ajusteEstoque, sessao);
        }
        this.gravarAuditoriaRegistro(ajusteEstoque.getId(), ajusteEstoque, ajusteEstoque.getAjusteEstoqueOriginal() != null ? 1 : 0);
        String mensagem = "Contagem de estoque n\u00famero " + ajusteEstoque.getCodigo() + " gravada com sucesso.";
        this.notificationService.notifyUser(SessaoUtil.getSessao().getIdUsuario(), mensagem, TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
        return ajusteEstoque.getId();
    }

    protected void gravarAuditoriaRegistro(Long id, AjusteEstoque pojoNovo, int transacao) throws UnicoMensagemUsuarioException {
        super.gravarAuditoriaRegistro(id, (AbstractPojo)pojoNovo.getAjusteEstoqueOriginal(), (AbstractPojo)pojoNovo, transacao);
    }

    @RequestMapping(value={"/buscar-contagens-realizadas"})
    @DBAutoCommit
    public List<AjusteEstoqueContagemRealizada> buscarContagensRealizadas(@RequestParam Long idAjusteEstoqueItem) {
        return AjusteEstoqueContagemRealizadaRN.getInstance().buscarListaPorAjusteItem(idAjusteEstoqueItem);
    }

    @RequestMapping(value={"/atualizar-estoque"})
    @DBAutoCommit
    public List<AjusteEstoqueItem> atualizarEstoqueItens(@RequestParam Long idAjusteEstoque, @RequestParam Long idLocalEstoque) {
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(idAjusteEstoque);
        AjusteEstoqueItemRN.getInstance().atualizarSaldoAtualEstoque(SessaoUtil.getSessao().getFilial().getId(), idLocalEstoque, itens);
        return itens;
    }

    public GridBuilder<AjusteEstoqueRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idfilial", "idfilial", 0, false));
        colunas.add(new ColunaSQL("data", "data_filtro", "Data filtro", 0, false, new String[0]));
        colunas.add(new ColunaSQL("datafinalizacaocontagem", "datafinalizacaocontagem_filtro", "Data finaliza\u00e7\u00e3o filtro", 0, false, new String[0]));
        colunas.add(new ColunaSQL("status", "statusdefault", "Status Default", 0, false, new String[0]));
        colunas.add(new ColunaSQL("tipomovimento", "tipomovimentodefault", "", 10, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "Documento", 0, true));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("datafinalizacaocontagem", "Finaliza\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipoContagem", "Tipo", 0, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00f5es", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true, StatusAjusteEstoque.class));
        GridBuilder gridBuilder = new GridBuilder(AjusteEstoqueRN.getInstance().getTabela(), colunas, "contagemestoque");
        gridBuilder.addReferenciaDefault(new Referencia("idFilial"));
        gridBuilder.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        gridBuilder.addCodicaoDefault(new Condicao("tipomovimentodefault", Operador.IGUAL, TipoAjusteEstoque.CONTAGEM.getId().intValue()));
        gridBuilder.addOrdemDefault(new Ordem("id", true));
        return gridBuilder;
    }

    protected String getCacheId() {
        return "contagens-estoque".concat("_").concat(SessaoUtil.getSessao().getIdFilial().toString());
    }

    protected void beforeRead(AjusteEstoque ajusteEstoque, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ajusteEstoque.setContagens(AjusteEstoqueContagemRN.getInstance().buscarListaPorAjuste(ajusteEstoque.getId()));
        ajusteEstoque.setAjusteEstoqueOriginal((AjusteEstoque)AjusteEstoqueRN.getInstance().clonar((AbstractPojo)ajusteEstoque));
        ajusteEstoque.getAjusteEstoqueOriginal().setId(ajusteEstoque.getId());
        if (!ListMapUtil.listNullOrEmpty((List)ajusteEstoque.getContagens())) {
            ajusteEstoque.getContagens().forEach(contagem -> {
                if (!NumberUtil.longNullOuZero((Long)contagem.getIdProduto())) {
                    Map map = ProdutoRN.getInstance().buscarValoresPorID(contagem.getIdProduto(), new String[]{"codigo", "nome"});
                    contagem.setCodigoProduto(map.get("codigo").toString());
                    contagem.setDescricaoProduto(map.get("nome").toString());
                } else if (!NumberUtil.longNullOuZero((Long)contagem.getIdGrupoProduto())) {
                    Object descricao = HierarquiaGrupoProdutoRN.getInstance().buscarValorPorID(contagem.getIdGrupoProduto(), "nome");
                    contagem.setDescricaoGrupoProduto("" + descricao);
                } else if (!NumberUtil.longNullOuZero((Long)contagem.getIdFamilia())) {
                    Object descricao = FamiliaProdutoRN.getInstance().buscarValorPorID(contagem.getIdFamilia(), "nome");
                    contagem.setDescricaoFamilia("" + descricao);
                } else if (!NumberUtil.longNullOuZero((Long)contagem.getIdFornecedor())) {
                    Map map = EntidadeRN.getInstance().buscarValoresPorID(contagem.getIdFornecedor(), new String[]{"codigo", "nome"});
                    contagem.setCodigoProduto(map.get("codigo").toString());
                    contagem.setDescricaoFornecedor(map.get("nome").toString());
                }
            });
        }
    }

    protected void beforeCreate(AjusteEstoque ajusteEstoque, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ajusteEstoque.setIdUsuario(sessao.getIdUsuario());
        ajusteEstoque.setIdFilial(sessao.getIdFilial());
        ajusteEstoque.setStatus(StatusAjusteEstoque.PENDENTE);
        ajusteEstoque.setTipoMovimento(TipoAjusteEstoque.CONTAGEM);
    }

    protected void beforeImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        uViewer.getVisualizador().setTitulo("Contagem de estoque - " + impressaoCrudWrapper.getDados().get("codigo"));
    }

    protected void afterImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        boolean isInclusaoAlteracao;
        boolean bl = isInclusaoAlteracao = impressaoCrudWrapper.getModo() == 0 || impressaoCrudWrapper.getModo() == 1;
        if (impressaoCrudWrapper.getDados().containsKey("listaInventarioEstoqueItem")) {
            boolean expedicaoAtiva = ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO);
            uViewer.saltaLinha();
            if (isInclusaoAlteracao) {
                if (expedicaoAtiva) {
                    uViewer.inicioNivel(new int[]{10, 20, 10, 10, 10, 10, 10, 10, 10});
                } else {
                    uViewer.inicioNivel(new int[]{10, 25, 10, 15, 10, 10, 10, 10});
                }
            } else if (expedicaoAtiva) {
                uViewer.inicioNivel(new int[]{10, 25, 10, 15, 15, 15, 15});
            } else {
                uViewer.inicioNivel(new int[]{10, 25, 10, 15, 20, 20});
            }
            uViewer.inicioTitulo();
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("UN", false);
            uViewer.escreveTitulo("Emb.", true);
            if (expedicaoAtiva) {
                uViewer.escreveTitulo("Pedente retirada", true);
            }
            uViewer.escreveTitulo("Quantidade", true);
            uViewer.escreveTitulo("Total", true);
            if (isInclusaoAlteracao) {
                uViewer.escreveTitulo("Saldo total", true);
                uViewer.escreveTitulo("Diferen\u00e7a", true);
            }
            uViewer.fimTitulo();
            List listaItens = (List)impressaoCrudWrapper.getDados().get("listaInventarioEstoqueItem");
            Map mapQuantidadePendenteRetirar = new HashMap();
            if (expedicaoAtiva) {
                List idsProdutos = listaItens.stream().map(map -> Util.string2Long((String)map.get("idProduto").toString())).collect(Collectors.toList());
                mapQuantidadePendenteRetirar = RetiradaRN.getInstance().buscarMapQuantidadePendenteRetirar(idsProdutos);
            }
            for (Map mapItem : listaItens) {
                int casasDecimais;
                uViewer.inicioLinha();
                uViewer.escreveColuna((String)mapItem.get("codigoProduto"));
                uViewer.escreveColuna((String)mapItem.get("descricaoProduto"));
                uViewer.escreveColuna((String)mapItem.get("unidadeMedida"));
                uViewer.escreveColuna(((Integer)mapItem.get("fatorConversao")).intValue());
                int n = casasDecimais = mapItem.get("casasDecimaisUN") != null ? (Integer)mapItem.get("casasDecimaisUN") : 2;
                if (expedicaoAtiva) {
                    BigDecimal qtdeRetirada = (BigDecimal)mapQuantidadePendenteRetirar.get(Util.string2Long((String)mapItem.get("idProduto").toString()));
                    uViewer.escreveColuna(qtdeRetirada, casasDecimais, true);
                }
                uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidade"), casasDecimais));
                uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidadeTotal"), casasDecimais));
                if (isInclusaoAlteracao) {
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("saldoEstoque"), casasDecimais));
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("diferencaEstoque"), casasDecimais));
                }
                uViewer.fimLinha();
                if (!mapItem.containsKey("filhosKit")) continue;
                List listaItensKit = (List)mapItem.get("filhosKit");
                for (Map mapItemKit : listaItensKit) {
                    int casasDecimaisKit;
                    uViewer.inicioLinha();
                    uViewer.escreveColuna("  " + mapItemKit.get("codigoProduto"));
                    uViewer.escreveColuna((String)mapItemKit.get("descricaoProduto"));
                    uViewer.escreveColuna((String)mapItemKit.get("unidadeMedida"));
                    uViewer.escreveColuna(((Integer)mapItemKit.get("fatorConversao")).intValue());
                    int n2 = casasDecimaisKit = mapItemKit.get("casasDecimaisUN") != null ? (Integer)mapItem.get("casasDecimaisUN") : 2;
                    if (expedicaoAtiva) {
                        BigDecimal qtdeRetirada = (BigDecimal)mapQuantidadePendenteRetirar.get(Util.string2Long((String)mapItemKit.get("idProduto").toString()));
                        uViewer.escreveColuna(qtdeRetirada, casasDecimais, true);
                    }
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("quantidade"), casasDecimaisKit));
                    uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("quantidadeTotal"), casasDecimais));
                    if (isInclusaoAlteracao) {
                        uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("saldoEstoque"), casasDecimais));
                        uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItemKit.get("diferencaEstoque"), casasDecimais));
                    }
                    uViewer.fimLinha();
                }
            }
            uViewer.fimNivel();
        }
    }
}

