/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato.evento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.vendas.ContratoVendaEvento;
import br.intelidata.commons.domain.pojo.vendas.TipoEventoContrato;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaEventoRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioSiteRN;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contratos-eventos"})
public class ContratoEventoCrudController
extends CrudController<ContratoVendaEvento, ContratoVendaEventoRN> {
    private final ModuloService moduloService;

    public ContratoEventoCrudController(ModuloService moduloService) {
        super((AbstractRegraNegocio)ContratoVendaEventoRN.getInstance(), ContratoVendaEvento::new, true, true);
        this.moduloService = moduloService;
        this.dependsOn("idContrato");
    }

    protected String getCacheId() {
        return "contratos-eventos";
    }

    protected GridBuilder<ContratoVendaEventoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idContrato", "idContrato", 0, false));
        colunas.add(new ColunaSQL("idUsuario", "idUsuario", 0, false));
        colunas.add(new ColunaSQL("web", "web", 0, false));
        colunas.add(new ColunaSQL("dataHora", "Data / Hora", 140, true));
        colunas.add(new ColunaSQL("tipoEvento", "Tipo", 200, true, TipoEventoContrato.class));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 200, true, new String[]{"fk_contratovendaevt_usuario"}));
        colunas.add(new ColunaSQL("observacao", "Observacao", 0, true));
        GridBuilder grid = new GridBuilder(((ContratoVendaEventoRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idContrato"));
        grid.setOrdemDefault(new Ordem("dataHora"));
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        if (this.moduloService.isAtivo(Modulo.INTELIDATA)) {
            dados.forEach(registro -> {
                String web = (String)registro[this.getIndexColuna("web", colunas)];
                int indexNome = this.getIndexColuna("nomeUsuario", colunas);
                if (web.equalsIgnoreCase(EnumSimNao.SIM.getDescricao())) {
                    Long idUsuario = (Long)registro[this.getIndexColuna("idUsuario", colunas)];
                    registro[indexNome] = UsuarioSiteRN.getInstance().buscarValoresPorID(idUsuario, new String[]{"nome"}).getOrDefault("nome", "") + " (Portal)";
                } else {
                    registro[indexNome] = registro[indexNome] + " (G-nio)";
                }
            });
        }
    }
}

