/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.davs.orcamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavCrudController;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="dav_orcamento", QUANTIDADE=QuantidadeCampoExtra.DAV)
@Component(value="orcamentos")
@RestController
@RequestMapping(value={"/api/orcamentos"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Or\u00e7amentos", ROTA="/vendas/orcamentos", ICONE="icon-orcamento", PROGRAMA=103)
public class OrcamentoCrudController
extends DavCrudController {
    public OrcamentoCrudController(FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService) {
        super(funcionalidadeService, atacarejoService, moduloService, TipoDocumentoDAV.ORCAMENTO);
    }

    @RequestMapping(value={"/gerar-orcs-fat"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarOrcamentosFaturamento(@RequestBody List<Long> idsOrcamentos) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty(idsOrcamentos)) {
            for (Long id : idsOrcamentos) {
                OrcamentoFaturamentoRN.getInstance().importarDav(SessaoUtil.getSessao(), id);
            }
        }
    }
}

