/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.desmontagem.configuracao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.desmontagem.ConfiguracaoDesmontagem;
import br.intelidata.commons.domain.pojo.desmontagem.FormaGeracaoDesmontagem;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoCustoDesmontagemGestao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-desmontagem"})
public class ConfiguracaoDesmontagemCrudController
extends SimpleCrudController<ConfiguracaoDesmontagem, FilialRN> {
    public ConfiguracaoDesmontagemCrudController() {
        super((AbstractRegraNegocio)FilialRN.getInstance());
    }

    @DBAutoCommit
    public ConfiguracaoDesmontagem get(Long parentId) {
        Filial filial = SessaoUtil.getSessao().getFilial();
        ConfiguracaoDesmontagem conf = new ConfiguracaoDesmontagem();
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 372)) {
            conf.setIdOperacaoFiscalNotaItensPerda(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 963)));
            conf.setIdOperacaoFiscalNotaItensReclassificado(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 962)));
            conf.setIdOperacaoFiscalNotaItensMestre(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 961)));
        } else {
            conf.setIdCfopNotaItensPerda(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 384)));
            conf.setIdCfopNotaItensReclassificado(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 383)));
            conf.setIdCfopNotaItensMestre(Long.valueOf(PropriedadeRN.getInstance().getPropriedadeLong(filial, 382)));
        }
        conf.setLancarNotaPerda(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 385));
        conf.setLancarNotaReclassificacao(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 998));
        conf.setLancarNotaMestre(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 999));
        conf.setMovimentarEstoquePerda(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 968));
        String valorFormaGeracao = PropriedadeRN.getInstance().getPropriedadeString(filial, 966);
        conf.setFormaGeracaoDesmontagem((FormaGeracaoDesmontagem)EnumUtils.getPorId(FormaGeracaoDesmontagem.class, (Object)NumberUtil.string2int((String)valorFormaGeracao)));
        conf.setCalcularCusto(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 1001));
        conf.setPreVisualizarDesmontagem(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 1005));
        String valorTipoCustoDesmontagem = PropriedadeRN.getInstance().getPropriedadeString(filial, 967);
        conf.setTipoCustoDesmontagem((TipoCustoDesmontagemGestao)EnumUtils.getPorId(TipoCustoDesmontagemGestao.class, (Object)NumberUtil.string2int((String)valorTipoCustoDesmontagem)));
        return conf;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ConfiguracaoDesmontagem conf) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372)) {
            PropriedadeRN.getInstance().setPropriedade(sessao, 963, conf.getIdOperacaoFiscalNotaItensPerda());
            PropriedadeRN.getInstance().setPropriedade(sessao, 962, conf.getIdOperacaoFiscalNotaItensReclassificado());
            PropriedadeRN.getInstance().setPropriedade(sessao, 961, conf.getIdOperacaoFiscalNotaItensMestre());
        } else {
            PropriedadeRN.getInstance().setPropriedade(sessao, 384, conf.getIdCfopNotaItensPerda());
            PropriedadeRN.getInstance().setPropriedade(sessao, 383, conf.getIdCfopNotaItensReclassificado());
            PropriedadeRN.getInstance().setPropriedade(sessao, 382, conf.getIdCfopNotaItensMestre());
        }
        PropriedadeRN.getInstance().setPropriedade(sessao, 999, Boolean.valueOf(conf.isLancarNotaMestre()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 998, Boolean.valueOf(conf.isLancarNotaReclassificacao()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 385, Boolean.valueOf(conf.isLancarNotaPerda()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 968, Boolean.valueOf(conf.isMovimentarEstoquePerda()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 1001, Boolean.valueOf(conf.isCalcularCusto()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 1005, Boolean.valueOf(conf.isPreVisualizarDesmontagem()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 967, conf.getTipoCustoDesmontagem() != null ? conf.getTipoCustoDesmontagem().getId() : null);
        PropriedadeRN.getInstance().setPropriedade(sessao, 966, conf.getFormaGeracaoDesmontagem() != null ? conf.getFormaGeracaoDesmontagem().getId() : FormaGeracaoDesmontagem.ESTIMATIVA.getId());
        return 0L;
    }
}

