/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.devolucao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.Devolucao;
import br.intelidata.commons.domain.pojo.DevolucaoItem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.SaldoDevolucao;
import br.intelidata.commons.domain.pojo.enuns.StatusDevolucao;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.financeiro.Comissao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.modulo.comissao.regranegocio.ComissaoRN;
import br.intelidata.commons.modulo.devolucao.regranegocio.DevolucaoItemRN;
import br.intelidata.commons.modulo.devolucao.regranegocio.DevolucaoRN;
import br.intelidata.commons.modulo.devolucao.regranegocio.SaldoDevolucaoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.crud.devolucao.DevolucaoImportadaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.devolucao.DevolucaoItemWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.devolucao.ParametrosImportacaoDevolucaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="devolucoes")
@RequestMapping(value={"/api/devolucoes"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Devolu\u00e7\u00f5es", ROTA="/vendas/devolucoes", ICONE="icon-devolucao", PROGRAMA=104)
public class DevolucaoCrudController
extends ItemKitController<Devolucao, DevolucaoItemWeb, DevolucaoRN> {
    private final ModuloService moduloService;

    public DevolucaoCrudController(ModuloService moduloService) {
        super((AbstractRegraNegocio)DevolucaoRN.getInstance(), Devolucao::new, true, true);
        this.moduloService = moduloService;
        this.setItemSupplier(DevolucaoItemWeb::new);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Devolucao devolucao, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)devolucao, parentId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Devolucao devolucao, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update((AbstractPojo)devolucao, parentId);
    }

    @RequestMapping(value={"/gerar-nota-fiscal"})
    @DBAutoCommit
    public NotaFiscal gerarNotaFiscal(@RequestParam Long idDevolucao, @RequestParam(required=false) Long idOperacaoFiscal) throws UnicoMensagemUsuarioException {
        return NotaFiscalRN.getInstance().importarDevolucao(SessaoUtil.getSessao(), Collections.singletonList(idDevolucao), idOperacaoFiscal);
    }

    @RequestMapping(value={"/saldo"})
    @DBAutoCommit
    public SaldoDevolucao carregaDados(@RequestParam Long idOrigem, @RequestParam int origem, @RequestParam Long idProduto, @RequestParam BigDecimal total) {
        List saldoDevolucoes;
        if (!Util.longNullOuZero((Long)idOrigem) && !Util.listNullOrEmpty((List)(saldoDevolucoes = SaldoDevolucaoRN.getInstance().getSaldoDevolucao(idProduto, idOrigem, origem)))) {
            SaldoDevolucao saldoDevolucao = (SaldoDevolucao)saldoDevolucoes.get(0);
            BigDecimal saldo = saldoDevolucao.getSaldo().setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal quantidade = saldoDevolucao.getQuantidade().setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal diferenca = saldo.subtract(total);
            saldoDevolucao.setSaldo(saldo);
            saldoDevolucao.setQuantidade(quantidade);
            saldoDevolucao.setDiferenca(diferenca);
            return saldoDevolucao;
        }
        return null;
    }

    @RequestMapping(value={"/importar-operacao"})
    @DBAutoCommit
    public Devolucao gerarDevolucaoOperacao(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (operacao != null) {
            return DevolucaoRN.getInstance().geraDevolucao(SessaoUtil.getSessao(), operacao);
        }
        throw new UnicoMensagemUsuarioException("WDEV18", "Opera\u00e7\u00e3o n\u00e3o encontrada. Verifique!");
    }

    @RequestMapping(value={"/importar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public DevolucaoImportadaWrapper importarDevolucao(@RequestBody ParametrosImportacaoDevolucaoWrapper parametros) throws UnicoMensagemUsuarioException {
        Devolucao devolucao;
        Operacao operacao;
        DevolucaoImportadaWrapper wrapper = null;
        if (parametros.getModelo() == ModeloNotaFiscal.CUPOM_FISCAL) {
            if (parametros.getCoo() != 0 && parametros.getPdv() != 0 && (operacao = OperacaoRN.getInstance().getObjetoPorPdvCooFilial(Integer.valueOf(parametros.getPdv()), Integer.valueOf(parametros.getCoo()), SessaoUtil.getSessao().getFilial().getCodigo())) != null) {
                devolucao = DevolucaoRN.getInstance().geraDevolucao(SessaoUtil.getSessao(), operacao);
                this.carregaVendedor(devolucao);
                wrapper = new DevolucaoImportadaWrapper(devolucao, Collections.singletonList(OperacaoRN.getInstance().buscarOperacaoCompletaPorId(operacao.getId())), operacao.getId());
            }
            if (wrapper == null) {
                throw new UnicoMensagemUsuarioException("WDEV20", "N\u00famero de COO/PDV inv\u00e1lido.");
            }
        } else if (parametros.getModelo() == ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA || parametros.getModelo() == ModeloNotaFiscal.NOTA_FISCAL_MODELO_01) {
            if (Util.stringNullOrEmpty((String)parametros.getNumeroNotaFiscal())) {
                throw new UnicoMensagemUsuarioException("WDEV22", "Por favor informe o n\u00famero.");
            }
            if (Util.stringNullOrEmpty((String)parametros.getSerieNotaFiscal())) {
                throw new UnicoMensagemUsuarioException("WDEV23", "Por favor informe a s\u00e9rie.");
            }
            NotaFiscal notaFiscal = NotaFiscalRN.getInstance().buscarNota(parametros.getNumeroNotaFiscal(), parametros.getModelo().getId(), parametros.getSerieNotaFiscal(), SessaoUtil.getSessao().getFilial().getId(), TipoNotaFiscal.SAIDA, null);
            if (notaFiscal != null) {
                wrapper = new DevolucaoImportadaWrapper(DevolucaoRN.getInstance().geraDevolucao(SessaoUtil.getSessao(), notaFiscal));
            }
        } else if (parametros.getModelo() == ModeloNotaFiscal.CUPOM_FISCAL_SAT) {
            if (Util.stringNullOrEmpty((String)parametros.getSat())) {
                throw new UnicoMensagemUsuarioException("WDEV29", "Por favor informe o n\u00famero SAT.");
            }
            operacao = OperacaoRN.getInstance().buscaNFCEAutorizada(SessaoUtil.getSessao().getFilial().getCodigo(), ModeloNotaFiscal.CUPOM_FISCAL_SAT.getId(), "", Util.zeroEsquerda((String)parametros.getSat(), (int)6));
            if (operacao != null) {
                devolucao = DevolucaoRN.getInstance().geraDevolucao(SessaoUtil.getSessao(), operacao, 42);
                this.carregaVendedor(devolucao);
                wrapper = new DevolucaoImportadaWrapper(devolucao);
            }
        } else {
            if (Util.stringNullOrEmpty((String)parametros.getNumeroNfce())) {
                throw new UnicoMensagemUsuarioException("WDEV24", "Por favor informe o n\u00famero");
            }
            if (Util.stringNullOrEmpty((String)parametros.getSerieNfce())) {
                throw new UnicoMensagemUsuarioException("WDEV25", "Por favor informe a s\u00e9rie");
            }
            operacao = OperacaoRN.getInstance().buscaNFCEAutorizada(SessaoUtil.getSessao().getFilial().getCodigo(), ModeloNotaFiscal.NOTA_FISCAL_CONSUMIDOR_ELETRONICA.getId(), parametros.getSerieNfce(), Util.zeroEsquerda((String)parametros.getNumeroNfce(), (int)8));
            if (operacao != null) {
                devolucao = DevolucaoRN.getInstance().geraDevolucao(SessaoUtil.getSessao(), operacao, 35);
                this.carregaVendedor(devolucao);
                wrapper = new DevolucaoImportadaWrapper(devolucao);
            }
        }
        if (wrapper != null) {
            BigDecimal totalQuantidade = BigDecimal.ZERO;
            BigDecimal totalProdutos = BigDecimal.ZERO;
            BigDecimal descontoProdutos = BigDecimal.ZERO;
            BigDecimal outrasDespesas = BigDecimal.ZERO;
            for (DevolucaoItem item : wrapper.getDevolucao().getItens()) {
                if (item.getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue()) continue;
                descontoProdutos = descontoProdutos.add(item.getDesconto());
                outrasDespesas = outrasDespesas.add(item.getOutrasDespesas());
                totalQuantidade = totalQuantidade.add(item.getQuantidade());
                totalProdutos = totalProdutos.add(item.getTotal());
            }
            BigDecimal percentual = wrapper.getDevolucao().getPercentualDescontoSubTotal();
            BigDecimal descontoSubTotal = percentual != null && percentual.compareTo(BigDecimal.ZERO) > 0 ? Util.valorDesconto((BigDecimal)totalProdutos, (BigDecimal)percentual, (int)2) : wrapper.getDevolucao().getDescontoSubTotal();
            BigDecimal valorLiquido = totalProdutos.subtract(descontoSubTotal).add(outrasDespesas).setScale(2, RoundingMode.HALF_DOWN);
            wrapper.getDevolucao().setOutrasDespesas(outrasDespesas);
            wrapper.getDevolucao().setTotalProdutos(totalProdutos);
            wrapper.getDevolucao().setDescontoSubTotal(descontoSubTotal);
            wrapper.getDevolucao().setValor(valorLiquido);
        }
        return wrapper;
    }

    @RequestMapping(value={"/buscar-preco-embalagem"})
    @DBAutoCommit
    public BigDecimal getPreco(@RequestParam Long idProduto, @RequestParam Long idEmbalagem, @RequestParam(required=false) String variacoes) {
        return ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(SessaoUtil.getSessao().getFilial(), idProduto, Long.valueOf(0L), VariacaoRN.getInstance().stringToMap(variacoes), idEmbalagem)).getPreco();
    }

    @RequestMapping(value={"/buscar-itens"})
    @DBAutoCommit
    public List<DevolucaoItem> buscarItens(@RequestParam Long idDevolucao) {
        return this.agruparItensKit(DevolucaoItemRN.getInstance().buscarListaPorIdDevolucao(idDevolucao));
    }

    protected String getCacheId() {
        return "devolucoes_id_filial_" + SessaoUtil.getSessao().getFilial().getId();
    }

    protected void beforeRead(Devolucao devolucao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (modo != 4 && (!NumberUtil.longNullOuZero((Long)devolucao.getIdNotaFiscal()) || devolucao.getStatus() == StatusDevolucao.CANCELADO || devolucao.getStatus() == StatusDevolucao.PDV && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 400) || devolucao.getStatus() == StatusDevolucao.NOTA_FISCAL)) {
            throw new UnicoMensagemUsuarioException("WWW203", "N\u00e3o \u00e9 poss\u00edvel alterar essa devolu\u00e7\u00e3o");
        }
    }

    protected void beforeDelete(Devolucao devolucao) throws UnicoMensagemUsuarioException {
        if (!NumberUtil.longNullOuZero((Long)devolucao.getIdNotaFiscal()) || devolucao.getStatus() == StatusDevolucao.CANCELADO || devolucao.getStatus() == StatusDevolucao.PDV && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 400) || devolucao.getStatus() == StatusDevolucao.NOTA_FISCAL) {
            throw new UnicoMensagemUsuarioException("WWW204", "N\u00e3o \u00e9 poss\u00edvel excluir essa devolu\u00e7\u00e3o");
        }
        devolucao.setItens(DevolucaoItemRN.getInstance().buscarListaPorIdDevolucao(devolucao.getId()));
    }

    protected GridBuilder<DevolucaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idNotaFiscal", "idnotafiscal", 0, false));
        colunas.add(new ColunaSQL("id", "idfilial", "Filial", 0, false, new String[]{"fk_devolucao_filial"}));
        colunas.add(new ColunaSQL("codigo", "filial", "Filial", 80, true, new String[]{"fk_devolucao_filial"}));
        colunas.add(new ColunaSQL("codigo", "Documento", 120, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 0, true, new String[]{"fk_devolucao_cliente"}));
        colunas.add(new ColunaSQL("data", "Data", 120, true));
        colunas.add(new ColunaSQL("valor", "Valor", 120, true));
        colunas.add(new ColunaSQL("saldo", "Saldo", 120, true));
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        colunas.add(new ColunaSQL("notaFiscalGerada", "NF", 80, true, EnumSimNao.class));
        GridBuilder grid = new GridBuilder(((DevolucaoRN)this.rn).getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.setOrdemDefault(new Ordem("data", true));
        return grid;
    }

    public ProdutoItemWeb<DevolucaoItemWeb> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Long idRepresentante;
        Long idCliente;
        Object[] novosTipos;
        Entidade cliente = null;
        Entidade representante = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        Sessao sessao = SessaoUtil.getSessao();
        boolean permiteSemIdentificar = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 327);
        if (!parametros.containsKey((Object)"idCliente") && !permiteSemIdentificar) {
            throw new UnicoMensagemUsuarioException("WWW201", "Por favor informe o cliente antes de informar o produto.");
        }
        if (!parametros.containsKey((Object)"idRepresentante")) {
            throw new UnicoMensagemUsuarioException("WWW202", "Por favor informe o vendedor antes de informar o produto.");
        }
        if (parametros.containsKey((Object)"tiposEmbalagem") && !Util.arrayNullOrEmpty((Object[])(novosTipos = StringUtil.getFirstMap(parametros, (String)"tiposEmbalagem").split(",")))) {
            for (Object novosTipo : novosTipos) {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, (String)novosTipo);
                if (tipos.contains(tipoEmbalagem)) continue;
                tipos.add(tipoEmbalagem);
            }
        }
        if (!permiteSemIdentificar && !NumberUtil.longNullOuZero((Long)(idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente")))) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        if (!NumberUtil.longNullOuZero((Long)(idRepresentante = StringUtil.convertFirstValueMapToLong(parametros, (String)"idRepresentante")))) {
            representante = (Entidade)EntidadeRN.getInstance().buscarPorId(idRepresentante);
        }
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        DevolucaoItemWeb dev = new DevolucaoItemWeb();
        dev.setQuantidade(BigDecimal.ONE);
        if (this.moduloService.isAtivo(Modulo.COMISSAO)) {
            Comissao comissao = ComissaoRN.getInstance().getComissao(SessaoUtil.getSessao().getFilial(), representante, (Produto)ProdutoRN.getInstance().buscarPorId(produto.getId()), null, Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            dev.setComissao(comissao.getComissao());
            dev.setComissaoAVista(comissao.getComissaoAVista());
            dev.setComissaoAPrazo(comissao.getComissaoAPrazo());
            dev.setComissaoQuitacao(comissao.getComissaoQuitacao());
        }
        produtoItem.setItem((ItemWeb)dev);
        produtoItem.setProduto(produto);
        new ProdutoItemRN().carregaItem(SessaoUtil.getSessao(), produtoItem, cliente, null, null, Long.valueOf(0L), false, true, true, TipoValorPreco.PRECO, false, false, false, null, tipos, false, null, 3, false);
        return produtoItem;
    }

    protected void beforeSave(Devolucao devolucao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        devolucao.setItens(this.separarItensKit(devolucao.getItens()));
        devolucao.getItens().forEach(item -> {
            if (!StringUtil.stringNullOrEmpty((String)item.getVariacoes())) {
                item.setDescricaoVariacoes(VariacaoRN.getInstance().getDescricaoPorVariacoesQuantidade(item.getIdproduto(), item.getVariacoes()));
            }
        });
    }

    private void carregaVendedor(Devolucao devolucao) {
        Entidade vendedor2;
        Entidade vendedor;
        String codigoVendedor = null;
        String codigoVendedor2 = null;
        for (DevolucaoItem devItem : devolucao.getItens()) {
            Item opItem = (Item)ItemRN.getInstance().buscarPorId(devItem.getIdOperacaoItem());
            if (opItem == null || Util.stringNullOrEmpty((String)opItem.getVendedor())) continue;
            if (codigoVendedor == null) {
                codigoVendedor = opItem.getVendedor();
            } else if (!opItem.getVendedor().equals(codigoVendedor)) {
                codigoVendedor = null;
                break;
            }
            if (codigoVendedor2 == null) {
                codigoVendedor2 = opItem.getVendedor2();
                continue;
            }
            if (opItem.getVendedor2().equals(codigoVendedor2)) continue;
            codigoVendedor2 = "";
        }
        if (codigoVendedor != null && (vendedor = (Entidade)EntidadeRN.getInstance().buscarPorCodigo(codigoVendedor)) != null) {
            devolucao.setIdrepresentante(vendedor.getId());
        }
        if (!Util.stringNullOrEmpty(codigoVendedor2) && (vendedor2 = (Entidade)EntidadeRN.getInstance().buscarPorCodigo(codigoVendedor2)) != null) {
            devolucao.setIdrepresentante2(vendedor2.getId());
        }
    }

    protected void recalcularItensImportacaoDevolucao(ProdutoItemWeb<DevolucaoItemWeb> produtoItem, BigDecimal quantidade) {
        DevolucaoItem item = (DevolucaoItem)produtoItem.getItem();
        BigDecimal novoOutrasDespesas = quantidade.multiply(item.getOutrasDespesasImportada()).divide(item.getQuantidadeImportada(), 10, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal novoDescontoSubTotal = quantidade.multiply(item.getDescontoSubTotalImportado()).divide(item.getQuantidadeImportada(), 10, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal novoDesconto = quantidade.multiply(item.getDescontoImportado()).divide(item.getQuantidadeImportada(), 10, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal novoFrete = quantidade.multiply(item.getFreteImportado()).divide(item.getQuantidadeImportada(), 10, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal novoTotal = quantidade.multiply(item.getPreco()).subtract(novoDesconto).setScale(2, RoundingMode.HALF_EVEN);
        item.setQuantidade(quantidade);
        item.setOutrasDespesas(novoOutrasDespesas);
        item.setFrete(novoFrete);
        item.setDesconto(novoDesconto);
        item.setDescontoSubTotal(novoDescontoSubTotal);
        item.setTotal(novoTotal);
    }
}

