/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.ProdutoEcommerce;
import br.intelidata.commons.domain.pojo.TipoAnuncioMercadoLivre;
import br.intelidata.commons.domain.pojo.TipoAnuncioMercadoLivreWeb;
import br.intelidata.commons.domain.pojo.ecommerce.ConfiguracaoEcommerceTipoPedido;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoEcommerce;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.CategoriaMercadoLivreCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoAtributoCategoriaMercadoLivreCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoAnuncioMercadoLivreCommonRN;
import br.intelidata.commons.domain.regranegocio.UnicoIntegracaoEcommerceRN;
import br.intelidata.commons.domain.regranegocio.ecommerce.ConfiguracaoEcommerceTipoPedidoRN;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.mercadolivre.produto.AtributoCategoriaMercadoLivreWeb;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.mercadolivre.produto.ModoShippingMercadoLivre;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.mercadolivre.produto.Shipping;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.mercadolivre.produto.ValorAtributoCategoriaMercadoLivre;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.mercadolivre.ProcessarEcommerceMercadoLivre;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.ecommerce.relatorio.InconsistenciaProdutoEcommerceRelatorio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.MultipartUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.GerarNotaFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.FaturamentoWrapper;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ecommerce/"})
public class EcommerceController {
    private final NotificationService notificationService;
    private final StorageService storageService;
    private ResponseEntityService responseEntityService;

    public EcommerceController(NotificationService notificationService, StorageService storageService, ResponseEntityService responseEntityService) {
        this.notificationService = notificationService;
        this.storageService = storageService;
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"combo-tipos-anuncio"})
    @DBAutoCommit
    public List<TipoAnuncioMercadoLivreWeb> getComboTiposAnuncio() {
        return TipoAnuncioMercadoLivreCommonRN.getInstance().buscarListaWeb();
    }

    @RequestMapping(value={"carregar-tipos-anuncio-mercadolivre"})
    @DBAutoCommit
    public void carregarTiposAnuncio(@RequestParam Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        TipoAnuncioMercadoLivreCommonRN.getInstance().popularTabela(SessaoUtil.getSessao(), idConfiguracaoEcommerce);
    }

    @RequestMapping(value={"carregar-categorias-mercadolivre"})
    @DBAutoCommit
    public void carregarCategorias(@RequestParam Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        CategoriaMercadoLivreCommonRN.getInstance().popularTabela(SessaoUtil.getSessao(), idConfiguracaoEcommerce);
    }

    @RequestMapping(value={"gerar-notafiscal"}, method={RequestMethod.POST})
    @DBTransaction
    public FaturamentoWrapper gerarNotaFiscal(@RequestBody GerarNotaFiscalWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Pedido pedido = this.getPedido(wrapper.getIdPedido());
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(pedido.getIdConfiguracaoEcommerce());
        NotaFiscal notaFiscal = UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)configuracaoEcommerce.getTipoIntegracao()).gerarNotaEcommerce(sessao, pedido, wrapper.getIdOperacaoFiscal());
        Filial filialNotaFiscal = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        for (NotaFiscalItem item : notaFiscal.getNotaFiscalItens()) {
            item.setItemPermiteDesconto(NotaFiscalItemRN.getInstance().permiteDescontoSubtotal(item, sessao.getFilial()));
        }
        for (int i = 0; i < notaFiscal.getNotaFiscalItens().size(); ++i) {
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setId(Long.valueOf(Long.parseLong(String.valueOf(-(i + 1)))));
        }
        Map criticas = NotaFiscalItemRN.getInstance().gerarCriticasFaturamentoWeb(filialNotaFiscal, notaFiscal.getNotaFiscalItens(), true);
        return new FaturamentoWrapper(Collections.singletonList(pedido.getId()), notaFiscal, criticas);
    }

    @RequestMapping(value={"buscar-atributos-categoria"})
    @DBAutoCommit
    public List<AtributoCategoriaMercadoLivreWeb> buscarAtributosCategoria(@RequestParam Long idCategoria, @RequestParam Long idProduto, @RequestParam Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        ConfiguracaoEcommerce configuracaoEcommerce;
        List listaAtributosBanco = null;
        if (idProduto != null) {
            listaAtributosBanco = ProdutoAtributoCategoriaMercadoLivreCommonRN.getInstance().buscarListaPorIdProduto(idProduto);
        }
        if (!(configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfiguracaoEcommerce)).getTipoIntegracao().equals((Object)TipoIntegracaoEcommerce.MERCADO_LIVRE)) {
            return null;
        }
        List atributos = CategoriaMercadoLivreCommonRN.getInstance().buscarAtributosCategoria(SessaoUtil.getSessao(), idCategoria, listaAtributosBanco, idProduto, configuracaoEcommerce);
        if (!Util.listNullOrEmpty((List)atributos)) {
            AtomicReference<Long> idx = new AtomicReference<Long>(0L);
            return atributos.stream().map(atr -> {
                idx.set((Long)idx.get() - 1L);
                AtributoCategoriaMercadoLivreWeb atrWeb = new AtributoCategoriaMercadoLivreWeb();
                atrWeb.setId((Long)idx.get());
                atrWeb.setCodigo(atr.getId());
                atrWeb.setNome(atr.getName());
                atrWeb.setTamanho(atr.getValueMaxLength());
                atrWeb.setTipo(atr.getValueType());
                atrWeb.setValorSelecionado(atr.getValorSelecionado());
                atrWeb.setObrigatorio(atr.getTags().isRequired());
                if (atr.getValues() != null) {
                    atrWeb.setValores(atr.getValues().stream().map(und -> {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", und.getId());
                        map.put("name", und.getName());
                        return map;
                    }).collect(Collectors.toList()));
                    if (atr.getValorSelecionado() != null) {
                        ValorAtributoCategoriaMercadoLivre valorAtributo = atr.getValues().stream().filter(val -> val.getId().equalsIgnoreCase(atr.getValorSelecionado().toString())).findFirst().orElse(null);
                        if (valorAtributo != null) {
                            atrWeb.setValorVisualizacao(valorAtributo.getName());
                        } else {
                            atrWeb.setValorVisualizacao(atr.getValorSelecionado().toString());
                        }
                    }
                } else if (atr.getValorSelecionado() != null) {
                    atrWeb.setValorVisualizacao(atr.getValorSelecionado().toString());
                }
                if (atr.getUnidades() != null) {
                    atrWeb.setUnidades(atr.getUnidades().stream().map(und -> {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", und.getId());
                        map.put("name", und.getName());
                        return map;
                    }).collect(Collectors.toList()));
                }
                if (atr.getUnidadeSelecionada() != null) {
                    atrWeb.setUnidadeSelecionada((Object)atr.getUnidadeSelecionada().getId());
                    atrWeb.setUnidadeVisualizacao(atr.getUnidadeSelecionada().getName());
                }
                return atrWeb;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @RequestMapping(value={"/refazer-associacao"})
    @DBAutoCommit
    public void refazerAssociacao(@RequestParam Long idConfiguracao) throws UnicoMensagemUsuarioException {
        ConfiguracaoEcommerce config = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfiguracao);
        UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)config.getTipoIntegracao()).excluirAssociacao(SessaoUtil.getSessao(), idConfiguracao);
    }

    @RequestMapping(value={"/imprimir-etiqueta-envio"})
    @DBAutoCommit
    public String imprimirEtiquetaEntregaEcommerce(@RequestParam Long idPedido) throws UnicoMensagemUsuarioException {
        String link;
        TipoIntegracaoEcommerce tipoIntegracaoEcommerce = this.getTipoIntegracao(idPedido);
        if (TipoIntegracaoEcommerce.CLIMBA.equals((Object)tipoIntegracaoEcommerce)) {
            link = (String)UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)tipoIntegracaoEcommerce).getEtiquetaEnvio(SessaoUtil.getSessao(), idPedido);
        } else if (TipoIntegracaoEcommerce.MERCADO_LIVRE.equals((Object)tipoIntegracaoEcommerce)) {
            File arquivo = (File)UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)tipoIntegracaoEcommerce).getEtiquetaEnvio(SessaoUtil.getSessao(), idPedido);
            link = this.storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Venda, MultipartUtil.montaMultiPartiPorBytes((byte[])FileUtil.file2ByteArray((File)arquivo), (String)"etiqueta_envio.pdf"), true);
            link = this.storageService.publishArquivo(link);
        } else {
            throw new UnicoMensagemUsuarioException("ECO337", "N\u00e3o \u00e9 poss\u00edvel imprimir etiqueta de envio para o pedido selecionado.");
        }
        return link;
    }

    private Pedido getPedido(Long idPedido) throws UnicoMensagemUsuarioException {
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(idPedido);
        if (pedido == null) {
            throw new UnicoMensagemUsuarioException("ECO113", "Pedido n\u00e3o encontrado");
        }
        if (Util.stringNullOrEmpty((String)pedido.getCodigoECommerce())) {
            throw new UnicoMensagemUsuarioException("ECO114", "Este documento n\u00e3o foi gerado a partir do E-commerce");
        }
        return pedido;
    }

    private TipoIntegracaoEcommerce getTipoIntegracao(Long idPedido) {
        Long idConfiguracaoEcommerce = (Long)PedidoRN.getInstance().buscarValoresPorID(idPedido, new String[]{"idconfiguracaoecommerce"}).get("idconfiguracaoecommerce");
        if (idConfiguracaoEcommerce != null) {
            Integer valorTipo = (Integer)ConfiguracaoEcommerceCommonRN.getInstance().buscarValoresPorID(idConfiguracaoEcommerce, new String[]{"tipointegracao"}).get("tipointegracao");
            return valorTipo != null ? (TipoIntegracaoEcommerce)EnumUtils.getPorId(TipoIntegracaoEcommerce.class, (Object)valorTipo) : null;
        }
        return null;
    }

    @RequestMapping(value={"buscar-anuncios-mercadolivre"})
    @DBAutoCommit
    public String buscarListaAnunciosMercadoLivre(@RequestParam Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        List listaProdutos = ((ProcessarEcommerceMercadoLivre)UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)TipoIntegracaoEcommerce.MERCADO_LIVRE).getProcessarEcommerce()).buscarTodosAnuncios(SessaoUtil.getSessao(), idConfiguracaoEcommerce);
        listaProdutos.forEach(produtoMercadoLivre -> {
            Shipping shipping;
            ModoShippingMercadoLivre modoShippingMercadoLivre;
            TipoAnuncioMercadoLivre tipoAnuncioMercadoLivre = (TipoAnuncioMercadoLivre)TipoAnuncioMercadoLivreCommonRN.getInstance().buscarPorCodigo(produtoMercadoLivre.getTipoAnuncio());
            if (tipoAnuncioMercadoLivre != null) {
                produtoMercadoLivre.setIdTipoAnuncio(tipoAnuncioMercadoLivre.getId());
            }
            produtoMercadoLivre.setModoShippingMercadoLivre((modoShippingMercadoLivre = (ModoShippingMercadoLivre)EnumUtils.getPorCampo(ModoShippingMercadoLivre.class, (String)"valorJSON", (Object)(shipping = produtoMercadoLivre.getShipping()).getMode())) != null ? modoShippingMercadoLivre.name() : "");
            produtoMercadoLivre.setFreteGratis(Boolean.valueOf(shipping.getFreeShipping() != null ? shipping.getFreeShipping() : false));
            produtoMercadoLivre.setRetiradaLocal(Boolean.valueOf(shipping.getLocalPickUp() != null ? shipping.getLocalPickUp() : false));
        });
        return JsonUtil.toJson((List)listaProdutos, (String[])new String[]{"id", "titulo", "preco", "estoque", "quantidadeVendida", "produto", "idConfiguracaoEcommerce", "idTipoAnuncio", "modoShippingMercadoLivre", "freteGratis", "retiradaLocal"});
    }

    @PostMapping(value={"verificar-possui-vendas-mercadolivre"})
    @DBAutoCommit
    public boolean isPossuivendas(@RequestBody ProdutoEcommerce produtoEcommerce) throws UnicoMensagemUsuarioException {
        if (produtoEcommerce == null || Util.longNullOuZero((Long)produtoEcommerce.getIdConfiguracaoEcommerce())) {
            return false;
        }
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(produtoEcommerce.getIdConfiguracaoEcommerce());
        ProcessarEcommerceMercadoLivre processarMercadoLivre = (ProcessarEcommerceMercadoLivre)UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)TipoIntegracaoEcommerce.MERCADO_LIVRE).getProcessarEcommerce();
        return processarMercadoLivre.isAnuncioPossuiVendas(SessaoUtil.getSessao(), configuracaoEcommerce, produtoEcommerce.getListaAnuncios());
    }

    @RequestMapping(value={"relatorio-inconsistencia"})
    @DBAutoCommit
    public ResponseEntity<byte[]> relatorioIncosistencias(@RequestParam Long idConfiguracaoEcommerce) throws UnicoMensagemUsuarioException {
        SaidaRelatorio saidaRelatorio = new SaidaRelatorio(1, "", false);
        Remessa remessa = new InconsistenciaProdutoEcommerceRelatorio().getRelatorio(saidaRelatorio, idConfiguracaoEcommerce, null, null);
        return this.responseEntityService.createFileResponse(remessa.getMalote().extrai("pdf"), MediaType.APPLICATION_PDF, "relatorio_inconsistencias.pdf");
    }

    @RequestMapping(value={"tipos-pedido"})
    @DBAutoCommit
    public List<ConfiguracaoEcommerceTipoPedido> buscarTiposPedidos(Long idConfiguracaoEcommerce) {
        return ConfiguracaoEcommerceTipoPedidoRN.getInstance().buscarPorIdConfiguracaoEcommerce(idConfiguracaoEcommerce);
    }
}

