/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.roteadortransacaofinanceira;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.b2c.RoteadorTransacaoFinanceira;
import br.intelidata.commons.domain.pojo.ecommerce.AbstractIdentificadorPendente;
import br.intelidata.commons.domain.pojo.enuns.ecommerce.TipoRoteadorEcommerce;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.b2c.IdentificadorPendenteTransacaoFinanceiraRN;
import br.intelidata.commons.domain.regranegocio.b2c.RoteadorTransacaoFinanceiraRN;
import br.intelidata.commons.domain.regranegocio.ecommerce.IdentificadorPendenteEcommerceRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/roteador-transacao-financeira"})
public class RoteadorTransacaoFinanceiraCrudController
extends CrudController<RoteadorTransacaoFinanceira, RoteadorTransacaoFinanceiraRN> {
    @Autowired
    public RoteadorTransacaoFinanceiraCrudController() {
        super((AbstractRegraNegocio)RoteadorTransacaoFinanceiraRN.getInstance(), RoteadorTransacaoFinanceira::new, true, true);
        this.dependsOn("idConfiguracaoEcommerce");
    }

    protected String getCacheId() {
        return "roteador-transacao-financeira";
    }

    protected GridBuilder<RoteadorTransacaoFinanceiraRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idConfiguracaoEcommerce", "ID Conf Ecommerce", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("entidade", "Entidade", 0, true));
        colunas.add(new ColunaSQL("meioPagamento", "Meio de pagamento", 0, true));
        colunas.add(new ColunaSQL("identificador", "Identificador", 0, true));
        GridBuilder grid = new GridBuilder(((RoteadorTransacaoFinanceiraRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("descricao"));
        return grid;
    }

    @RequestMapping(value={"identificadores-pendentes"})
    @DBTransaction
    public <E extends AbstractIdentificadorPendente> List<E> getIdentificadoresPendentes(@RequestParam(required=false) Long idConfiguracaoEcommerce, @RequestParam(required=false) TipoRoteadorEcommerce tipo) {
        if (tipo == null) {
            return IdentificadorPendenteTransacaoFinanceiraRN.getInstance().buscaListaPorIdConfiguracaoEcommerce(Long.valueOf(idConfiguracaoEcommerce == null ? 0L : idConfiguracaoEcommerce));
        }
        return IdentificadorPendenteEcommerceRN.getInstance().buscarConfiguracaoEcommerceTipoRoteador(idConfiguracaoEcommerce, tipo);
    }
}

