/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.spc;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.entidade.EntidadeSPCHistorico;
import br.intelidata.commons.domain.pojo.enuns.TipoOperacaoSPC;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.EntidadeSPCHistoricoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/historicos-spc"})
public class EntidadeSPCHistoricoCrudController
extends CrudController<EntidadeSPCHistorico, EntidadeSPCHistoricoCommonRN> {
    public EntidadeSPCHistoricoCrudController() {
        super((AbstractRegraNegocio)EntidadeSPCHistoricoCommonRN.getInstance(), EntidadeSPCHistorico::new);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(EntidadeSPCHistorico historicoSpc, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Entidade entidade;
        if (NumberUtil.longNullOuZero((Long)historicoSpc.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW51", "Entidade n\u00e3o informada");
        }
        if (historicoSpc.getDataOperacao() == null) {
            throw new UnicoMensagemUsuarioException("WENT63", "Data opera\u00e7\u00e3o n\u00e3o foi informada! Verifique.");
        }
        if (NumberUtil.longNullOuZero((Long)historicoSpc.getIdusuarioalteracao())) {
            historicoSpc.setIdusuarioalteracao(SessaoUtil.getSessao().getIdUsuario());
        }
        if ((entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(historicoSpc.getIdEntidade())) != null) {
            if (historicoSpc.getTipoOperacaoSPC().equals((Object)TipoOperacaoSPC.ICLUSAO)) {
                entidade.setRegistradoSpc(EnumSimNao.SIM);
            } else {
                entidade.setRegistradoSpc(EnumSimNao.NAO);
            }
            EntidadeRN.getInstance().alterar((AbstractPojo)entidade, SessaoUtil.getSessao());
        }
    }

    protected GridBuilder<EntidadeSPCHistoricoCommonRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idusuarioalteracao", "idusuarioalteracao", 0, false));
        colunas.add(new ColunaSQL("tipoOperacaoSPC", "Opera\u00e7\u00e3o", 500, true));
        colunas.add(new ColunaSQL("dataOperacao", "Data opera\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("nome", "usuarioalteracao", "Usuario", 150, true, new String[]{"fk_entidadespchist_usuario"}));
        return new GridBuilder(EntidadeSPCHistoricoCommonRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "historicos-spc";
    }
}

