/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.contato;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.crm.EntidadeContato;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.crm.regranegocio.EntidadeContatoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidade-contatos"})
public class EntidadeContatoCrudController
extends CrudController<EntidadeContato, EntidadeContatoRN> {
    public EntidadeContatoCrudController() {
        super((AbstractRegraNegocio)EntidadeContatoRN.getInstance(), EntidadeContato::new, false);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(EntidadeContato contatoEntidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)contatoEntidade.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW48", "Entidade n\u00e3o informada");
        }
    }

    protected GridBuilder<EntidadeContatoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idTipoContato", "idTipoContato", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("telefone", "Telefone", 0, true));
        colunas.add(new ColunaSQL("celular", "Celular", 0, true));
        colunas.add(new ColunaSQL("email", "E-mail", 0, true));
        colunas.add(new ColunaSQL("descricao", "tipoContato", "Tipo contato", 0, true, new String[]{"fk_entidadecontato_tipocontato"}));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(EntidadeContatoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id"));
        return grid;
    }

    protected String getCacheId() {
        return "entidade-contatos";
    }
}

