/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.desconto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EntidadeDesconto;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.TipoDesconto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDescontoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.desconto.EntidadeDescontoWrapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/descontos-entidade"})
public class EntidadeDescontoCrudController
extends CrudController<EntidadeDesconto, EntidadeDescontoRN> {
    public EntidadeDescontoCrudController() {
        super((AbstractRegraNegocio)EntidadeDescontoRN.getInstance(), EntidadeDesconto::new);
    }

    @RequestMapping(value={"/buscar-desconto"})
    @DBAutoCommit
    public EntidadeDesconto buscarDescontoEntidade(@RequestParam Long idCliente, @RequestParam Long idProduto) {
        return EntidadeDescontoRN.getInstance().buscaDescontoProduto((Entidade)EntidadeRN.getInstance().buscarPorId(idCliente), (Produto)ProdutoRN.getInstance().buscarPorId(idProduto));
    }

    protected String getCacheId() {
        return "descontos-entidade";
    }

    protected GridBuilder<EntidadeDescontoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        return new GridBuilder(EntidadeDescontoRN.getInstance().getTabela(), colunas);
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<EntidadeDesconto> buscarDescontos(@RequestParam Long idCliente) {
        return EntidadeDescontoRN.getInstance().buscarListaPorIdCliente(idCliente);
    }

    @PostMapping(value={"/buscar-por-grupo"})
    @DBAutoCommit
    public List<EntidadeDesconto> buscarDescontosPorGrupo(@RequestBody EntidadeDesconto entidadeDescontoPai) {
        HierarquiaGrupoProduto grupo;
        ArrayList<EntidadeDesconto> descontosPorGrupo = new ArrayList<EntidadeDesconto>();
        List filhas = HierarquiaGrupoProdutoRN.getInstance().buscarFilhas(entidadeDescontoPai.getIdGrupo(), false);
        if (filhas.isEmpty() && (grupo = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(entidadeDescontoPai.getIdGrupo())) != null) {
            filhas.add(grupo);
        }
        for (HierarquiaGrupoProduto hierarquiaGrupoProduto : filhas) {
            EntidadeDesconto desconto = new EntidadeDesconto();
            desconto.setTipoDesconto(TipoDesconto.DESCONTO_POR_GRUPO);
            desconto.setIdGrupo(hierarquiaGrupoProduto.getId());
            desconto.setDescricaoProdutoGrupo(hierarquiaGrupoProduto.getNome());
            desconto.setIdProduto(null);
            desconto.setPercentualDesconto(entidadeDescontoPai.getPercentualDesconto());
            desconto.setValorDesconto(entidadeDescontoPai.getValorDesconto());
            descontosPorGrupo.add(desconto);
        }
        return descontosPorGrupo;
    }

    @PostMapping(value={"/gravar"})
    @DBTransaction
    public void gravarDescontos(@RequestBody EntidadeDescontoWrapper wrapper) throws UnicoMensagemUsuarioException {
        EntidadeDescontoRN.getInstance().gravarDescontosPorEntidade(SessaoUtil.getSessao(), wrapper.getIdCliente(), wrapper.getDescontos());
    }
}

