/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.entidadeordemservico;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.OrdemServicoItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.OrdemServicoItemCommonRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoItemRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidade-os"})
public class EntidadeOrdemServicoCrudController
extends CrudController<OrdemServicoItem, OrdemServicoItemRN> {
    public EntidadeOrdemServicoCrudController() {
        super((AbstractRegraNegocio)OrdemServicoItemRN.getInstance(), OrdemServicoItem::new, true, true);
        this.dependsOn("idCliente");
    }

    protected String getCacheId() {
        return "entidade-os";
    }

    protected GridBuilder<?> getGridBuilder() {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "idOS", "ID", 0, false, new String[]{"fk_ordemservicoitem_ordemser"}));
        colunas.add(new ColunaSQL("codigo", "codigoOS", "C\u00f3digo", 120, true, new String[]{"fk_ordemservicoitem_ordemser"}));
        colunas.add(new ColunaSQL("data", "data", "Data", 150, true, new String[]{"fk_ordemservicoitem_ordemser"}));
        colunas.add(new ColunaSQL("status", "status", "Status", 150, true, new String[]{"fk_ordemservicoitem_ordemser"}));
        ColunaSQL colunaStatus = new ColunaSQL("status", "codigoStatus", "Status", 0, false, new String[]{"fk_ordemservicoitem_ordemser"});
        colunaStatus.setNaoAlterarValorEnum(true);
        colunas.add(colunaStatus);
        colunas.add(new ColunaSQL("descricao", "objeto", "Objeto", 300, true, new String[]{"fk_ordemservicoitem_ordemser", "fk_ordemservico_objeto"}));
        colunas.add(new ColunaSQL("codigo", "codigoProduto", "Prod./Serv.", 150, true, new String[]{"fk_ordemservicoitem_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeProduto", "Descr. prod/serv", 500, true, new String[]{"fk_ordemservicoitem_produto"}));
        colunas.add(new ColunaSQL("preco", "Pre\u00e7o", 120, sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS()));
        colunas.add(new ColunaSQL("quantidade", "Qtd.", 120, true));
        colunas.add(new ColunaSQL("total", "Total", 120, sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS()));
        GridBuilder gridController = new GridBuilder(OrdemServicoItemCommonRN.getInstance().getTabela(), colunas, "cliente_os");
        gridController.addReferenciaDefault(new Referencia("idfilial", "idfilial", new String[]{"fk_ordemservicoitem_ordemser"}));
        gridController.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, sessao.getFilial().getId()));
        gridController.addReferenciaDefault(new Referencia("idCliente", "idCliente", new String[]{"fk_ordemservicoitem_ordemser"}));
        gridController.setOrdemDefault(new Ordem("data"));
        return gridController;
    }
}

