/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.financeirocliente;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.FinanceiroLancamento;
import br.intelidata.commons.domain.pojo.RastreabilidadeDocumento;
import br.intelidata.commons.domain.pojo.enuns.StatusDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroLancamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.financeirocliente.FinanceiroClienteWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/financeiro-cliente"})
public class FinanceiroClienteSimpleController
extends SimpleCrudController<FinanceiroDado, FinanceiroDadoRN> {
    @RequestMapping(value={"/buscar-rastreabilidade"})
    @DBAutoCommit
    public List<RastreabilidadeDocumento> buscarRastreabilidade(@RequestParam Long idOrigem) {
        return FinanceiroDadoRN.getInstance().buscarListaRastreabilidade(idOrigem);
    }

    @RequestMapping(value={"/buscar-baixas"})
    @DBAutoCommit
    public List<FinanceiroLancamento> buscarBaixas(@RequestParam Long idDocumento) {
        return FinanceiroLancamentoRN.getInstance().buscarPorIdFinanceiro(idDocumento);
    }

    @RequestMapping(value={"/buscar-documentos"})
    @DBAutoCommit
    public List<FinanceiroClienteWrapper> buscarDocumentos(@RequestParam Long idCliente, @RequestParam Long statusDocumento, @RequestParam String campoBusca, @RequestParam LocalDate periodoInicial, @RequestParam LocalDate periodoFinal) {
        StatusDocumentoFinanceiro statusDocumentoFinanceiro = null;
        if (statusDocumento == 2L) {
            statusDocumentoFinanceiro = StatusDocumentoFinanceiro.QUITADO;
        } else if (statusDocumento == 3L) {
            statusDocumentoFinanceiro = StatusDocumentoFinanceiro.SUBSTITUIDO;
        } else if (statusDocumento == 4L) {
            statusDocumentoFinanceiro = StatusDocumentoFinanceiro.BAIXADO;
        } else if (statusDocumento == 1L || statusDocumento == 5L) {
            statusDocumentoFinanceiro = StatusDocumentoFinanceiro.ABERTO;
        }
        List list = FinanceiroDadoRN.getInstance().buscarDuplicatas(TipoFinanceiro.RECEBER, statusDocumentoFinanceiro, campoBusca, idCliente, periodoInicial, this.getDataFinalFiltro(periodoFinal, statusDocumento), null, null, true);
        return this.getDocumentosFinanceiro(list);
    }

    private List<FinanceiroClienteWrapper> getDocumentosFinanceiro(List<MapResultSet> list) {
        ArrayList<FinanceiroClienteWrapper> documentos = new ArrayList<FinanceiroClienteWrapper>();
        for (MapResultSet res : list) {
            FinanceiroClienteWrapper documento = new FinanceiroClienteWrapper();
            documento.setIddocumento((Long)res.get("iddocumento"));
            documento.setTipoDocumento((String)res.get("tipoDocumento"));
            documento.setFilial((String)res.get("filial"));
            documento.setNomeentidade((String)res.get("nomeentidade"));
            documento.setDocumento((String)res.get("documento"));
            documento.setStatusDocumento((String)res.get("statusDocumento"));
            documento.setEmissao((LocalDate)res.get("emissao"));
            documento.setVencimento((LocalDate)res.get("vencimento"));
            LocalDate pagamento = (LocalDate)res.get("pagamento");
            LocalDate hoje = DataHoraFactory.getData();
            documento.setDiasVencido(Util.getDiferencaEmDias((LocalDate)((LocalDate)res.get("vencimento")), (LocalDate)(pagamento != null ? pagamento : hoje)));
            documento.setValor((BigDecimal)res.get("valor"));
            documento.setSaldo((BigDecimal)res.get("saldo"));
            documento.setPagamento(pagamento);
            documento.setTipoCobranca((String)res.get("tipoCobranca"));
            documento.setDependente((String)res.get("dependente"));
            documentos.add(documento);
        }
        return documentos;
    }

    private LocalDate getDataFinalFiltro(LocalDate periodoFinal, Long statusDocumentoFinanceiro) {
        LocalDate periodo = periodoFinal;
        if (periodo == null && statusDocumentoFinanceiro != null) {
            periodo = statusDocumentoFinanceiro == 5L ? DataHoraFactory.getData() : DataHoraFactory.getLocalDateInicioMes();
        }
        return periodo;
    }
}

