/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.representante.roteirovenda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.RoteiroVenda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.RoteiroVendaItemRN;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.RoteiroVendaRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/roteiro-venda"})
@SubMenuMapping(MENU="", NOME="Roteiro venda", ROTA="/entidades/representantes/:idVendedor/roteiro-venda", PROGRAMA=5, CUSTOM_ACTION=true)
public class RoteiroVendaCrudController
extends CrudController<RoteiroVenda, RoteiroVendaRN> {
    public RoteiroVendaCrudController() {
        super((AbstractRegraNegocio)RoteiroVendaRN.getInstance(), RoteiroVenda::new);
        this.dependsOn("idVendedor");
    }

    protected String getCacheId() {
        return "roteiro-venda";
    }

    protected void beforeRead(RoteiroVenda roteiroVenda, int modo, Optional<Long> parentId) {
        roteiroVenda.setItens(RoteiroVendaItemRN.getInstance().buscarPorIdRoteiroVenda(roteiroVenda.getId()));
    }

    protected void beforeSave(RoteiroVenda roteiroVenda, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        roteiroVenda.getItens().stream().filter(item -> item.getId() <= 0L).forEach(item -> item.setId(null));
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 350, true));
        colunas.add(new ColunaSQL("datainicio", "Data Inicio", 0, true));
        colunas.add(new ColunaSQL("datafinal", "Data Final", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeVendedor", "Vendedor", 350, true, new String[]{"fk_roteirovenda_vendedor"}));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 350, true));
        GridBuilder grid = new GridBuilder(RoteiroVendaRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("datafinal", false));
        grid.addReferenciaDefault(new Referencia("idVendedor"));
        return grid;
    }
}

