/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.representante.roteirovendedor;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.RoteiroVendaVendedor;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.r2d2rest.controller.RoteiroController;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.RoteiroVendaRN;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.RoteiroVendaVendedorRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/roteiro-venda-vendedor"})
@SubMenuMapping(MENU="", NOME="Roteiro do vendedor", ROTA="/entidades/roteiro-venda-vendedor", PROGRAMA=5, CUSTOM_ACTION=true)
public class RoteiroVendaVendedorCrudController
extends SimpleCrudController<RoteiroVendaVendedor, RoteiroVendaVendedorRN> {
    public RoteiroVendaVendedorCrudController() {
        super((AbstractRegraNegocio)RoteiroVendaVendedorRN.getInstance());
    }

    @RequestMapping(value={"/buscar-lista"})
    @DBAutoCommit
    public List<RoteiroVendaVendedor> buscarPorIdVendedor(@RequestParam Long idVendedor) {
        Entidade vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(idVendedor);
        List roteirosVenda = RoteiroVendaRN.getInstance().buscarPorVendedor(vendedor);
        new RoteiroController().gerarRoteiroVendaCheckin(SessaoUtil.getSessao(), vendedor, roteirosVenda);
        return RoteiroVendaVendedorRN.getInstance().buscarPorVendedor(idVendedor);
    }

    @RequestMapping(value={"/gravar-lista"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravar(@RequestBody List<RoteiroVendaVendedor> listaRoteiros) throws UnicoMensagemUsuarioException {
        RoteiroVendaVendedorRN.getInstance().gravarLista(1, listaRoteiros, SessaoUtil.getSessao());
    }
}

