/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.estado.cidade.cep;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Cep;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CepRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.SqlHelperService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ceps"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarEnderecos", NOME="Ceps", ROTA="/enderecos/estados/:idEstado/cidades/:idCidade/ceps", PROGRAMA=85, CUSTOM_ACTION=true)
public class CepCrudController
extends CrudController<Cep, CepRN> {
    private SqlHelperService sqlHelperService;

    @Autowired
    public CepCrudController(SqlHelperService sqlHelperService) {
        super((AbstractRegraNegocio)CepRN.getInstance(), Cep::new);
        this.sqlHelperService = sqlHelperService;
    }

    @DBAutoCommit
    public boolean validCode(@RequestParam String value) throws UnicoMensagemUsuarioException {
        return !this.sqlHelperService.exists("cep", "cep", value);
    }

    @RequestMapping(value={"/buscar-cep"})
    @DBAutoCommit
    public Cep buscarCep(@RequestParam(name="cep") String cep) throws UnicoMensagemUsuarioException {
        Cep cepCadastrado = CepRN.getInstance().buscarPorCep(SessaoUtil.getSessao(), cep);
        if (cepCadastrado == null) {
            cepCadastrado = new Cep();
        }
        return cepCadastrado;
    }

    protected GridBuilder<CepRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCidade", "idCidade", 0, false));
        colunas.add(new ColunaSQL("cep", "CEP", 100, true));
        colunas.add(new ColunaSQL("endereco", "Endere\u00e7o", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeCidade", "Cidade", 0, true, new String[]{"fk_cep_cidade"}));
        return new GridBuilder(CepRN.getInstance().getTabela(), colunas);
    }

    protected void beforeCreate(Cep cep, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Cidade cidade = (Cidade)CidadeRN.getInstance().buscarPorId(cep.getIdCidade());
        if (cidade != null) {
            cep.setIdEstado(cidade.getIdEstado());
        }
    }

    protected String getCacheId() {
        return "ceps";
    }
}

