/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.exportaretiquetabalanca;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.domain.regranegocio.balanca.ExportarBalancaFilizolaRN;
import br.intelidata.commons.domain.regranegocio.balanca.ExportarBalancaToledoRN;
import br.intelidata.commons.domain.regranegocio.balanca.ExportarBalancaUranoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.exportaretiquetabalanca.ExportarEtiquetaBalanca;
import br.intelidata.uniplusweb.web.rest.app.crud.exportaretiquetabalanca.ExportarEtiquetaBalancaSimpleController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/exportar-etiquetas-balanca"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Exportar etiquetas para balan\u00e7a", ICONE="icon-balanca-exporta2", ROTA="/ferramentas/exportar-etiquetas-balanca", PROGRAMA=506)
public class ExportarEtiquetaBalancaSimpleController
extends SimpleCrudController<ExportarEtiquetaBalanca, ConfiguracaoCamposRN> {
    private final ResponseEntityService responseEntityService;
    private final PropriedadeService propriedadeService;
    private final StorageService storageService;

    @Autowired
    public ExportarEtiquetaBalancaSimpleController(ResponseEntityService responseEntityService, PropriedadeService propriedadeService, StorageService storageService) {
        this.responseEntityService = responseEntityService;
        this.propriedadeService = propriedadeService;
        this.storageService = storageService;
    }

    @DBAutoCommit
    public ExportarEtiquetaBalanca get(Long parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoCampos configuracaoCampos = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), "balanca");
        if (configuracaoCampos != null) {
            return (ExportarEtiquetaBalanca)JSONUtil.getObject((JSONObject)configuracaoCampos.getCamposSerializados(), ExportarEtiquetaBalanca.class);
        }
        return new ExportarEtiquetaBalanca();
    }

    @RequestMapping(value={"/gerar-arquivo"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> gerarArquivo(@RequestBody ExportarEtiquetaBalanca exportarEtiquetasWrapper) throws UnicoMensagemUsuarioException, IOException {
        byte[] arquivo = this.criarArquivo(exportarEtiquetasWrapper);
        return this.responseEntityService.createZIPResponse(arquivo, "Arquivos Balan\u00e7a");
    }

    @RequestMapping(value={"/gerar-arquivo_url"}, method={RequestMethod.POST})
    @DBTransaction
    public String gerarArquivoUrl(@RequestBody ExportarEtiquetaBalanca exportarEtiquetasWrapper) throws UnicoMensagemUsuarioException, IOException {
        File file = new File("arquivoBalanca.zip");
        byte[] arquivo = this.criarArquivo(exportarEtiquetasWrapper);
        Util.byteArray2File((byte[])arquivo, (File)file);
        String url = this.storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.BALANCA, file, true, null, true);
        url = this.storageService.publishArquivo(url);
        return url.replace("\\", "/");
    }

    private byte[] criarArquivo(ExportarEtiquetaBalanca exportarEtiquetasWrapper) throws UnicoMensagemUsuarioException, IOException {
        ExportarBalancaFilizolaRN exportarBalancaRN;
        Sessao sessao = SessaoUtil.getSessao();
        PropriedadeRN.getInstance().setPropriedade(sessao, 19, exportarEtiquetasWrapper.getBalanca().getId());
        PropriedadeRN.getInstance().setPropriedade(sessao, 815, Boolean.valueOf(exportarEtiquetasWrapper.isExportarRdc429()));
        PropriedadeRN.getInstance().setPropriedade(sessao, 20, exportarEtiquetasWrapper.getDiretorio());
        this.propriedadeService.getPropriedadeValor().put(19, exportarEtiquetasWrapper.getBalanca().getId());
        this.propriedadeService.getPropriedadeValor().put(815, exportarEtiquetasWrapper.isExportarRdc429());
        this.propriedadeService.getPropriedadeValor().put(20, exportarEtiquetasWrapper.getDiretorio());
        ConfiguracaoCamposRN.getInstance().gravarConfiguracaoPorFilial(sessao, (Object)exportarEtiquetasWrapper, "balanca");
        switch (1.$SwitchMap$br$intelidata$commons$core$periferico$balanca$MarcaBalanca[exportarEtiquetasWrapper.getBalanca().ordinal()]) {
            case 1: {
                exportarBalancaRN = new ExportarBalancaToledoRN(sessao, exportarEtiquetasWrapper.isExportarPeloEAN(), exportarEtiquetasWrapper.isExportarNomeEcf(), exportarEtiquetasWrapper.isPrecoPromocional(), exportarEtiquetasWrapper.getDataPromocao(), exportarEtiquetasWrapper.isExportarRdc429());
                break;
            }
            case 2: 
            case 3: {
                exportarBalancaRN = new ExportarBalancaFilizolaRN(sessao, exportarEtiquetasWrapper.isExportarPeloEAN(), exportarEtiquetasWrapper.isExportarNomeEcf(), exportarEtiquetasWrapper.isPrecoPromocional(), exportarEtiquetasWrapper.getDataPromocao());
                break;
            }
            default: {
                exportarBalancaRN = new ExportarBalancaUranoRN(sessao, exportarEtiquetasWrapper.isExportarPeloEAN(), exportarEtiquetasWrapper.isExportarNomeEcf(), exportarEtiquetasWrapper.isPrecoPromocional(), exportarEtiquetasWrapper.getDataPromocao());
            }
        }
        Remessa remessa = exportarBalancaRN.getArquivos();
        if (remessa != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(baos);
            Remessa naoExportados = exportarBalancaRN.imprimirNaoExportados();
            if (naoExportados != null) {
                byte[] arquivo = naoExportados.getMalote().extrai("pdf");
                FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])arquivo, (String)"N\u00e3o Exportados.pdf");
            }
            for (String key : remessa.getMalote().getConteudo()) {
                FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])((byte[])remessa.getMalote().getMapArquivos().get(key)), (String)key);
            }
            zipOut.close();
            baos.close();
            return baos.toByteArray();
        }
        return null;
    }
}

