/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial.cpom;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FilialCidadeCPOM;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialCidadeCPOMRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cpom"})
public class CpomCrudController
extends CrudController<FilialCidadeCPOM, FilialCidadeCPOMRN> {
    public CpomCrudController() {
        super((AbstractRegraNegocio)FilialCidadeCPOMRN.getInstance(), FilialCidadeCPOM::new);
        this.dependsOn("idFilial");
    }

    protected void beforeSave(FilialCidadeCPOM filialCidadeCPOM, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)filialCidadeCPOM.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW67", "Id filial nao informado");
        }
        if (Util.longNullOuZero((Long)filialCidadeCPOM.getIdEstado())) {
            throw new UnicoMensagemUsuarioException("WWW59", "Campo Estado n\u00e3o informado");
        }
        if (Util.longNullOuZero((Long)filialCidadeCPOM.getIdCidade())) {
            throw new UnicoMensagemUsuarioException("WWW60", "Campo Cidade n\u00e3o informado");
        }
    }

    protected GridBuilder<FilialCidadeCPOMRN> getGridBuilder() {
        return new GridBuilder(FilialCidadeCPOMRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idFilial", "idFilial", 0, false), new ColunaSQL("idFilial", "idFilial", 0, false), new ColunaSQL("idFilial", "idFilial", 0, false), new ColunaSQL("nome", "cidade", "Cidade", 0, true, new String[]{"fk_cpom_cidade"}), new ColunaSQL("nome", "estado", "UF", 0, true, new String[]{"fk_cpom_estado"})));
    }

    protected String getCacheId() {
        return "cpom";
    }
}

