/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.core.uboleto.boleto.Boleto;
import br.intelidata.commons.core.util.Email;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.ParametrosEmail;
import br.intelidata.commons.domain.pojo.adicional.CobrancaEmailWeb;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoGeracaoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoIdentificacaoBeneficiarioClienteUBoleto;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.wrapper.GeracaoRemessaWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteAcaoCobrancaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JobGeracaoRemessaEmail
extends AbstractPrepareJob {
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");

    public JobGeracaoRemessaEmail(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
        try {
            GeracaoRemessaWrapper remessaWrapper = (GeracaoRemessaWrapper)this.getObjetoDeserializado(GeracaoRemessaWrapper.class);
            List idsDocumentos = remessaWrapper.getDocumentos().stream().map(DocumentoCobranca::getIdFinanceiroDado).collect(Collectors.toList());
            this.atualizarStatus(idsDocumentos);
        }
        catch (UnicoMensagemUsuarioException e) {
            this.addMensagemRetorno("Erro ao atualizar o status ap\u00f3s exce\u00e7\u00e3o. " + e.getMessage());
        }
    }

    public void execute() throws Exception {
        GeracaoRemessaWrapper remessaWrapper = (GeracaoRemessaWrapper)this.getObjetoDeserializado(GeracaoRemessaWrapper.class);
        Sessao sessao = this.getSessao();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper);
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        ContaCorrenteAcaoCobranca contaAcao = (ContaCorrenteAcaoCobranca)ContaCorrenteAcaoCobrancaRN.getInstance().buscarPorId(remessaWrapper.getIdAcaoCobrancaRemessa());
        ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
        contaAcaoRemessa.setAcaoCobranca(contaAcao);
        NotificacaoCompartilhamento notificacao = remessaWrapper.getNotificacao();
        CobrancaEmailWeb cobranca = CobrancaEscrituralRN.getInstance().gerarBoletoWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, remessaWrapper.getTipoSaidaBoleto(), contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao(), notificacao.getTipo(), false);
        PropriedadeRN.getInstance().setPropriedade(sessao, 592, remessaWrapper.getPercentualDescontoPagamentoAteVencimento().toString());
        String nomeEmpresa = TipoIdentificacaoBeneficiarioClienteUBoleto.NOME.equals((Object)contaCorrente.getTipoIdentificacaoBeneficiario()) ? sessao.getFilial().getNome() : sessao.getFilial().getRazaoSocialCompleta();
        this.agendarEmail(sessao, cobranca.getMapPdf(), (Map)cobranca.getMapBoleto(), notificacao);
    }

    protected br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao getNotificacaoSucesso(Task jobExecutor) {
        return new br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao(TipoNotificacaoSimples.SUCCESS, "Gera\u00e7\u00e3o de remessa conclu\u00edda para envio.");
    }

    protected br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao getNotificacaoErro(Task task) {
        return new br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao(TipoNotificacaoSimples.ERROR, "Ocorreu um problema ao gerar as remessas para envio. Por favor, verifique a tarefa para mais detalhes.");
    }

    private void agendarEmail(Sessao sessao, HashMap<String, List<Object>> pdfs, Map<String, List<Boleto>> boletos, NotificacaoCompartilhamento notificacao) throws UnicoMensagemUsuarioException {
        ParametrosEmail configuracoesEmail = Email.getParametrosEmail((Sessao)sessao);
        this.addMensagemRetorno("Remessa enviada com sucesso para o(s) seguinte(s) endere\u00e7o(s): ");
        List notificacoes = CobrancaEscrituralRN.getInstance().geraNotificacaoDocumentosWeb(sessao, pdfs, null, notificacao);
        for (Notificacao n : notificacoes) {
            ParametrosEmailWeb parametro = EmailUtil.getParametros((Sessao)sessao, (ParametrosEmail)configuracoesEmail, (String)n.getFone(), null, (String)n.getAssunto(), (String)n.getMsg());
            parametro.setAnexos(n.getDataSources());
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametro);
            taskEmail.createTask((Object)parametro, parametro.getAssunto());
            List ids = boletos.get(n.getUuid()).stream().map(b -> NumberUtil.toLong((String)b.getIdentificacaoEmpresa())).collect(Collectors.toList());
            this.atualizarStatus(ids);
        }
    }

    private ContaCorrenteCarteira getContaCorrenteCarteira(GeracaoRemessaWrapper remessaWrapper) throws UnicoMensagemUsuarioException {
        ContaCorrenteCarteira contaCarteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(remessaWrapper.getIdCarteira());
        if (contaCarteira == null) {
            List carteiras = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(remessaWrapper.getIdContaCorrenteRemessa(), true);
            if (Util.listNullOrEmpty((List)carteiras) || carteiras.size() > 1) {
                throw new UnicoMensagemUsuarioException("WWW619", "Carteira n\u00e3o encontrada.");
            }
            contaCarteira = (ContaCorrenteCarteira)carteiras.get(0);
        }
        return contaCarteira;
    }

    private void atualizarStatus(List<Long> ids) {
        ids.forEach(id -> {
            Sql sqlUpdate = new Sql(new UUpdate(FinanceiroDadoRN.getInstance().getTabela(), id, new ColunaUPD[]{new ColunaUPD("statusjob", StatusJobItem.PROCESSADO.getId())}));
            sqlUpdate.executaUpdate();
            sqlUpdate.close();
        });
    }
}

