/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.prorrogacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.EncargoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.ParametroCalculoEncargo;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.regranegocio.FinanceiroDadoCommonRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRateioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.IFileFinanceiro;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.prorrogacao.ProrrogacaoTituloWrapper;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prorrogacao-titulo"})
public class ProrrogacaoCrudController
extends SimpleController
implements IFileFinanceiro {
    public final TaskManager taskManager;
    public final StorageService storageService;

    public ProrrogacaoCrudController(TaskManager taskManager, StorageService storageService) {
        this.taskManager = taskManager;
        this.storageService = storageService;
    }

    @RequestMapping(value={"/carregar-dados"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProrrogacaoTituloWrapper carregarDados(@RequestBody ProrrogacaoTituloWrapper prorrogacao) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(prorrogacao.getIdFinanceiro());
        if (financeiro == null) {
            throw new UnicoMensagemUsuarioException("FIN347", "Documento n\u00e3o encontrado");
        }
        prorrogacao.setNumeroDocumento(financeiro.getDocumento());
        prorrogacao.setEmissaoOriginal(financeiro.getEmissao());
        prorrogacao.setVencimentoOriginal(financeiro.getVencimentoCalculoEncargos() != null ? financeiro.getVencimentoCalculoEncargos() : financeiro.getVencimento());
        prorrogacao.setValorOriginal(financeiro.getSaldo());
        ParametroCalculoEncargo parametro = FinanceiroDadoRN.getInstance().getParametroCalculoEncargo(financeiro.getTipoDocumento() != null ? financeiro.getTipoDocumento().getId() : null, financeiro.getIdFilial(), financeiro.getIdContaGeraBoleto());
        EncargoFinanceiro encargo = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(prorrogacao.getNovoVencimento(), financeiro.getSaldo(), financeiro.getVencimentoCalculoEncargos() != null ? financeiro.getVencimentoCalculoEncargos() : financeiro.getVencimento(), parametro, financeiro.getVencimentoCalculoEncargos() != null && !financeiro.getVencimentoCalculoEncargos().isEqual(financeiro.getVencimento()));
        if (encargo != null) {
            prorrogacao.setValorJuros(encargo.getValorJuros());
            prorrogacao.setValorMulta(encargo.getValorMulta());
        }
        BigDecimal saldo = prorrogacao.getValorOriginal().add(prorrogacao.getValorJuros()).add(prorrogacao.getValorMulta());
        prorrogacao.setNovoValor(saldo);
        return prorrogacao;
    }

    @RequestMapping(value={"/gravar-prorrogacao"})
    @DBTransaction
    public void gravarProrrogacao(@RequestBody ProrrogacaoTituloWrapper prorrogacao) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(prorrogacao.getIdFinanceiro());
        this.validarData(prorrogacao);
        HierarquiaPlanoContas planoContaJuros = null;
        HierarquiaPlanoContas planoContaMulta = null;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS)) {
            if (prorrogacao.getIdPlanoContaJuros() != null) {
                planoContaJuros = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(prorrogacao.getIdPlanoContaJuros());
            }
            if (prorrogacao.getIdPlanoContaMulta() != null) {
                planoContaMulta = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(prorrogacao.getIdPlanoContaMulta());
            }
            if (planoContaJuros == null && !Util.bigDecimalNullOrZero((BigDecimal)prorrogacao.getValorJuros())) {
                throw new UnicoMensagemUsuarioException("WFIN237", "Plano de contas de juros n\u00e3o foi informado!");
            }
            if (planoContaMulta == null && !Util.bigDecimalNullOrZero((BigDecimal)prorrogacao.getValorMulta())) {
                throw new UnicoMensagemUsuarioException("WFIN238", "Plano de contas de multa n\u00e3o foi informado!");
            }
        }
        List rateiosJuros = null;
        List rateiosMulta = null;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO)) {
            if (planoContaJuros != null && planoContaJuros.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)prorrogacao.getValorJuros())) {
                rateiosJuros = prorrogacao.getRateiosJuros();
                CentroCustoRateioRN.getInstance().validarRateio(prorrogacao.getValorJuros(), rateiosJuros);
            }
            if (planoContaMulta != null && planoContaMulta.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)prorrogacao.getValorMulta())) {
                rateiosMulta = prorrogacao.getRateiosMulta();
                CentroCustoRateioRN.getInstance().validarRateio(prorrogacao.getValorMulta(), rateiosMulta);
            }
        }
        Sessao sessao = SessaoUtil.getSessao();
        FinanceiroDadoRN.getInstance().gravarLancamentoProrrogacao(sessao, financeiro, prorrogacao.getNovoVencimento(), prorrogacao.getValorJuros(), prorrogacao.getValorMulta(), prorrogacao.getObservacao(), prorrogacao.getIdPlanoContaJuros(), rateiosJuros, prorrogacao.getIdPlanoContaMulta(), rateiosMulta);
        FinanceiroDadoCommonRN.getInstance().atualizarCobrancaParceiro(financeiro, sessao, this.carregarArquivo(this.storageService));
    }

    private void validarData(ProrrogacaoTituloWrapper prorrogacao) throws UnicoMensagemUsuarioException {
        if (prorrogacao.getNovoVencimento().isBefore(DataHoraFactory.getData()) || prorrogacao.getNovoVencimento().isBefore(prorrogacao.getVencimentoOriginal())) {
            throw new UnicoMensagemUsuarioException("WFIN243", "Data do novo vencimento inv\u00e1lida!");
        }
    }
}

