/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.fiscal;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.fiscal.GrupoProdutoClassificacaoTributaria;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.GrupoProdutoClassificacaoTributariaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.fiscal.ValidacaoClassificacaoTributariaWrapper;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupos-produto-classificacao-tributaria"})
public class GrupoProdutoClassificacaoTributariaCrudController
extends CrudController<GrupoProdutoClassificacaoTributaria, GrupoProdutoClassificacaoTributariaRN> {
    public GrupoProdutoClassificacaoTributariaCrudController() {
        super((AbstractRegraNegocio)GrupoProdutoClassificacaoTributariaRN.getInstance(), GrupoProdutoClassificacaoTributaria::new);
        this.dependsOn("idGrupoProduto");
    }

    protected String getCacheId() {
        return "grupos-produto-classificacao-tributaria";
    }

    public GridBuilder<GrupoProdutoClassificacaoTributariaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idGrupoProduto", "idGrupoProduto", 0, false));
        colunas.add(new ColunaSQL("currentTimeMillis", "currentTimeMillis", 0, false));
        colunas.add(new ColunaSQL("idClassificacaoTributaria", "idClassificacaoTributaria", 0, false));
        colunas.add(new ColunaSQL("idClassificacaoTributacaoReg", "idClassificacaoTributacaoReg", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoClassificacao", "C\u00f3digo", 84, true, new String[]{"grupoclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("codigo", "codigoClassificacaoTribReg", "Classifica\u00e7\u00e3o regular", 84, true, new String[]{"grupoclassiftrib_trib_reg"}));
        colunas.add(new ColunaSQL("cst", "cstClassificacao", "CST", 220, true, new String[]{"grupoclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("nome", "nomeClassificacao", "Nome", 400, true, new String[]{"grupoclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("datainiciovigencia", "dataInicioVigencia", "In\u00edcio", 220, true, new String[]{"grupoclassiftrib_classiftrib"}));
        colunas.add(new ColunaSQL("datafimvigencia", "dataFimVigencia", "Fim", 220, true, new String[]{"grupoclassiftrib_classiftrib"}));
        return new GridBuilder(GrupoProdutoClassificacaoTributariaRN.getInstance().getTabela(), colunas);
    }

    @PostMapping(value={"/validar-inclusao-tabela"})
    @DBAutoCommit
    public void validarInclusaoTabela(@RequestBody ValidacaoClassificacaoTributariaWrapper<GrupoProdutoClassificacaoTributaria> validacaoWrapper) throws UnicoMensagemUsuarioException {
        ClassificacaoTributariaIbsCbsRN.getInstance().validarObjetoClassificacaoTributaria(validacaoWrapper.getListaClassificacoes(), validacaoWrapper.getClassificacaoInformada());
    }
}

