/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.geracaospedcontribuicoes;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorRN;
import br.intelidata.commons.sped.contribuicoes.IndicadorIncidenciaTributaria;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaospedcontribuicoes.JobGeracaoSpedContribuicoes;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaospedcontribuicoes.SpedContribuicoesWrapper;
import java.time.temporal.Temporal;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/gerar-sped-contribuiceos"})
@SubMenuMapping(MENU="SubMenuPainelContadorGeral", ICONE="icon-gravar", NOME="Sped contribui\u00e7\u00f5es", ROTA="/speds/gerar-sped-contribuiceos", PROGRAMA=1105)
public class GeracaoSpedContribuicoesJobCrudController
extends SimpleCrudController<JobExecutor, JobExecutorRN>
implements ICreateTask {
    private final TaskManager taskManager;

    public GeracaoSpedContribuicoesJobCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)JobExecutorRN.getInstance());
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.SPED_CONTRIBUICAO;
    }

    public Class<? extends AbstractJob> job() {
        return JobGeracaoSpedContribuicoes.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public JobExecutor get(Long parentId) throws UnicoMensagemUsuarioException {
        return new JobExecutor();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody JobExecutor jobExecutor) throws UnicoMensagemUsuarioException {
        SpedContribuicoesWrapper sepedContribuicoes = (SpedContribuicoesWrapper)JsonUtil.fromJson((String)jobExecutor.getParametrosSerializado(), SpedContribuicoesWrapper.class);
        if (sepedContribuicoes == null) {
            throw new UnicoMensagemUsuarioException("WWW469", "N\u00e3o foi poss\u00edvel converter o pojo de sped contribui\u00e7\u00f5es");
        }
        if (sepedContribuicoes.getDataInicial() == null) {
            throw new UnicoMensagemUsuarioException("WCOM142", "A data inicial n\u00e3o pode estar nula");
        }
        if (sepedContribuicoes.getDataFinal() == null) {
            throw new UnicoMensagemUsuarioException("WCOM143", "A data final n\u00e3o pode estar nula");
        }
        this.createTask((Object)sepedContribuicoes, this.resumoFiltros(sepedContribuicoes));
        return 0L;
    }

    @RequestMapping(value={"/permitir-trocar-entrada"})
    @DBAutoCommit
    public boolean permiteTrocarEnvioEntrada() throws UnicoMensagemUsuarioException {
        Filial matriz = FilialCommonRN.getInstance().getMatrizDaFilialAtual(Contexto.getInstance().getSessao());
        return matriz != null && IndicadorIncidenciaTributaria.CUMULATIVO_2.equals((Object)matriz.getParametroSpedPisCofins().getIncidenciaTributaria());
    }

    private String resumoFiltros(SpedContribuicoesWrapper parametros) {
        return "Periodo: " + StringUtil.formataDataHora((Temporal)parametros.getDataInicial(), (String)"dd/MM/yy") + " \u00e0 " + StringUtil.formataDataHora((Temporal)parametros.getDataFinal(), (String)"dd/MM/yy");
    }
}

