/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.goomer;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ParametroIntegracaoGoomer;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.goomer.regranegocio.TokenGoomerRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unichef.integracao.goomer.GoomerLog;
import unichef.integracao.goomer.client.GoomerHttpsClient;
import unichef.integracao.goomer.json.Token;

@RestController
@RequestMapping(value={"/api/parametro-goomer"})
@SubMenuMapping(MENU="SubMenuGourmetAuxiliar", NOME="Par\u00e2metros da integra\u00e7\u00e3o Goomer", ROTA="/unichefs/parametro-goomer", PROGRAMA=1481)
public class GoomerCrudController
extends SimpleCrudController<ParametroIntegracaoGoomer, FilialRN> {
    public GoomerCrudController() {
        super((AbstractRegraNegocio)FilialRN.getInstance());
    }

    @DBAutoCommit
    public ParametroIntegracaoGoomer get(Long parentId) throws UnicoMensagemUsuarioException {
        return SessaoUtil.getSessao().getFilial().getParametrosIntegracaoGoomer();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBAutoCommit
    public Long create(@RequestBody ParametroIntegracaoGoomer entity) throws UnicoMensagemUsuarioException {
        int modo = 1;
        Filial filial = SessaoUtil.getSessao().getFilial();
        filial.setParametrosIntegracaoGoomer(entity);
        FilialRN.getInstance().gravar(modo, filial, SessaoUtil.getSessao());
        return filial.getId();
    }

    @RequestMapping(value={"/liberar-acesso"})
    @DBAutoCommit
    public void liberarAcesso(@RequestParam String storeId, @RequestParam String clientId, @RequestParam String clientSecret) throws UnicoMensagemUsuarioException {
        try {
            GoomerHttpsClient httpsClient = new GoomerHttpsClient(GoomerLog.INT_FIS);
            Token novoToken = httpsClient.authorize(storeId, clientId, clientSecret);
            TokenGoomerRN.getInstance().persistirToken(novoToken, SessaoUtil.getSessao());
        }
        catch (Throwable ex) {
            throw new UnicoMensagemUsuarioException("GOOMERW10", "Problema ao conceder acesso", ex);
        }
    }
}

