/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.grade.gradevalor;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.GradeValor;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/valores-grades"})
public class GradeValorCrudController
extends CrudController<GradeValor, GradeValorRN> {
    private static final int LIMITE_GRADE = 99;

    public GradeValorCrudController() {
        super((AbstractRegraNegocio)GradeValorRN.getInstance(), GradeValor::new, false, false, false);
        this.dependsOn("idGrade");
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody GradeValor gradeValor, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.beforeSave(gradeValor, parentId);
        List valores = GradeValorRN.getInstance().buscaPorIdGrade(gradeValor.getIdGrade());
        valores.add(gradeValor);
        if (valores.size() > 99) {
            throw new UnicoMensagemUsuarioException("WPRD103", "O limite definido para a grade \u00e9 de 99 x 99. N\u00e3o \u00e9 poss\u00edvel adicionar novos valores.");
        }
        GradeValorRN.getInstance().alteraValores(SessaoUtil.getSessao(), gradeValor.getIdGrade(), valores, true);
        this.gravarAuditoriaRegistro(null, (AbstractPojo)gradeValor, 0);
        return GradeValorRN.getInstance().buscarPorIdGradeValor(gradeValor.getIdGrade(), gradeValor.getValor()).getId();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody GradeValor gradeValor, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)gradeValor);
        this.beforeSave(gradeValor, parentId);
        this.gravarAuditoriaRegistro(gradeValor.getId(), (AbstractPojo)gradeValor, 1);
        List valores = GradeValorRN.getInstance().buscaPorIdGrade(gradeValor.getIdGrade());
        Optional<GradeValor> filter = valores.stream().filter(gradeValor1 -> gradeValor.getId().equals(gradeValor1.getId())).findFirst();
        if (!filter.isPresent()) {
            throw new UnicoMensagemUsuarioException("WWW98", "Valor de grade n\u00e3o encontrado");
        }
        filter.get().setValor(gradeValor.getValor());
        filter.get().setCor(gradeValor.getCor());
        filter.get().setInativo(gradeValor.isInativo());
        GradeValorRN.getInstance().alteraValores(SessaoUtil.getSessao(), gradeValor.getIdGrade(), valores, true);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return gradeValor.getId();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        GradeValor gradeValor = (GradeValor)GradeValorRN.getInstance().buscarPorId(id);
        this.beforeSave(gradeValor, Optional.empty());
        List valores = GradeValorRN.getInstance().buscaPorIdGrade(gradeValor.getIdGrade());
        if (valores.size() == 1) {
            throw new UnicoMensagemUsuarioException("WWW99", "N\u00e3o \u00e9 poss\u00edvel excluir, pois \u00e9 necess\u00e1rio que a grade tenha ao menos um registro.");
        }
        if (VariacaoRN.getInstance().isUtilizaGradePadrao(id)) {
            throw new UnicoMensagemUsuarioException("WPRD297", "N\u00e3o \u00e9 poss\u00edvel excluir uma grade j\u00e1 utilizada em produtos");
        }
        super.delete(id);
    }

    protected void beforeSave(GradeValor gradeValor, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)gradeValor.getIdGrade())) {
            throw new UnicoMensagemUsuarioException("WWW97", "Grade n\u00e3o informada");
        }
    }

    protected GridBuilder<GradeValorRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idGrade", "idGrade", 0, false));
        colunas.add(new ColunaSQL("inativo", "Inativo", 0, false));
        colunas.add(new ColunaSQL("valor", "Valor", 0, true));
        colunas.add(new ColunaSQL("ordem", "ordem", 0, false));
        colunas.add(new ColunaSQL("cor", "Cor", 0, false));
        ColunaSQL coluna = new ColunaSQL("informarCor", "Informar cor", 0, false);
        coluna.setVirtual(true);
        colunas.add(coluna);
        return new GridBuilder(GradeValorRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "valores-grades";
    }
}

