/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.grupodre;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.financeiro.GrupoDRE;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.GrupoDRERN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupo-dre"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Grupos DRE", ROTA="/financeiros/grupo-dre", PROGRAMA=445)
public class GrupoDreCrudController
extends CrudController<GrupoDRE, GrupoDRERN> {
    public GrupoDreCrudController() {
        super((AbstractRegraNegocio)GrupoDRERN.getInstance(), GrupoDRE::new);
    }

    protected GridBuilder<GrupoDRERN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("ordem", "Ordem", 100, true));
        colunas.add(new ColunaSQL("natureza", "Natureza", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("origem", "Origem", 0, true));
        GridBuilder grid = new GridBuilder(GrupoDRERN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("ordem"));
        return grid;
    }

    @RequestMapping(value={"last-valid-code"})
    @DBAutoCommit
    public String lastValidCode() {
        return Integer.toString(GrupoDRERN.getInstance().buscarProximaOrdem());
    }

    @RequestMapping(value={"/mover"})
    @DBAutoCommit
    public void mover(@RequestParam Long idGrupo, @RequestParam boolean moverParaCima) throws UnicoMensagemUsuarioException {
        GrupoDRERN.getInstance().alterarOrdemGrupo(SessaoUtil.getSessao(), idGrupo, moverParaCima);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<GrupoDRE> getCombo() {
        return GrupoDRERN.getInstance().getComboWeb(SessaoUtil.getSessao());
    }

    protected String getCacheId() {
        return "grupo-dre";
    }
}

