/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.MoverHierarquia;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public abstract class HierarquiaCrudController<H extends Hierarquia, RN extends HierarquiaRN>
extends CrudController<H, RN> {
    public HierarquiaCrudController(RN rn, Supplier<H> hSupplier) {
        this(rn, hSupplier, true);
    }

    public HierarquiaCrudController(RN rn, Supplier<H> hSupplier, boolean lazyLoad) {
        this(rn, hSupplier, lazyLoad, null);
    }

    public HierarquiaCrudController(RN rn, Supplier<H> hSupplier, boolean lazyLoad, TipoArquivoArmazenado tipoArmazenamento) {
        super(rn, hSupplier, lazyLoad, false, tipoArmazenamento);
    }

    @RequestMapping(value={"/mover-tree"}, method={RequestMethod.POST})
    @DBTransaction
    public void moverGrupo(@RequestBody MoverHierarquia moverHierarquia) throws UnicoMensagemUsuarioException {
        String codigoNovoFilho;
        Hierarquia hierarquiaOrigem = (Hierarquia)((HierarquiaRN)this.rn).buscarPorId(moverHierarquia.getIdOrigem());
        Hierarquia hierarquiaPaiDestino = (Hierarquia)((HierarquiaRN)this.rn).buscarPorId(moverHierarquia.getIdDestino());
        String codigoPai = hierarquiaOrigem.getCodigo();
        String codigoNovo = "";
        List hierarquiasFilhas = ((HierarquiaRN)this.rn).buscarHierarquiasFilhas(hierarquiaOrigem.getId());
        if (!Util.listNullOrEmpty((List)hierarquiasFilhas)) {
            hierarquiasFilhas.removeIf(h -> h.getId().equals(hierarquiaOrigem.getId()));
        }
        if (hierarquiaPaiDestino == null) {
            codigoNovo = ((HierarquiaRN)this.rn).incrementaCodigo();
        } else {
            this.validateSubgroup(hierarquiaPaiDestino.getId());
            if (hierarquiaPaiDestino.getId().equals(hierarquiaOrigem.getId())) {
                throw new UnicoMensagemUsuarioException("COM236631", "Voc\u00ea est\u00e1 tentando mover o grupo para ele mesmo.");
            }
            if (hierarquiaPaiDestino.getCodigo().startsWith(hierarquiaOrigem.getCodigo())) {
                throw new UnicoMensagemUsuarioException("COM236632", "N\u00e3o \u00e9 poss\u00edvel mover '" + hierarquiaOrigem.getNome() + "' para '" + hierarquiaPaiDestino.getNome() + "', pois ele \u00e9 um subgrupo desse grupo.");
            }
            codigoNovo = ((HierarquiaRN)this.rn).incrementaCodigo(hierarquiaPaiDestino.getCodigo());
            if (codigoNovo.length() > 30) {
                throw new UnicoMensagemUsuarioException("COM236633", "N\u00e3o \u00e9 poss\u00edvel mover o grupo, s\u00e3o permitidos apenas cinco n\u00edveis.");
            }
            ((HierarquiaRN)this.rn).permiteMoverGrupo(hierarquiaOrigem);
            if (!Util.listNullOrEmpty((List)hierarquiasFilhas)) {
                for (Hierarquia hierarquiaFilha : hierarquiasFilhas) {
                    ((HierarquiaRN)this.rn).permiteMoverGrupo(hierarquiaFilha);
                    codigoNovoFilho = hierarquiaFilha.getCodigo().replace(codigoPai, codigoNovo);
                    if (codigoNovoFilho.length() <= 30) continue;
                    throw new UnicoMensagemUsuarioException("COM236634", "N\u00e3o \u00e9 poss\u00edvel mover o grupo, s\u00e3o permitidos apenas cinco n\u00edveis.");
                }
            }
        }
        hierarquiaOrigem.setCodigo(codigoNovo);
        ((HierarquiaRN)this.rn).alterar((AbstractPojo)hierarquiaOrigem, SessaoUtil.getSessao());
        if (!Util.listNullOrEmpty((List)hierarquiasFilhas)) {
            for (Hierarquia hierarquiaFilha : hierarquiasFilhas) {
                codigoNovoFilho = hierarquiaFilha.getCodigo().replace(codigoPai, codigoNovo);
                hierarquiaFilha.setCodigo(codigoNovoFilho);
                ((HierarquiaRN)this.rn).alterar((AbstractPojo)hierarquiaFilha, SessaoUtil.getSessao());
            }
        }
    }

    @RequestMapping(value={"/dados-tree"})
    @DBAutoCommit
    public List buscarDadosTree(@RequestParam(required=false) boolean apenasAtivos, @RequestParam(required=false) TipoMovimentoPlanoContas tipoMovimento) {
        ArrayList<Condicao> condicoes = new ArrayList<Condicao>();
        if (tipoMovimento != null) {
            condicoes.add(new Condicao("tipomovimento", Operador.IS_NULL));
            condicoes.add(new Condicao(OperadorLogico.OU));
            condicoes.add(new Condicao("tipomovimento", Operador.IGUAL, ""));
            condicoes.add(new Condicao(OperadorLogico.OU));
            condicoes.add(new Condicao("tipomovimento", Operador.IGUAL, tipoMovimento.getId()));
        }
        return ((HierarquiaRN)this.rn).buscarTodosCombo(apenasAtivos, condicoes);
    }

    @RequestMapping(value={"/nome/{id}"})
    @DBAutoCommit
    public Hierarquia getNome(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        return ((HierarquiaRN)this.rn).buscarNome(id);
    }

    @RequestMapping(value={"/{id}/validate-subgroup"})
    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        Hierarquia hierarquia = (Hierarquia)this.read(id, null, 0, null);
        if (hierarquia.isQuintoNivel()) {
            throw new UnicoMensagemUsuarioException("COM236635", "N\u00e3o \u00e9 poss\u00edvel adicionar um subgrupo. S\u00e3o permitidos apenas cinco n\u00edveis.");
        }
        return true;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody H hierarquia, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create(hierarquia, parentId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody H hierarquia, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update(hierarquia, parentId);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        super.delete(id);
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") H entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.update(entity, Optional.empty());
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart MultipartFile[] files, @RequestPart(value="entity") H entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.create(entity, Optional.empty());
    }

    protected void addColunaNivel(List<ColunaSQL> colunas) {
        ColunaSQL nivel = new ColunaSQL("nivel", "N\u00edvel", 80, false);
        nivel.setVirtual(true);
        nivel.setEstatico(true);
        colunas.add(nivel);
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        for (Object[] registro : dados) {
            int idxColuna = this.getIndexColuna("codigo", colunas);
            if (idxColuna <= -1) continue;
            String codigo = (String)registro[idxColuna];
            registro[this.getIndexColuna((String)"nivel", colunas)] = ((HierarquiaRN)this.rn).getNivel(codigo);
        }
    }

    @RequestMapping(value={"/verifica-existe-grupo-cadastrado"})
    @DBAutoCommit
    public boolean isExisteGrupoCadastrado() {
        return ((HierarquiaRN)this.rn).isExisteGrupoCadastrado();
    }
}

