/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.gruposervico;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoServico;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.servico.regranegocio.HierarquiaGrupoServicoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupos-servico"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarServicos", NOME="Grupos de servi\u00e7o", ICONE="icon-incluir-subgrupo", ROTA="/servicos-module/grupos-servico", PROGRAMA=1000068)
public class HierarquiaGrupoServicoCrudController
extends HierarquiaCrudController<HierarquiaGrupoServico, HierarquiaGrupoServicoRN> {
    public HierarquiaGrupoServicoCrudController() {
        super((HierarquiaRN)HierarquiaGrupoServicoRN.getInstance(), HierarquiaGrupoServico::new);
    }

    protected GridBuilder<HierarquiaGrupoServicoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        GridBuilder grid = new GridBuilder(HierarquiaGrupoServicoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    @DBAutoCommit
    public boolean validateSubgroup(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        HierarquiaGrupoServico hierarquia = (HierarquiaGrupoServico)HierarquiaGrupoServicoRN.getInstance().buscarPorId(id);
        if (!HierarquiaGrupoServicoRN.getInstance().isHierarquiaPossuiFilhos(hierarquia.getCodigo()) && ProdutoRN.getInstance().countHierarquiaGrupoServicoUsados(hierarquia.getId()) > 0) {
            throw new UnicoMensagemUsuarioException("WPRD393", "N\u00e3o \u00e9 poss\u00edvel inserir um subgrupo em '" + hierarquia.getNome() + "', pois j\u00e1 existem servi\u00e7os cadastrados para ele");
        }
        return super.validateSubgroup(id);
    }

    protected String getCacheId() {
        return "grupos-servico";
    }
}

