/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.horarioatendimento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.vendas.HorarioAtendimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.vendas.regranegocio.HorarioAtendimentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/horarios-atendimento"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarParametrosVenda", NOME="Hor\u00e1rio de atendimento", ROTA="/vendas/horarios-atendimento", PROGRAMA=1378)
public class HorarioAtendimentoCrudController
extends SimpleCrudController<HorarioAtendimento, HorarioAtendimentoRN> {
    public HorarioAtendimentoCrudController() {
        super((AbstractRegraNegocio)HorarioAtendimentoRN.getInstance());
    }

    @DBAutoCommit
    public HorarioAtendimento get(@RequestParam(required=false) Long parentId) {
        HorarioAtendimento ha = HorarioAtendimentoRN.getInstance().getHorarioAtendimento();
        if (ha == null) {
            ha = new HorarioAtendimento();
        }
        return ha;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody HorarioAtendimento horarioAtendimento) throws UnicoMensagemUsuarioException {
        int modo = 0;
        if (!NumberUtil.longNullOuZero((Long)horarioAtendimento.getId())) {
            this.validarCurrentTimeMillis((AbstractPojo)horarioAtendimento);
            modo = 1;
        }
        HorarioAtendimentoRN.getInstance().gravar(modo, (AbstractPojo)horarioAtendimento, SessaoUtil.getSessao());
        return horarioAtendimento.getId();
    }
}

