/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importacao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.importacao.UnicoImportacaoException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.importacao.r2d2.ImportacaoArquivoR2D2;
import br.intelidata.commons.domain.pojo.importacao.r2d2.StatusImportacao;
import br.intelidata.commons.domain.regranegocio.ImportacaoArquivoR2D2CommonRN;
import br.intelidata.commons.modulo.importacao.ImportacaoLeituraArquivo;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class JobImportacaoArquivoR2D2
extends AbstractPrepareJob {
    private int qtdImportados = 0;
    private int qtdErros = 0;
    private int qtdAvisos = 0;

    public JobImportacaoArquivoR2D2(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void execute() throws Exception {
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        List listImportacao = ImportacaoArquivoR2D2CommonRN.getInstance().buscarListaPendente();
        Sessao sessao = SessaoUtil.getSessao();
        for (ImportacaoArquivoR2D2 importacao : listImportacao) {
            File erro;
            File file = storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.R2D2, importacao.getUrlArquivo(), true, true);
            if (file == null) {
                importacao.setStatus(StatusImportacao.FALHA);
                ImportacaoArquivoR2D2CommonRN.getInstance().alterar((AbstractPojo)importacao, sessao);
                continue;
            }
            ImportacaoLeituraArquivo leituraArquivo = new ImportacaoLeituraArquivo();
            try {
                leituraArquivo.lerArquivo(sessao, file, true);
            }
            catch (Exception ex) {
                erro = this.logarArquivo(importacao.getNomeArquivo(), "Ocorreu um erro ao ler o arquivo ", ex);
                this.gravarArquivo(erro, importacao, storageService);
                importacao.setStatus(StatusImportacao.FALHA);
                ImportacaoArquivoR2D2CommonRN.getInstance().alterar((AbstractPojo)importacao, sessao);
                ++this.qtdErros;
                continue;
            }
            if (!leituraArquivo.getModel().getErros().isEmpty()) {
                erro = this.logarArquivo(importacao.getNomeArquivo(), leituraArquivo.getModel().getErros(), false);
                importacao.setStatus(StatusImportacao.FALHA);
                ++this.qtdErros;
            } else {
                try {
                    leituraArquivo.importar(sessao);
                }
                catch (Exception ex) {
                    erro = this.logarArquivo(importacao.getNomeArquivo(), "Ocorreu um erro ao importar o arquivo ", ex);
                    this.gravarArquivo(erro, importacao, storageService);
                    importacao.setStatus(StatusImportacao.FALHA);
                    ImportacaoArquivoR2D2CommonRN.getInstance().alterar((AbstractPojo)importacao, sessao);
                    ++this.qtdErros;
                    continue;
                }
                erro = this.logarArquivo(importacao.getNomeArquivo(), leituraArquivo.getModel().getAvisos(), true);
                if (erro != null) {
                    importacao.setStatus(StatusImportacao.WARNING);
                    ++this.qtdAvisos;
                } else {
                    importacao.setStatus(StatusImportacao.SUCESSO);
                    ++this.qtdImportados;
                }
            }
            this.gravarArquivo(erro, importacao, storageService);
            ImportacaoArquivoR2D2CommonRN.getInstance().alterar((AbstractPojo)importacao, sessao);
        }
        this.addMensagemRetorno(this.getMensagemRetorno());
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, this.getMensagemRetorno());
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, this.getMensagemRetorno());
    }

    private void gravarArquivo(File file, ImportacaoArquivoR2D2 importacao, StorageService storageService) {
        if (file != null) {
            String urlArquivo = storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.R2D2, file, false, null, true);
            importacao.setUrlArquivoErro(urlArquivo);
        }
    }

    private File logarArquivo(String arquivoAtual, List<UnicoImportacaoException> excecoes, boolean isAviso) throws IOException {
        if (excecoes.isEmpty()) {
            return null;
        }
        arquivoAtual = isAviso ? arquivoAtual.concat("_avisos.txt") : arquivoAtual.concat("_erros.txt");
        File arquivo = new File(arquivoAtual);
        for (UnicoImportacaoException ex : excecoes) {
            String msg = ex.getMessageR2D2().concat("\n").concat(Util.getStackTrace((Throwable)ex)).concat("\n");
            FileUtils.write((File)arquivo, (CharSequence)msg, (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        return arquivo;
    }

    private File logarArquivo(String nome, String msg, Exception ue) throws IOException {
        File arquivo = new File(nome.concat("_erros.txt"));
        msg = msg.concat(nome).concat("\n").concat(ue.getMessage()).concat("\n").concat(Util.getStackTrace((Throwable)ue.getCause()));
        FileUtils.write((File)arquivo, (CharSequence)msg, (Charset)StandardCharsets.UTF_8);
        return arquivo;
    }

    public String getMensagemRetorno() {
        StringBuilder sb = new StringBuilder();
        sb.append("Importados: ").append(this.qtdImportados);
        if (this.qtdErros > 0) {
            sb.append(" Erros: ").append(this.qtdErros);
        }
        if (this.qtdAvisos > 0) {
            sb.append(" Importado com avisos: ").append(this.qtdAvisos);
        }
        return sb.toString();
    }
}

