/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importardecupomfiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/importar-operacao"})
public class ImportacaoOperacaoCrudController
extends SimpleCrudController {
    @RequestMapping(value={"/importar"})
    @DBAutoCommit
    public NotaFiscal importar(@RequestParam List<Long> ids, @RequestParam Long idOperacaoFiscal) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty(ids)) {
            throw new UnicoMensagemUsuarioException("WWW274", "Nenhum cupom fiscal selecionado");
        }
        Sessao sessao = SessaoUtil.getSessao();
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().importarCupomFiscal(SessaoUtil.getSessao(), ids, idOperacaoFiscal);
        notaFiscal.getNotaFiscalItens().forEach(item -> item.setItemPermiteDesconto(NotaFiscalItemRN.getInstance().permiteDescontoSubtotal(item, sessao.getFilial())));
        return notaFiscal;
    }

    @RequestMapping(value={"/buscar-cupons"})
    @DBAutoCommit
    public List<Operacao> buscarOperacoes(@RequestParam int ecf, @RequestParam int coo) throws UnicoMensagemUsuarioException {
        List listaIdsCupons = OperacaoRN.getInstance().buscaListaIdsCupons(Integer.valueOf(ecf), Integer.valueOf(coo), SessaoUtil.getSessao().getCodigoFilial());
        if (Util.listNullOrEmpty((List)listaIdsCupons)) {
            throw new UnicoMensagemUsuarioException("WWW271", "Nenhum cupom fiscal foi encontrado! ");
        }
        return OperacaoRN.getInstance().getCupomFiscalWeb(listaIdsCupons);
    }

    @RequestMapping(value={"/buscar-cupons-por-periodo"})
    @DBAutoCommit
    public List<Operacao> buscarOperacoesPorPeriodo(@RequestParam(required=false) Integer ecf, @RequestParam(required=false) Integer cooInicial, @RequestParam(required=false) Integer cooFinal, @RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal, @RequestParam(required=false) Long idCliente, @RequestParam(required=false) boolean considerarJaImportados) throws UnicoMensagemUsuarioException {
        List listaIdsCupons;
        Entidade cliente;
        String codigoCliente = null;
        if (!Util.longNullOuZero((Long)idCliente) && (cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente)) != null) {
            codigoCliente = cliente.getCodigo();
        }
        if (Util.listNullOrEmpty((List)(listaIdsCupons = OperacaoRN.getInstance().buscarListaIdsCupons(ecf, codigoCliente, cooInicial, cooFinal, dataInicial, dataFinal, SessaoUtil.getSessao().getCodigoFilial(), considerarJaImportados)))) {
            throw new UnicoMensagemUsuarioException("WNTF384", "Nenhum cupom fiscal foi encontrado! ");
        }
        return OperacaoRN.getInstance().getCupomFiscalWeb(listaIdsCupons);
    }

    @RequestMapping(value={"/buscar-lista-sat"})
    @DBAutoCommit
    public List<Operacao> buscarListaSat(@RequestParam(required=false) Long idCliente, @RequestParam(required=false) String numeroDoc, @RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal, @RequestParam(required=false) boolean importados) throws UnicoMensagemUsuarioException {
        List listaOperacoes;
        String codigoCliente = null;
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        if (cliente != null) {
            codigoCliente = cliente.getCodigo();
        }
        if (Util.listNullOrEmpty((List)(listaOperacoes = OperacaoRN.getInstance().buscarListaSat(codigoCliente, numeroDoc, dataInicial, dataFinal, SessaoUtil.getSessao().getCodigoFilial(), importados)))) {
            throw new UnicoMensagemUsuarioException("WNTF8946", "Nenhum SAT foi encontrado!");
        }
        ArrayList<Operacao> operacoes = new ArrayList<Operacao>();
        for (MapResultSet map : listaOperacoes) {
            Operacao op = new Operacao();
            op.setId((Long)map.get("idOperacao"));
            op.setCoo((Integer)map.get("coo"));
            op.setPdv((Integer)map.get("pdv"));
            op.setData((LocalDate)map.get("data"));
            op.setNumeroNfce((String)map.get("numeroNfce"));
            op.setSatSerie((String)map.get("satSerie"));
            op.setCliente((String)map.get("codigoCliente"));
            op.setConsumidorNome((String)map.get("cliente"));
            op.setValorLiquido((BigDecimal)map.get("valorLiquido"));
            op.setModeloNfce(ModeloNotaFiscal.CUPOM_FISCAL_SAT.getId());
            operacoes.add(op);
        }
        return operacoes;
    }

    @RequestMapping(value={"/buscar-lista-nfce"})
    @DBAutoCommit
    public List<Operacao> buscarListaNfce(@RequestParam(required=false) Long idCliente, @RequestParam(required=false) String numeroDoc, @RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal, boolean importados, @RequestParam(required=false) Long idFinalizador) throws UnicoMensagemUsuarioException {
        List listaOperacoes;
        String codigoCliente = null;
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        if (cliente != null) {
            codigoCliente = cliente.getCodigo();
        }
        if (Util.listNullOrEmpty((List)(listaOperacoes = OperacaoRN.getInstance().buscarListaNfce(codigoCliente, numeroDoc, dataInicial, dataFinal, SessaoUtil.getSessao().getCodigoFilial(), importados, idFinalizador)))) {
            throw new UnicoMensagemUsuarioException("WNTF8898", "Nenhuma NFC-e foi encontrada!");
        }
        ArrayList<Operacao> operacoes = new ArrayList<Operacao>();
        for (MapResultSet map : listaOperacoes) {
            Operacao op = new Operacao();
            op.setId((Long)map.get("idOperacao"));
            op.setCoo((Integer)map.get("coo"));
            op.setPdv((Integer)map.get("pdv"));
            op.setData((LocalDate)map.get("data"));
            op.setNumeroNfce((String)map.get("numeroNfce"));
            op.setSerieNfce((String)map.get("serieNfce"));
            op.setCliente((String)map.get("codigoCliente"));
            op.setConsumidorNome((String)map.get("cliente"));
            op.setValorLiquido((BigDecimal)map.get("valorLiquido"));
            op.setUsuario((String)map.get("usuario"));
            op.setChaveAcessoNfce((String)map.get("chaveacessonfce"));
            op.setModeloNfce("65");
            op.setTemDevolucao(Util.longNullOuZero((Long)((Long)map.get("iddevolucao"))) ? "N\u00e3o" : "Sim");
            operacoes.add(op);
        }
        return operacoes;
    }
}

