/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.lancamentosgerais;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.sped.LancamentosGerais;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.sped.contribuicoes.TipoOperacaoGeradoraContribuicao;
import br.intelidata.commons.sped.regranegocio.LancamentosGeraisRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lancamentos-gerais"})
@SubMenuMapping(MENU="SubMenuPainelContadorLancamentos", NOME="Lan\u00e7amentos gerais - F100 Contribui\u00e7\u00f5es", ICONE="icon-funcoes-auxiliares", ROTA="/speds/lancamentos-gerais", PROGRAMA=1317)
public class LancamentoGeralCrudController
extends CrudController<LancamentosGerais, LancamentosGeraisRN> {
    public LancamentoGeralCrudController() {
        super((AbstractRegraNegocio)LancamentosGeraisRN.getInstance(), LancamentosGerais::new, true, true);
    }

    protected String getCacheId() {
        return "lancamentos-gerais";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "Codigo", 0, true));
        colunas.add(new ColunaSQL("dataoperacao", "Dia da Opera\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("valoroperacao", "Valor", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeFornecedor", "Fornecedor", 0, true, new String[]{"fk_lancamentoaluguel_cliente"}));
        GridBuilder grid = new GridBuilder(((LancamentosGeraisRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        return grid;
    }

    protected void beforeSave(@RequestBody LancamentosGerais lancamentosGerais, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (lancamentosGerais.getOperacaoGeradoraContribuicao() != null && lancamentosGerais.getOperacaoGeradoraContribuicao().equals((Object)TipoOperacaoGeradoraContribuicao.AQUISICAO)) {
            if (NumberUtil.longNullOuZero((Long)lancamentosGerais.getIdParticipante())) {
                throw new UnicoMensagemUsuarioException("WCOM165", "Cliente deve ser selecionado para esse tipo de Origem!");
            }
            if (NumberUtil.longNullOuZero((Long)lancamentosGerais.getBaseCalculoCredito())) {
                throw new UnicoMensagemUsuarioException("WCOM235915", "Informe o 'C\u00f3digo Base de Cr\u00e9dito'!");
            }
            if (lancamentosGerais.getOrigemCredito() == null) {
                throw new UnicoMensagemUsuarioException("WCOM235916", "Informe a 'Origem do Cr\u00e9dito'!");
            }
        }
        if (lancamentosGerais.getCstPisCofins() != null && !lancamentosGerais.getOperacaoGeradoraContribuicao().getCsts().contains(lancamentosGerais.getCstPisCofins().getId())) {
            throw new UnicoMensagemUsuarioException("WCOM166", "A origem \u00e9 incompat\u00edvel com a CST de PIS/COFINS selecionada");
        }
    }

    protected void beforeCreate(@RequestBody LancamentosGerais lancamentosGerais, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        lancamentosGerais.setIdFilial(SessaoUtil.getSessao().getIdFilial());
    }
}

