/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoEventoPagFrete;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ManifestoEventoPagFreteCommonRN;
import br.intelidata.commons.modulo.manifesto.MdfeManagerWeb;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/evento-pagamento-frete"})
public class ManifestoEventoPagamentoFreteCrudController
extends CrudController<ManifestoEventoPagFrete, ManifestoEventoPagFreteCommonRN> {
    @Autowired
    public ManifestoEventoPagamentoFreteCrudController() {
        super((AbstractRegraNegocio)ManifestoEventoPagFreteCommonRN.getInstance(), ManifestoEventoPagFrete::new, true, true);
        this.dependsOn("idManifesto");
    }

    protected String getCacheId() {
        return "evento-pagamento-frete".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<ManifestoEventoPagFreteCommonRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idManifesto", "ID", 0, false));
        colunas.add(new ColunaSQL("quantidadeviagem", "Quantidade de viagens", 300, true));
        colunas.add(new ColunaSQL("numeroreferenciaviagem", "N\u00famero de refer\u00eancia", 300, true));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 300, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true));
        colunas.add(new ColunaSQL("datahora", "Data e hora de transmiss\u00e3o", 300, true));
        colunas.add(new ColunaSQL("mensagemRetorno", "Mensagem retorno", 0, true));
        GridBuilder grid = new GridBuilder(((ManifestoEventoPagFreteCommonRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id"));
        return grid;
    }

    @RequestMapping(value={"/transmitir"})
    @DBTransaction
    public void transmitir(@RequestParam Long idEventoPagamento) throws UnicoMensagemUsuarioException {
        MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), null);
        mdfeManagerWeb.getMdfeManager().enviarEventoPagamentoFrete(idEventoPagamento);
    }
}

