/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.identificacaovenda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.Etiqueta;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ModeloEtiqueta;
import br.intelidata.commons.domain.pojo.enuns.LayoutEtiqueta;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.etiqueta.EtiquetaIdentificacaoVenda;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaIdentificacaoVenda;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaJasperRelatorio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.ModeloEtiquetaCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.identificacaovenda.EtiquetaIdentificacaoVendaWrapper;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/modelos-identificacoa-venda"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarModeloImpressao", NOME="Etiqueta de identifica\u00e7\u00e3o de venda", ROTA="/cadastros/modelos-identificacoa-venda", PROGRAMA=149)
public class ModeloEtiquetaIdentificacaoVendaCrudController
extends ModeloEtiquetaCrudController {
    private final ResponseEntityService responseService;

    public ModeloEtiquetaIdentificacaoVendaCrudController(ResponseEntityService responseService) {
        super(LayoutEtiqueta.IDENTIFICACAO_VENDA);
        this.responseService = responseService;
    }

    protected String getCacheId() {
        return "modelos-identificacoa-venda";
    }

    public ModeloEtiquetaModel<EtiquetaIdentificacaoVenda> getModelo() {
        return new ModeloEtiquetaIdentificacaoVenda();
    }

    @RequestMapping(value={"/buscar-modelos"})
    @DBAutoCommit
    public List<ModeloEtiqueta> carregarListaModelo() {
        return ModeloEtiquetaRN.getInstance().getListModeloImpressaoWeb(LayoutEtiqueta.IDENTIFICACAO_VENDA);
    }

    @RequestMapping(value={"/imprimir"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirIdentificacaoVenda(@RequestBody EtiquetaIdentificacaoVendaWrapper identificacaoWrapper) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)identificacaoWrapper.getIdModelo())) {
            throw new UnicoMensagemUsuarioException("WETQ61", "Informe o modelo de etiqueta a ser impresso");
        }
        ModeloEtiqueta modeloEtiqueta = ModeloEtiquetaRN.getInstance().buscarPorId(identificacaoWrapper.getIdModelo(), true);
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(identificacaoWrapper.getIdNotaFiscal());
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
        Entidade transportadora = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdTransportadora());
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        EtiquetaIdentificacaoVenda etiqueta = new EtiquetaIdentificacaoVenda();
        notaFiscal.setNotaFiscalItens(NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(notaFiscal.getId()));
        etiqueta.setNotaFiscal(notaFiscal);
        etiqueta.setFilial(filial);
        etiqueta.setCliente(cliente);
        etiqueta.setTransportadora(transportadora);
        ModeloEtiquetaIdentificacaoVenda model = new ModeloEtiquetaIdentificacaoVenda();
        model.setModeloEtiqueta(modeloEtiqueta);
        model.setEtiquetas((Etiqueta[])new EtiquetaIdentificacaoVenda[]{etiqueta});
        HashMap<String, Boolean> parametros = new HashMap<String, Boolean>();
        parametros.put("imprimirPorVariacao", identificacaoWrapper.isImprimirPorVariacao());
        parametros.put("naoAgrupar", identificacaoWrapper.isNaoAgrupar());
        Remessa remessa = new EtiquetaJasperRelatorio().getRelatorio(Contexto.getInstance().getSessao(), (ModeloEtiquetaModel)model, parametros, 1, 1);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"etiqueta_identificacao_venda");
    }
}

