/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.volumepedidofaturamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.Etiqueta;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ModeloEtiqueta;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.enuns.LayoutEtiqueta;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.etiqueta.EtiquetaVolumePedidoFaturamento;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaVolumePedidoFaturamento;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaJasperRelatorio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.EtiquetaVolumeWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.ModeloEtiquetaCrudController;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/modelos-volume-pedido-faturamento"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarModeloImpressao", NOME="Etiqueta de volume de pedido de faturamento", ROTA="/cadastros/modelos-volume-pedido-faturamento", PROGRAMA=50001)
public class VolumePedidoFaturamentoCrudController
extends ModeloEtiquetaCrudController {
    private final ResponseEntityService responseService;

    public VolumePedidoFaturamentoCrudController(ResponseEntityService responseService) {
        super(LayoutEtiqueta.VOLUME_PEDIDO_FATURAMENTO);
        this.responseService = responseService;
    }

    @RequestMapping(value={"/buscar-modelo-volume"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarPorModeloVolume(@RequestParam(value="limit", required=false, defaultValue="6") Integer limite) {
        String json = "";
        List modelos = ModeloEtiquetaRN.getInstance().getListModeloImpressaoWeb(LayoutEtiqueta.VOLUME_PEDIDO_FATURAMENTO);
        if (!modelos.isEmpty()) {
            json = modelos.stream().map(modelo -> "{\"id\":".concat(modelo.getId().toString()).concat(", \"descricao\":").concat(JsonUtil.escapeQuote((String)modelo.getDescricao())).concat("}")).collect(Collectors.joining(","));
        }
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    protected String getCacheId() {
        return "modelos-volume-pedido-faturamento";
    }

    public ModeloEtiquetaModel getModelo() {
        return new ModeloEtiquetaVolumePedidoFaturamento();
    }

    @RequestMapping(value={"/imprimir-modelo-volume"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirEtiquetas(@RequestBody EtiquetaVolumeWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (wrapper.getQuantidadeVolume() <= 0) {
            throw new UnicoMensagemUsuarioException("WETQ64", "A quantidade de volumes deve ser maior que zero");
        }
        if (wrapper.getVolumeInicial() < 1 || wrapper.getVolumeInicial() > wrapper.getQuantidadeVolume()) {
            throw new UnicoMensagemUsuarioException("WETQ65", "O volume inicial deve ser maior que zero  e menor ou igual ao quantidade de volumes");
        }
        if (wrapper.getVolumeFinal() > wrapper.getQuantidadeVolume() || wrapper.getVolumeFinal() < wrapper.getVolumeInicial()) {
            throw new UnicoMensagemUsuarioException("WETQ66", "O volume final deve ser menor ou igual a quantidade de volumes e maior ou igual ao volume inicial");
        }
        if (NumberUtil.longNullOuZero((Long)wrapper.getIdModelo())) {
            throw new UnicoMensagemUsuarioException("WETQ67", "Informe o modelo de etiqueta a ser impresso");
        }
        ModeloEtiqueta modeloEtiqueta = ModeloEtiquetaRN.getInstance().buscarPorId(wrapper.getIdModelo(), true);
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(wrapper.getIdDocumento());
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(pedido.getIdCliente());
        Entidade transportadora = (Entidade)EntidadeRN.getInstance().buscarPorId(pedido.getIdTransportadora());
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(pedido.getIdFilial());
        EtiquetaVolumePedidoFaturamento etiqueta = new EtiquetaVolumePedidoFaturamento();
        etiqueta.setPedido(pedido);
        etiqueta.setFilial(filial);
        etiqueta.setCliente(cliente);
        etiqueta.setTransportadora(transportadora);
        etiqueta.setQuantidadeVolume(wrapper.getQuantidadeVolume());
        etiqueta.setVolumeInicial(wrapper.getVolumeInicial());
        etiqueta.setVolumeFinal(wrapper.getVolumeFinal());
        ModeloEtiquetaVolumePedidoFaturamento model = new ModeloEtiquetaVolumePedidoFaturamento();
        model.setModeloEtiqueta(modeloEtiqueta);
        model.setEtiquetas((Etiqueta[])new EtiquetaVolumePedidoFaturamento[]{etiqueta});
        Remessa remessa = new EtiquetaJasperRelatorio().getRelatorio(SessaoUtil.getSessao(), (ModeloEtiquetaModel)model, null, 1, 1);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"etiqueta_volume");
    }
}

