/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.motivocontrato;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.TipoMotivoEncerramentoContrato;
import br.intelidata.commons.domain.pojo.vendas.MotivoEncerramentoContrato;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.contrato.regranegocio.MotivoEncerramentoContratoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/motivos-encerramento-contratos"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarParametrosVenda", NOME="Motivos de contratos", ROTA="/vendas/motivos-encerramento-contratos", PROGRAMA=1360)
public class MotivoEncerramentoContratoCrudController
extends CrudController<MotivoEncerramentoContrato, MotivoEncerramentoContratoRN> {
    public MotivoEncerramentoContratoCrudController() {
        super((AbstractRegraNegocio)MotivoEncerramentoContratoRN.getInstance(), MotivoEncerramentoContrato::new);
    }

    @RequestMapping(value={"/por-tipo"})
    @DBAutoCommit
    public List<MotivoEncerramentoContrato> buscarMotivosPorTipo(@RequestParam TipoMotivoEncerramentoContrato tipo) {
        return ((MotivoEncerramentoContratoRN)this.rn).getComboPorTipoWeb(tipo);
    }

    protected String getCacheId() {
        return "motivos-encerramento-contratos";
    }

    protected GridBuilder<MotivoEncerramentoContratoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true));
        return new GridBuilder(((MotivoEncerramentoContratoRN)this.rn).getTabela(), colunas);
    }
}

