/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.naturezaoperacao.incentivoimposto;

import br.intelidata.commons.domain.pojo.NaturezaOperacaoIncentivoImposto;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.CstPisCofins;
import br.intelidata.commons.domain.pojo.enuns.TipoImpostoIncentivado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoIncentivoImpostoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/incentivos-impostos"})
public class IncentivoImpostoCrudController
extends CrudController<NaturezaOperacaoIncentivoImposto, NaturezaOperacaoIncentivoImpostoRN> {
    public IncentivoImpostoCrudController() {
        super((AbstractRegraNegocio)NaturezaOperacaoIncentivoImpostoRN.getInstance(), NaturezaOperacaoIncentivoImposto::new);
        this.dependsOn("idNaturezaOperacao");
    }

    protected GridBuilder<NaturezaOperacaoIncentivoImpostoRN> getGridBuilder() {
        return new GridBuilder(NaturezaOperacaoIncentivoImpostoRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected String getCacheId() {
        return "incentivos-impostos";
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<NaturezaOperacaoIncentivoImposto> carregar(@RequestParam Long idNaturezaOperacao) {
        List noii = NaturezaOperacaoIncentivoImpostoRN.getInstance().buscarPorNaturezaOperacao(idNaturezaOperacao);
        for (NaturezaOperacaoIncentivoImposto ii : noii) {
            CstICMS cst;
            if (ii.getTipoImposto() == null) continue;
            boolean isIcms = ii.getTipoImposto().equals((Object)TipoImpostoIncentivado.ICMS);
            if (isIcms) {
                cst = (CstICMS)ii.getCstEnum();
                ii.setCst(cst.name());
                continue;
            }
            cst = (CstPisCofins)ii.getCstEnum();
            ii.setCst(cst.name());
        }
        return noii;
    }
}

