/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ncm;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.ModalidadeDeterminacaoBcIcmsSt;
import br.intelidata.commons.domain.pojo.Ncm;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroNcm;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.notafiscal.relatorio.NcmInvalidoRelatorio;
import br.intelidata.commons.modulo.produto.IbsCbsCustomizavel;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCodigo;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCst;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsNome;
import br.intelidata.commons.modulo.produto.regranegocio.NcmRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ncms"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Ncms", ROTA="/notas-fiscais/ncms", PROGRAMA=1000014)
public class NcmCrudController
extends CrudController<Ncm, NcmRN> {
    @Autowired
    private ResponseEntityService responseService;

    public NcmCrudController() {
        super((AbstractRegraNegocio)NcmRN.getInstance(), Ncm::new, true, true);
    }

    @RequestMapping(value={"/tipo-ncm"})
    @DBAutoCommit
    public List<Ncm> buscarPorTipoNcm(@RequestParam TipoRegistroNcm tipoNcm, @RequestParam(value="query", required=false) String filtro, @RequestParam(required=false, defaultValue="true") boolean apenasAtivo, @RequestParam int limit) {
        return NcmRN.getInstance().buscarListaPorTipoWeb(SessaoUtil.getSessao(), tipoNcm, apenasAtivo, filtro, limit);
    }

    protected GridBuilder<NcmRN> getGridBuilder() {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("codigoExcecao", "Exce\u00e7\u00e3o", 120, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("percentualMva", "%MVA", 80, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 180, true, TipoRegistroNcm.class));
        colunas.add(new ColunaSQL("percentualImpostoAproximado", "%Imposto aproximado", 160, true));
        colunas.add(new ColunaSQL("percImpostoAproxImportacao", "%Imposto aproximado importa\u00e7\u00e3o", 160, true));
        GridBuilder grid = new GridBuilder(NcmRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("codigo"));
        grid.addOrdemDefault(new Ordem("codigoExcecao"));
        if (ClassificacaoTributariaIbsCbsRN.getInstance().habilitarIbsCbs(sessao.getFilial())) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsNome(sessao, IbsCbsCustomizavel.NCM));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCodigo(sessao, IbsCbsCustomizavel.NCM));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCst(sessao, IbsCbsCustomizavel.NCM));
        }
        return grid;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return NcmRN.getInstance().getColunaGridCustomizavelNCM(SessaoUtil.getSessao());
    }

    protected void beforeUpdate(Ncm ncm, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Ncm original = (Ncm)NcmRN.getInstance().buscarPorId(ncm.getId());
        if (!original.getCodigo().equals(ncm.getCodigo())) {
            ncm.setCodigo(original.getCodigo());
        }
        if (!original.getCodigoExcecao().equals(ncm.getCodigoExcecao())) {
            ncm.setCodigoExcecao(original.getCodigoExcecao());
        }
    }

    protected void beforeSave(Ncm ncm, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ncm.getModalidadeBcIcmsSt() != ModalidadeDeterminacaoBcIcmsSt.MARGEM_VALOR_AGREGADO && ncm.getModalidadeBcIcmsSt() != ModalidadeDeterminacaoBcIcmsSt.NENHUMA) {
            ncm.setPercentualReducaoMva(BigDecimal.ZERO);
        }
    }

    @PostMapping(value={"/ncms-invalidos"})
    @DBTransaction
    public ResponseEntity<byte[]> getRelatorioNcmInvalidos() throws UnicoMensagemUsuarioException {
        return RelatorioUtil.visualizar((Remessa)new NcmInvalidoRelatorio().getRelatorio(), (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"An\u00e1lise de NCMs inv\u00e1lidos");
    }

    protected String getCacheId() {
        return "ncms";
    }
}

