/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.negociacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.EncargoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.ParametroCalculoEncargo;
import br.intelidata.commons.domain.pojo.TipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.NegociacaoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.NegociacaoFinanceiroDestino;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.NegociacaoFinanceiroCommonRN;
import br.intelidata.commons.domain.regranegocio.NegociacaoFinanceiroDestinoCommonRN;
import br.intelidata.commons.domain.regranegocio.NegociacaoFinanceiroOrigemCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoDocumentoFinanceiroCommonRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroDestinoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroOrigemRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.relatorio.NegociacaoFinanceiroImpressao;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/negociacao"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", NOME="Negocia\u00e7\u00e3o", ICONE="icon-e-moeda", ROTA="/financeiros/negociacao", PROGRAMA=437)
public class NegociacaoCrudController
extends CrudController<NegociacaoFinanceiro, NegociacaoFinanceiroCommonRN> {
    public NegociacaoCrudController() {
        super((AbstractRegraNegocio)NegociacaoFinanceiroCommonRN.getInstance(), NegociacaoFinanceiro::new);
    }

    protected String getCacheId() {
        return "negociacao";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "Codigo", 150, true));
        colunas.add(new ColunaSQL("data", "Data", 150, true));
        colunas.add(new ColunaSQL("dataValidade", "Validade", 150, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Nome", 0, true, new String[]{"fk_negfin_cliente"}));
        colunas.add(new ColunaSQL("razaosocial", "razaoSocialCliente", "Raz\u00e3o social", 0, true, new String[]{"fk_negfin_cliente"}));
        colunas.add(new ColunaSQL("status", "Status", 150, true));
        return new GridBuilder(((NegociacaoFinanceiroCommonRN)this.rn).getTabela(), colunas);
    }

    protected void beforeRead(NegociacaoFinanceiro negociacaoFinanceiro, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        negociacaoFinanceiro.setDocumentosDestino(NegociacaoFinanceiroDestinoCommonRN.getInstance().buscarDocumentosDestinoPorNegociacao(negociacaoFinanceiro.getId()));
        negociacaoFinanceiro.setDocumentosOrigem(NegociacaoFinanceiroOrigemCommonRN.getInstance().buscarDocumentosOrigemPorNegociacao(negociacaoFinanceiro.getId()));
        negociacaoFinanceiro.setDocumentosFinanceiroEscolhidos(NegociacaoFinanceiroOrigemCommonRN.getInstance().buscaListaDocumentosEscolhidosPorNegociacao(negociacaoFinanceiro.getId()));
    }

    @RequestMapping(value={"/validar-alteracao"})
    @DBAutoCommit
    public void validarAlteracao(@RequestParam Long id, @RequestParam int modo) throws UnicoMensagemUsuarioException {
        NegociacaoFinanceiro negociacao = (NegociacaoFinanceiro)NegociacaoFinanceiroRN.getInstance().buscarPorId(id);
        if (negociacao != null) {
            if (!negociacao.getStatus().isPodeAlterar() && modo == 1) {
                throw new UnicoMensagemUsuarioException("WWW730", "N\u00e3o \u00e9 permitido alterar uma negocia\u00e7\u00e3o com estatus " + negociacao.getStatus());
            }
            if (!negociacao.getStatus().isPodeExcluir() && modo == 2) {
                throw new UnicoMensagemUsuarioException("WWW734", "N\u00e3o \u00e9 permitido excluir uma negocia\u00e7\u00e3o com estatus " + negociacao.getStatus());
            }
        }
    }

    @RequestMapping(value={"/tipo-documento-negociacao"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> filtrarPorIntegracao() {
        return TipoDocumentoFinanceiroRN.getInstance().buscarTipoDocumentoNegociacaoWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/gerar-parcelas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<NegociacaoFinanceiroDestino> gerarParcelas(@RequestBody NegociacaoFinanceiroDestino negociacao) throws UnicoMensagemUsuarioException {
        return NegociacaoFinanceiroDestinoRN.getInstance().gerarParcelamento(SessaoUtil.getSessao(), negociacao.getDocumento(), negociacao.getIdCliente(), negociacao.getIdTipoDocumento(), negociacao.getIdCondicaoPagamento(), negociacao.getValor(), negociacao.getDataNegociacao(), negociacao.getIdBanco(), negociacao.getAgencia(), negociacao.getConta(), negociacao.getNomeTitular(), negociacao.getCpfCnpjTitular());
    }

    @RequestMapping(value={"/autorizar"})
    @DBTransaction
    public void autorizar(@RequestParam Long idNegociacao) throws UnicoMensagemUsuarioException {
        NegociacaoFinanceiro negociacao = (NegociacaoFinanceiro)NegociacaoFinanceiroRN.getInstance().buscarPorId(idNegociacao);
        if (negociacao != null) {
            if (negociacao.getStatus().isPodeAutorizar()) {
                NegociacaoFinanceiroRN.getInstance().autorizarNegociacao(SessaoUtil.getSessao(), idNegociacao);
            } else {
                throw new UnicoMensagemUsuarioException("WWW731", "N\u00e3o \u00e9 permitido autorizar uma negocia\u00e7\u00e3o com status " + negociacao.getStatus());
            }
        }
    }

    @RequestMapping(value={"/confirmar"})
    @DBTransaction
    public void confirmar(@RequestParam Long idNegociacao) throws UnicoMensagemUsuarioException {
        NegociacaoFinanceiro negociacao = (NegociacaoFinanceiro)NegociacaoFinanceiroRN.getInstance().buscarPorId(idNegociacao);
        if (negociacao != null) {
            if (negociacao.getStatus().isPodeConfirmar()) {
                NegociacaoFinanceiroRN.getInstance().confirmarNegociacao(SessaoUtil.getSessao(), idNegociacao, false);
            } else {
                throw new UnicoMensagemUsuarioException("WWW732", "N\u00e3o \u00e9 permitido confirmar uma negocia\u00e7\u00e3o com status " + negociacao.getStatus());
            }
        }
    }

    @RequestMapping(value={"/estornar"})
    @DBTransaction
    public void extorno(@RequestParam Long idNegociacao) throws UnicoMensagemUsuarioException {
        NegociacaoFinanceiro negociacao = (NegociacaoFinanceiro)NegociacaoFinanceiroRN.getInstance().buscarPorId(idNegociacao);
        if (negociacao != null) {
            if (negociacao.getStatus().isPodeEstornar()) {
                NegociacaoFinanceiroRN.getInstance().estornarNegociacao(SessaoUtil.getSessao(), idNegociacao);
            } else {
                throw new UnicoMensagemUsuarioException("WWW733", "N\u00e3o \u00e9 permitido estornar uma negocia\u00e7\u00e3o com status " + negociacao.getStatus());
            }
        }
    }

    @RequestMapping(value={"/validar-negociacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<FinanceiroDado> validarNegociacao(@RequestBody List<FinanceiroDado> documentos) throws UnicoMensagemUsuarioException {
        if (!Util.listNullOrEmpty(documentos)) {
            NegociacaoFinanceiroOrigemRN.getInstance().validaFinanceiroJaNegociado(documentos);
            Map parametros = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
            Map parametrosTiposDocumentos = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
            Map parametrosEncargosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
            for (FinanceiroDado financeiroDado : documentos) {
                ParametroCalculoEncargo parametro = null;
                if (!Util.longNullOuZero((Long)financeiroDado.getIdContaGeraBoleto())) {
                    parametro = (ParametroCalculoEncargo)parametrosEncargosPorContaCorrente.get(financeiroDado.getIdContaGeraBoleto());
                }
                if (parametro == null && (parametro = (ParametroCalculoEncargo)parametrosTiposDocumentos.get(financeiroDado.getTipoDocumento().getId())) == null) {
                    parametro = (ParametroCalculoEncargo)parametros.get(financeiroDado.getIdFilial());
                }
                financeiroDado.setValorSemNegociacao(financeiroDado.getSaldo());
                EncargoFinanceiro encargoFinanceiro = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(DataHoraFactory.getData(), financeiroDado.getSaldo(), financeiroDado.getVencimentoCalculoEncargos() != null ? financeiroDado.getVencimentoCalculoEncargos() : financeiroDado.getVencimento(), parametro, financeiroDado.getVencimentoCalculoEncargos() != null && financeiroDado.getVencimentoCalculoEncargos().compareTo(financeiroDado.getVencimento()) != 0);
                if (encargoFinanceiro == null) continue;
                financeiroDado.setValorTotalJuros(encargoFinanceiro.getValorJuros());
                financeiroDado.setJuros(encargoFinanceiro.getValorJuros());
                financeiroDado.setValorTotalMulta(encargoFinanceiro.getValorMulta());
                financeiroDado.setMulta(encargoFinanceiro.getValorMulta());
                financeiroDado.setDesconto(encargoFinanceiro.getDesconto());
                financeiroDado.setValorLiquidoNegociado(financeiroDado.getSaldo().add(encargoFinanceiro.getValorJuros()).add(encargoFinanceiro.getValorMulta()).subtract(encargoFinanceiro.getDesconto()));
            }
            return documentos;
        }
        return null;
    }

    @RequestMapping(value={"/imprimir-negociacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody SaidaImpressaoWrapper saida, @RequestParam Long idNegociacao) throws UnicoMensagemUsuarioException {
        UViewer rel = new NegociacaoFinanceiroImpressao().getRelatorio(SessaoUtil.getSessao(), idNegociacao, saida.getSaidaRelatorio().getSaida());
        return RelatorioUtil.visualizar((Remessa)rel.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)saida.getSaidaRelatorio(), (String)"Negociacao");
    }
}

