/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.job;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCompartilhamentoComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.NotaFiscalTransmissaoWrapper;
import java.util.ArrayList;
import java.util.List;

public class JobTransmissaoNfe
extends AbstractPrepareJob {
    public JobTransmissaoNfe(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        NotaFiscalTransmissaoWrapper wrapper = (NotaFiscalTransmissaoWrapper)this.getObjetoDeserializado(NotaFiscalTransmissaoWrapper.class);
        Sessao sessao = SessaoUtil.getSessaoJob();
        boolean isNFe = NotaFiscalRN.getInstance().isNfe((Long)wrapper.getIds().get(0));
        if (isNFe) {
            new NfeManagerWeb(sessao, (mensagem, processo) -> this.addMensagemRetorno("", mensagem)).processarNfe(wrapper.getIds());
        } else {
            ArquivoFiscalWeb arquivoFiscalWeb = (ArquivoFiscalWeb)BeanUtil.getBean((String)"arquivoFiscalWeb");
            new NfseManagerWeb(sessao, (mensagem, pularLinha) -> this.addMensagemRetorno("", mensagem), (IFileStorage)arquivoFiscalWeb).processaNfse(wrapper.getIds());
        }
        List nfsAutorizadas = this.getNotaFiscalsAutorizadas(wrapper.getIds());
        if (!nfsAutorizadas.isEmpty()) {
            NotaFiscalCompartilhamentoComponent notaFiscalCompartilhamentoComponent = (NotaFiscalCompartilhamentoComponent)BeanUtil.getBean((String)"notaFiscalCompartilhamentoComponent");
            if (wrapper.isEnviarEmail()) {
                notaFiscalCompartilhamentoComponent.agendarEnvioEmail(sessao, nfsAutorizadas, wrapper);
            }
        }
        this.addMensagemRetorno("WWW253", "Processo conclu\u00eddo com sucesso!");
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Processo de transmiss\u00e3o de NF-e conclu\u00eddo.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Houve um problema no processo de transmiss\u00e3o de NF-e! verifique.");
    }

    private List<NotaFiscal> getNotaFiscalsAutorizadas(List<Long> idsNotasFiscais) {
        ArrayList<NotaFiscal> notasAutorizadas = new ArrayList<NotaFiscal>();
        for (NotaFiscal notaFiscal : NotaFiscalCommonRN.getInstance().buscarListaPorIds(idsNotasFiscais)) {
            boolean autorizada;
            boolean bl = autorizada = notaFiscal.getStatus().in(new AbstractEnum[]{StatusNotaFiscal.NFE_AUTORIZADA, StatusNotaFiscal.NFSE_AUTORIZADA}) && notaFiscal.getArquivoXmlAutorizada() != null;
            if (!notaFiscal.getTipoDocumento().getId().equals(TipoNotaFiscal.SAIDA.getId()) || !autorizada) continue;
            notasAutorizadas.add(notaFiscal);
        }
        return notasAutorizadas;
    }
}

