/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCompartilhamentoComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.job.JobTransmissaoEPEC;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.job.JobTransmissaoNfe;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.NotaFiscalTransmissaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.TransmissaoNotaFiscalCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.CompartilhamentoRetornoWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/transmissoes-nfe"})
public class TransmissaoNotaFiscalJobSimpleCrudController
extends TransmissaoNotaFiscalCrudController
implements ICreateTask {
    private final TaskManager taskManager;
    private final NotaFiscalCompartilhamentoComponent notaFiscalCompartilhamentoComponent;
    private Class<? extends AbstractJob> job;
    private TipoJob tipoJob;

    public TransmissaoNotaFiscalJobSimpleCrudController(CalculoImpostoService<NotaFiscalItem> calculoImpostoService, TaskManager taskManager, NotaFiscalCompartilhamentoComponent notaFiscalCompartilhamentoComponent, NotificationService notificationService, ArquivoFiscalWeb arquivoFiscalWeb) {
        super(calculoImpostoService, arquivoFiscalWeb);
        this.taskManager = taskManager;
        this.notaFiscalCompartilhamentoComponent = notaFiscalCompartilhamentoComponent;
        this.notificationService = notificationService;
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public Class<? extends AbstractJob> job() {
        return this.job;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public TypeQueue getQueue() {
        return TypeQueue.RECURRING_QUEUE;
    }

    @RequestMapping(value={"/transmissao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public CompartilhamentoRetornoWrapper transmitirNfe(@RequestBody NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        super.transmitirNotas(wrapper);
        List notasAutorizadas = this.getNotaFiscalsAutorizadas(wrapper.getIds());
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList excessoes = new ArrayList();
        if (wrapper.isEnviarEmail()) {
            excessoes.addAll(this.notaFiscalCompartilhamentoComponent.agendarEnvioEmail(sessao, notasAutorizadas, wrapper));
        }
        CompartilhamentoRetornoWrapper retorno = new CompartilhamentoRetornoWrapper(excessoes);
        if (wrapper.isEnviarWhatsApp()) {
            this.notaFiscalCompartilhamentoComponent.enviarWhatsApp(sessao, notasAutorizadas, retorno, wrapper);
        }
        retorno.setNotasAutorizadas(!notasAutorizadas.isEmpty());
        return retorno;
    }

    @RequestMapping(value={"/agendar-epec"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarTransmissaoEpec(@RequestBody NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        String numeroNf = this.validarEPEC(wrapper);
        this.verificarValidadeCertificado(new NfeManagerWeb(SessaoUtil.getSessao(), null));
        this.tipoJob = TipoJob.TRANSMISSAO_EPEC;
        this.job = JobTransmissaoEPEC.class;
        this.createTask((Object)wrapper, "Transmiss\u00e3o por EPEC da nota fiscal ".concat(numeroNf).concat("."));
    }

    @RequestMapping(value={"/agendar-transmissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarNotas(@RequestBody NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)wrapper.getIds())) {
            throw new UnicoMensagemUsuarioException("WWW248", "Por favor informe as notas fiscais.");
        }
        Map nota = NotaFiscalRN.getInstance().buscarValoresPorID((Long)wrapper.getIds().get(0), new String[]{"serie"});
        boolean isNFe = ((String)nota.get("serie")).equalsIgnoreCase("55");
        this.validarNotas(wrapper.getIds(), isNFe);
        if (isNFe) {
            this.verificarValidadeCertificado(new NfeManagerWeb(SessaoUtil.getSessao(), null));
        } else if (!LicencaManager.getInstance().isNfse()) {
            throw new UnicoMensagemUsuarioException("WWW748", "N\u00e3o \u00e9 poss\u00edvel transmitir NFS-e sem a respectiva licen\u00e7a.");
        }
        this.tipoJob = TipoJob.TRANSMISSAO_NFE;
        this.job = JobTransmissaoNfe.class;
        String prefixo = wrapper.getIds().size() > 1 ? "Transmiss\u00e3o da ".concat(isNFe ? "NF-e " : "NFS-e ") : "Transmiss\u00e3o das seguintes ".concat(isNFe ? "NF-es " : "NFS-es ");
        String detalhe = prefixo + NotaFiscalRN.getInstance().buscarNumerosNotaFiscalPorListaId(wrapper.getIds()) + ".";
        this.createTask((Object)wrapper, detalhe);
    }

    protected String getCacheId() {
        return null;
    }

    protected GridBuilder<?> getGridBuilder() {
        return null;
    }

    private List<NotaFiscal> getNotaFiscalsAutorizadas(List<Long> idsNotasFiscais) {
        ArrayList<NotaFiscal> notasAutorizadas = new ArrayList<NotaFiscal>();
        for (NotaFiscal notaFiscal : NotaFiscalCommonRN.getInstance().buscarListaPorIds(idsNotasFiscais)) {
            boolean autorizada;
            boolean bl = autorizada = notaFiscal.getStatus().in(new AbstractEnum[]{StatusNotaFiscal.NFE_AUTORIZADA, StatusNotaFiscal.NFSE_AUTORIZADA}) && notaFiscal.getArquivoXmlAutorizada() != null;
            if (!notaFiscal.getTipoDocumento().getId().equals(TipoNotaFiscal.SAIDA.getId()) || !autorizada) continue;
            notasAutorizadas.add(notaFiscal);
        }
        return notasAutorizadas;
    }
}

