/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.gestao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.util.Danfe2;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.SituacaoManifestacaoDestinatario;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.SituacaoDocumentoFiscalFornecedor;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.DocumentoFiscalFornecedor;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoFiscalFornecEventoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoFiscalFornecedorRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.gestao.ManifestoDocumentoWrapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gestao-nfe"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Gest\u00e3o de NF-e do fornecedor", ICONE="icon-nota-fiscal-saida", ROTA="/notas-fiscais/gestao-nfe", PROGRAMA=1463)
public class DocumentoFiscalFornecedorCrudController
extends CrudController<DocumentoFiscalFornecedor, DocumentoFiscalFornecedorRN> {
    public DocumentoFiscalFornecedorCrudController() {
        super((AbstractRegraNegocio)DocumentoFiscalFornecedorRN.getInstance(), DocumentoFiscalFornecedor::new, true, true);
    }

    protected String getCacheId() {
        return "gestao-nfe".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idNotaFiscal", "idNotaFiscal", 0, false));
        colunas.add(new ColunaSQL("numeroDocumento", "N\u00famero", 80, true));
        colunas.add(new ColunaSQL("serieDocumento", "S\u00e9rie", 65, true));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("razaoSocial", "Fornecedor", 280, true));
        colunas.add(new ColunaSQL("cnpjcpf", "CNPJ/CPF", 140, true));
        colunas.add(new ColunaSQL("valor", "Valor", 80, true));
        colunas.add(new ColunaSQL("dataPrimeiroVencimento", "Vencimento", 110, true));
        colunas.add(new ColunaSQL("situacaoNfe", "Situa\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("situacaoManifestacao", "Manifesta\u00e7\u00e3o", 130, true));
        colunas.add(new ColunaSQL("situacaoDocumentoFiscal", "Status", 230, true));
        colunas.add(new ColunaSQL("cte", "CT-e", 80, true));
        colunas.add(new ColunaSQL("mdfe", "MDF-e", 80, true));
        colunas.add(new ColunaSQL("chaveAcesso", "Chave de acesso", 320, true));
        ColunaSQL colunaEvento = new ColunaSQL("evento", "Evento", 0, false);
        colunaEvento.setVirtual(true);
        colunas.add(colunaEvento);
        ColunaSQL colunaImprimir = new ColunaSQL("imprimir", "Imprimir", 0, false);
        colunaImprimir.setVirtual(true);
        colunas.add(colunaImprimir);
        Sessao sessao = SessaoUtil.getSessao();
        GridBuilder grid = new GridBuilder(((DocumentoFiscalFornecedorRN)this.rn).getTabela(), colunas, "documento-fiscal_filial" + sessao.getIdFilial());
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilialref"));
        grid.addCodicaoDefault(new Condicao("idfilialref", Operador.IGUAL, sessao.getIdFilial()));
        grid.addReferenciaDefault(new Referencia("emissao", "emissaoref"));
        grid.addOrdemDefault(new Ordem("emissaoref", true));
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(doc -> {
            int idxEvento = this.getIndexColuna("evento", colunas);
            int idxImp = this.getIndexColuna("imprimir", colunas);
            int idxId = this.getIndexColuna("id", colunas);
            Long id = (Long)doc[idxId];
            if (!NumberUtil.longNullOuZero((Long)id)) {
                List eventos = DocumentoFiscalFornecEventoRN.getInstance().buscarListaPorIdDocumentoFornecedor(id);
                doc[idxEvento] = JsonUtil.toJson((List)eventos, (String[])new String[]{"id", "descricaoEvento", "sequencia", "codigoEvento"});
                DocumentoFiscalFornecedor docFiscal = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(id);
                doc[idxImp] = docFiscal.getArquivoXml() != null;
            }
        });
    }

    @RequestMapping(value={"manifesto-documento"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void manifestarDocumento(@RequestBody ManifestoDocumentoWrapper manifestoDocumento) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(manifestoDocumento.getIdDocumentoFiscal());
        this.manifestacaoDestinatario(doc, manifestoDocumento.getSituacao(), manifestoDocumento.getJustificativa());
        this.notificationService.notifyUserNow(NotificationType.GESTAO_NFE, (Object)"");
    }

    @RequestMapping(value={"gerar-danfe"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDanfe(@RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(idDocumento);
        if (doc != null && doc.getArquivoXml() != null) {
            String chaveAcesso = doc.getChaveAcesso();
            if (StringUtil.stringNullOrEmpty((String)chaveAcesso)) {
                chaveAcesso = StringUtil.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"HHmmss");
            }
            byte[] arquivoPdf = Danfe2.getInstance().geraDanfeWeb(chaveAcesso, null, (InputStream)new ByteArrayInputStream(doc.getArquivoXml()), false, null, null, null, null, false, UnicoSistema.getNomeSistema(), null, SessaoUtil.getSessao().getFilial(), StatusNotaFiscal.NORMAL);
            return this.responseEntityService.createPDFResponse(arquivoPdf, chaveAcesso);
        }
        throw new UnicoMensagemUsuarioException("WWW705", "N\u00e3o foi poss\u00edvel gerar DANFE. Documento n\u00e3o localizado ou sem XML.");
    }

    @RequestMapping(value={"download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestParam Long idDocumento, @RequestParam(required=false) boolean confirmar, @RequestParam(defaultValue="false", required=false) boolean importacao) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(idDocumento);
        if (doc != null && doc.getArquivoXml() != null) {
            if (importacao && confirmar && !SituacaoManifestacaoDestinatario.CONFIRMADA.equals((Object)doc.getSituacaoManifestacao())) {
                this.manifestacaoDestinatario(doc, SituacaoManifestacaoDestinatario.CONFIRMADA, "");
                if (SituacaoDocumentoFiscalFornecedor.LIBERACAO_PENDENTE.equals((Object)doc.getSituacaoDocumentoFiscal())) {
                    doc.setSituacaoDocumentoFiscal(SituacaoDocumentoFiscalFornecedor.IMPORTACAO_PENDENTE);
                    DocumentoFiscalFornecedorRN.getInstance().alterar((AbstractPojo)doc, SessaoUtil.getSessao());
                    this.notificationService.notifyUserNow(NotificationType.GESTAO_NFE, (Object)"");
                }
            }
            return this.responseEntityService.createXMLResponse(doc.getArquivoXml(), doc.getChaveAcesso());
        }
        throw new UnicoMensagemUsuarioException("WWW706", "N\u00e3o foi poss\u00edvel baizar XML. Documento n\u00e3o localizado ou sem XML.");
    }

    @RequestMapping(value={"forcar-download-xml"})
    @DBAutoCommit
    public void forcarDownloadXML(@RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(idDocumento);
        if (doc != null && SituacaoDocumentoFiscalFornecedor.SEFAZ_NAO_RETORNOU_XML.equals((Object)doc.getSituacaoDocumentoFiscal())) {
            DocumentoFiscalFornecedorRN.getInstance().efetuarDownloadManual(SessaoUtil.getSessao(), doc);
        }
    }

    @RequestMapping(value={"consultar-situacao"})
    @DBAutoCommit
    public boolean isNfeHomologacao(Long idDocumento) {
        return DocumentoFiscalFornecedorRN.getInstance().isNfeHomologacao(idDocumento);
    }

    @RequestMapping(value={"ignorar-xml"})
    @DBTransaction
    public void ignorarXML(@RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedorRN.getInstance().ignorarXml(SessaoUtil.getSessao(), idDocumento);
    }

    @RequestMapping(value={"gerar-nota-fiscal"})
    @DBTransaction
    public NotaFiscal gerarNotaFiscal(@RequestParam Long idDocumento, @RequestParam boolean confirmar) throws UnicoMensagemUsuarioException {
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(idDocumento);
        if (doc != null && doc.getArquivoXml() != null && doc.getSituacaoDocumentoFiscal().isPodeImportar()) {
            if (confirmar && !SituacaoManifestacaoDestinatario.CONFIRMADA.equals((Object)doc.getSituacaoManifestacao())) {
                this.manifestacaoDestinatario(doc, SituacaoManifestacaoDestinatario.CONFIRMADA, "");
            }
            if (doc.getSituacaoDocumentoFiscal().equals((Object)SituacaoDocumentoFiscalFornecedor.LIBERACAO_PENDENTE)) {
                Sessao sessao = SessaoUtil.getSessao();
                DocumentoFiscalFornecedorRN.getInstance().validaImportacaoXmlParaLiberacaoNotaFiscal(sessao, doc);
                return NotaFiscalRN.getInstance().gerarNotaFiscalImportacaoGestaoNfe(sessao.getFilial(), sessao, doc.getChaveAcesso());
            }
        }
        throw new UnicoMensagemUsuarioException("WWW707", "N\u00e3o foi poss\u00edvel gerar a nota fiscal. Documento n\u00e3o localizado ou sem XML!");
    }

    @PostMapping(value={"gerar-mdfe"})
    @DBTransaction
    public ManifestoDocumento gerarMdfe(@RequestBody List<Long> idsDocumentos) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = DocumentoFiscalFornecedorRN.getInstance().gerarMDFe(idsDocumentos);
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfes())) {
            ArrayList<ManifestoNotaFiscal> listaNF = new ArrayList<ManifestoNotaFiscal>();
            ArrayList<ManifestoNotaFiscal> listaNFTerceiro = new ArrayList<ManifestoNotaFiscal>();
            for (ManifestoNotaFiscal nota : manifestoDocumento.getNfes()) {
                if (!Util.longNullOuZero((Long)nota.getIdNotaFiscal())) {
                    listaNF.add(nota);
                    continue;
                }
                listaNFTerceiro.add(nota);
            }
            manifestoDocumento.setNfes(listaNF);
            manifestoDocumento.setNfesTerceiro(listaNFTerceiro);
        }
        return manifestoDocumento;
    }

    private void manifestacaoDestinatario(DocumentoFiscalFornecedor doc, SituacaoManifestacaoDestinatario situacao, String justificativa) throws UnicoMensagemUsuarioException {
        String retornoComSucesso;
        Sessao sessao = SessaoUtil.getSessao();
        if (situacao.isPedirJustificativa() && StringUtil.stringNullOrEmpty((String)justificativa)) {
            throw new UnicoMensagemUsuarioException("WWW704", "Justificativa n\u00e3o informada.");
        }
        if (doc != null && !StringUtil.stringNullOrEmpty((String)(retornoComSucesso = new NfeManagerWeb(sessao, null).manifestacaoDestinatario(sessao, doc, situacao, justificativa)))) {
            this.notificationService.notifyTenantNow(NotificationType.MANIFESTACAO_GESTAO, retornoComSucesso);
        }
    }
}

