/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.novidade;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Novidade;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.NovidadeRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/novidade-cadastro"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Novidades", ROTA="/intelidata/novidade-cadastro", PROGRAMA=6008)
public class NovidadeCrudController
extends CrudController<Novidade, NovidadeRN> {
    @Autowired
    public NovidadeCrudController() {
        super((AbstractRegraNegocio)NovidadeRN.getInstance(), Novidade::new, TipoArquivoArmazenado.NOVIDADE);
    }

    protected String getCacheId() {
        return "novidade-cadastro";
    }

    protected GridBuilder<NovidadeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 250, true));
        colunas.add(new ColunaSQL("urlimagemprincipal", "Imagem principal", 400, true));
        colunas.add(new ColunaSQL("urlimagemsabermais", "Imagem Saber Mais", 400, true));
        colunas.add(new ColunaSQL("inativo", "Inativo", 100, true));
        colunas.add(new ColunaSQL("tiposistema", "Tipo de sistema", 100, true));
        colunas.add(new ColunaSQL("licenca", "Licen\u00e7a", 200, true));
        colunas.add(new ColunaSQL("sistemas", "Sistemas", 400, true));
        colunas.add(new ColunaSQL("teste", "Teste", 100, true));
        colunas.add(new ColunaSQL("nome", "revenda", "Revenda", 100, true, new String[]{"fk_novidade_revenda"}));
        GridBuilder gridBuilder = new GridBuilder(NovidadeRN.getInstance().getTabela(), colunas);
        return gridBuilder;
    }

    protected void beforeUpdate(Novidade novidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String caminhoImagemSaberMais;
        Novidade novidadeOriginal = (Novidade)((NovidadeRN)this.rn).buscarPorId(novidade.getId());
        String caminhoImagemPrincipal = novidadeOriginal.getUrlImagemPrincipal();
        if (!(StringUtil.stringNullOrEmpty((String)caminhoImagemPrincipal) || !StringUtil.stringNullOrEmpty((String)novidade.getUrlImagemPrincipal()) && novidade.getUrlImagemPrincipal().equals(caminhoImagemPrincipal))) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.NOVIDADE, caminhoImagemPrincipal);
        }
        if (!(StringUtil.stringNullOrEmpty((String)(caminhoImagemSaberMais = novidadeOriginal.getUrlImagemSaberMais())) || !StringUtil.stringNullOrEmpty((String)novidade.getUrlImagemSaberMais()) && novidade.getUrlImagemSaberMais().equals(caminhoImagemSaberMais))) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.NOVIDADE, caminhoImagemSaberMais);
        }
    }
}

