/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ordemservico;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.impressao.FormaUtilizacaoModeloImpressao;
import br.intelidata.commons.core.impressao.TipoModelo;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConfiguracaoOrdemServico;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.Objeto;
import br.intelidata.commons.domain.pojo.OrdemServico;
import br.intelidata.commons.domain.pojo.OrdemServicoImagem;
import br.intelidata.commons.domain.pojo.OrdemServicoItem;
import br.intelidata.commons.domain.pojo.OrdemServicoItemDataHora;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.EnumSituacaoOrcamento;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDataOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.StatusOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.TipoArquivoOS;
import br.intelidata.commons.domain.pojo.enuns.TipoAvisoFinalizacaoOS;
import br.intelidata.commons.domain.pojo.enuns.TipoConfiguracaoOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.TipoDescontoItem;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoGeracaoFaturamentoOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoObjetoConfOrdemServico;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoValorUnidadeMedida;
import br.intelidata.commons.domain.pojo.enuns.estoque.TipoConfiguracaoEstoqueNegativo;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.generico.VariavelTextoGenerico;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AtacarejoWeb;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCampoExtraCommonRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.regranegocio.OrdemServicoImagemCommonRN;
import br.intelidata.commons.domain.regranegocio.OrdemServicoItemCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.regranegocio.ValorCampoExtraCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.ordemservico.impressao.ImpressaoOrdemServico;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ConfiguracaoOrdemServicoRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ObjetoRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoItemRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVenda;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ObjetoAuxiliar;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TratarPesquisaRapida;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitController;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.TrataModeloIReportWebImpl;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.AuxiliarOrderServico;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.FiltroGridTecnicoLogado;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.MesclagemOrdemServico;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoItemAtacarejoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoItemWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoItemWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoOrcamentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoPesquisaNumeroSerie;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.OrdemServicoRecalculoPrecoItemWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.ordemservico.RetiradaWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ConfiguracaoCampoExtra(TABELA="conf_os_filial", QUANTIDADE=QuantidadeCampoExtra.ORDEM_SERVICO, PROGRAMA=602)
@RestController
@Component(value="ordem-servico")
@RequestMapping(value={"/api/ordem-servico"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Ordem de servi\u00e7o", ICONE="icon-ordem-de-servico", ROTA="/ordens-servicos/ordem-servico", PROGRAMA=602)
public class OrdemServicoCrudController
extends ItemKitController<OrdemServico, OrdemServicoItemWeb, OrdemServicoRN> {
    private final FuncionalidadeService funcionalidadeService;
    private final AtacarejoService atacarejoService;
    private final TaskManager taskManager;
    private final TrataModeloIReportWebImpl trataModeloIReportWeb;

    public OrdemServicoCrudController(FuncionalidadeService funcionalidadeService, TaskManager taskManager, AtacarejoService atacarejoService, TrataModeloIReportWebImpl trataModeloIReportWeb) {
        super((AbstractRegraNegocio)OrdemServicoRN.getInstance(), OrdemServico::new, true, true);
        this.funcionalidadeService = funcionalidadeService;
        this.atacarejoService = atacarejoService;
        this.taskManager = taskManager;
        this.trataModeloIReportWeb = trataModeloIReportWeb;
        this.setItemSupplier(OrdemServicoItemWeb::new);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody OrdemServico ordemServico, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (OrdemServicoRN.getInstance().descontoSubtotalItensDiferenteDoCabecalho(ordemServico)) {
            throw new UnicoMensagemUsuarioException("WWW752", "Inconsist\u00eancia nos descontos: a soma dos descontos aplicados nos itens n\u00e3o corresponde ao valor de desconto informado no subtotal da OS. Informe novamente os descontos na aba 'Subtotal'.");
        }
        return super.create((AbstractPojo)ordemServico, parentId);
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart MultipartFile[] files, @RequestPart(value="entity") OrdemServico entity) throws UnicoMensagemUsuarioException {
        return super.createWithFile(files, (AbstractPojo)entity);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody OrdemServico ordemServico, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (OrdemServicoRN.getInstance().descontoSubtotalItensDiferenteDoCabecalho(ordemServico)) {
            throw new UnicoMensagemUsuarioException("WWW751", "Inconsist\u00eancia nos descontos: a soma dos descontos aplicados nos itens n\u00e3o corresponde ao valor de desconto informado no subtotal da OS. Informe novamente os descontos na aba 'Subtotal'.");
        }
        return super.update((AbstractPojo)ordemServico, parentId);
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") OrdemServico entity) throws UnicoMensagemUsuarioException {
        return super.updateWithFiles(files, (AbstractPojo)entity);
    }

    @RequestMapping(value={"/iniciar-os"})
    @DBTransaction
    public void iniciarOrdemServico(@RequestParam Long idOrdemServico, @RequestParam Long idTecnico, @RequestParam boolean reiniciar) throws UnicoMensagemUsuarioException {
        OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(idOrdemServico);
        Sessao sessao = SessaoUtil.getSessao();
        StatusOrdemServico status = (StatusOrdemServico)EnumUtils.getPorId(StatusOrdemServico.class, (Object)ordemServico.getStatus());
        if (status != null && !status.isPermiteIniciar()) {
            throw new UnicoMensagemUsuarioException("WWW713", "N\u00e3o \u00e9 permitido iniciar a ordem de servi\u00e7o selecionada");
        }
        try {
            ConfiguracaoOrdemServico configuracaoOrdemServico = ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(sessao);
            if (!configuracaoOrdemServico.isValidarLimiteCredito() && LimiteCreditoRN.getInstance().isVerificarLimiteCredito(sessao, ordemServico)) {
                LimiteCreditoRN.getInstance().validarLimiteCredito(sessao, ordemServico);
            }
            if (reiniciar) {
                OrdemServicoRN.getInstance().reIniciarOrdemServico(sessao, idOrdemServico, idTecnico);
            } else {
                OrdemServicoRN.getInstance().iniciarOrdemServico(sessao, idOrdemServico, idTecnico);
            }
        }
        catch (UnicoPerguntaUsuarioException e) {
            throw new UnicoMensagemUsuarioException("ORS181", "Inicializa\u00e7\u00e3o da ordem de servi\u00e7o " + OrdemServicoRN.getInstance().getCodigoDavFormatado(ordemServico.getCodigo()) + " n\u00e3o permitida!");
        }
    }

    @RequestMapping(value={"/finalizar-os"})
    @DBTransaction
    public String finalizarOrdemServico(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(id);
        TipoAvisoFinalizacaoOS tipoAvisoFinalizacaoOS = OrdemServicoRN.getInstance().buscarTipoEnvioAviso(ordemServico);
        boolean enviaAviso = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 88) && !tipoAvisoFinalizacaoOS.equals((Object)TipoAvisoFinalizacaoOS.NENHUM);
        String msgRetorno = "";
        if (enviaAviso && !tipoAvisoFinalizacaoOS.equals((Object)TipoAvisoFinalizacaoOS.NENHUM)) {
            if (tipoAvisoFinalizacaoOS.equals((Object)TipoAvisoFinalizacaoOS.EMAIL)) {
                this.enviarEmailAviso(ordemServico);
            } else if (tipoAvisoFinalizacaoOS.equals((Object)TipoAvisoFinalizacaoOS.SMS)) {
                // empty if block
            }
            msgRetorno = tipoAvisoFinalizacaoOS.getDescricao() + " agendado para envio com sucesso.";
        }
        OrdemServicoRN.getInstance().finalizarOrdemServico(SessaoUtil.getSessao(), id);
        return msgRetorno;
    }

    @RequestMapping(value={"/reabrir-os"})
    @DBTransaction
    public void reabrirOrdemServico(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(id);
        StatusOrdemServico status = (StatusOrdemServico)EnumUtils.getPorId(StatusOrdemServico.class, (Object)ordemServico.getStatus());
        if (!(status == null || status.isPermiteReabrir() && sessao.getUsuario().getPreferenciaUsuario().isPermiteReabrirOS())) {
            throw new UnicoMensagemUsuarioException("WORS39", "N\u00e3o \u00e9 permitido reabrir a ordem de servi\u00e7o selecionada");
        }
        OrdemServicoRN.getInstance().reabrirOrdemServico(sessao, id);
    }

    @RequestMapping(value={"/carregar-modelo-email-os"})
    @DBAutoCommit
    public List<ModeloImpressaoCabecalho> carregarModelos() {
        List modelos = ModeloImpressaoCabecalhoRN.getInstance().buscarListaPorTipoModelo(SessaoUtil.getSessao(), TipoModelo.ORDEMSERVICO, new FormaUtilizacaoModeloImpressao[]{FormaUtilizacaoModeloImpressao.EMAIL, FormaUtilizacaoModeloImpressao.IMPRESSAO_EMAIL});
        modelos.addAll(ModeloImpressaoCabecalhoRN.getInstance().buscarListaPorTipoModelo(SessaoUtil.getSessao(), TipoModelo.LAUDO_TECNICO, new FormaUtilizacaoModeloImpressao[]{FormaUtilizacaoModeloImpressao.EMAIL, FormaUtilizacaoModeloImpressao.IMPRESSAO_EMAIL}));
        return modelos;
    }

    @RequestMapping(value={"/estornar-faturamento-os"})
    @DBTransaction
    public void estornarFaturamento(@RequestParam Long idOs) throws UnicoMensagemUsuarioException {
        OrdemServicoRN.getInstance().estornarFaturamento(SessaoUtil.getSessao(), idOs);
    }

    @RequestMapping(value={"calcular-preco-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public OrdemServicoRecalculoPrecoItemWrapper calcularItensPorCondicaoPagamento(@RequestBody OrdemServicoItemWrapper wrapper) throws UnicoMensagemUsuarioException {
        for (OrdemServicoItemWeb item : wrapper.getItens()) {
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), item.getIdProduto());
            ProdutoPreco produtoPreco = new ProdutoItemRN().atualizarPreco(SessaoUtil.getSessao(), wrapper.getItens(), produto, (ProdutoItem)item, TipoValorPreco.PRECO, wrapper.getIdCondicaoPgmto(), wrapper.getPauta(), true, true, false, false, (AtacarejoWeb)this.atacarejoService, wrapper.getIdCliente());
            boolean possuiPromocaoPautaDesconto = false;
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                FormacaoPrecoProduto precoProduto = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(item.getIdproduto(), SessaoUtil.getSessao().getIdFilial());
                if (precoProduto != null) {
                    if (precoProduto.getPreco().compareTo(item.getPreco()) != 0) {
                        possuiPromocaoPautaDesconto = true;
                    }
                    if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                        item.setPrecoMinimoVenda(precoProduto.getPrecoMinimoVenda());
                    }
                } else {
                    if (produto.getPreco().compareTo(item.getPreco()) != 0) {
                        possuiPromocaoPautaDesconto = true;
                    }
                    if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                        item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
                    }
                }
            } else {
                if (produto.getPreco().compareTo(item.getPreco()) != 0) {
                    possuiPromocaoPautaDesconto = true;
                }
                if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                    item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
                }
            }
            if (!NumberUtil.longNullOuZero((Long)item.getIdEntidadeDesconto())) {
                possuiPromocaoPautaDesconto = true;
            }
            if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) > 0 && item.getPreco().compareTo(item.getPrecoMinimoVenda()) < 0 && item.getIdPromocao() == null && !possuiPromocaoPautaDesconto) {
                item.setIdSupervisorVenda(null);
                item.setPrecoComAcrecimo(produtoPreco.getPrecoMinimoVenda());
                item.setPreco(produtoPreco.getPrecoMinimoVenda());
            } else {
                item.setPrecoComAcrecimo(item.getPrecoUnitario());
            }
            item.setPrecoMinimoVenda(BigDecimal.ZERO);
            item.setIdSupervisorVenda(null);
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualDesconto())) {
                BigDecimal bruto = item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, 6);
                if (item.getTipoValorDesconto().equals((Object)TipoDescontoItem.PERCENTUAL)) {
                    item.setDesconto(NumberUtil.valorDesconto((BigDecimal)bruto, (BigDecimal)item.getPercentualDesconto(), (int)2));
                } else if (item.getTipoValorDesconto().equals((Object)TipoDescontoItem.VALOR)) {
                    item.setPercentualDesconto(NumberUtil.percentual((BigDecimal)item.getDesconto(), (BigDecimal)bruto));
                }
            }
            this.calculaTotalItem(item);
            if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
            GeradorKitVenda geradorKitVendaDav = new GeradorKitVenda();
            geradorKitVendaDav.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item, item.getFilhosKit(), wrapper.getIdCondicaoPgmto());
        }
        return new OrdemServicoRecalculoPrecoItemWrapper(wrapper.getItens());
    }

    @RequestMapping(value={"/buscar-texto-generico-os"})
    @DBAutoCommit
    public String escreverTextoMensagem(@RequestParam Long idTextoGenerico, @RequestParam Long idOs) throws UnicoMensagemUsuarioException {
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(idTextoGenerico);
        if (textoGenerico == null) {
            throw new UnicoMensagemUsuarioException("ORS171", "Texto gen\u00e9rico n\u00e3o encontrado");
        }
        String mensagem = textoGenerico.getTexto();
        if (mensagem == null) {
            throw new UnicoMensagemUsuarioException("ORS172", "Mensagem n\u00e3o configurada");
        }
        OrdemServico os = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(idOs);
        Filial filial = SessaoUtil.getSessao().getFilial();
        mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL.getId(), filial.getRazaoSocialCompleta());
        mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_EMPRESA.getId(), filial.getCnpj());
        mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
        if (os == null) {
            throw new UnicoMensagemUsuarioException("ORS173", "Ordem de servi\u00e7o n\u00e3o foi encontrada no servidor");
        }
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(os.getIdCliente());
        Entidade atendente = (Entidade)EntidadeRN.getInstance().buscarPorId(os.getIdAtendente());
        mensagem = mensagem.replace(VariavelTextoGenerico.NOME_CLIENTE_ORDEM_SERVICO.getId(), cliente != null ? cliente.getNome() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.ATENDENTE.getId(), atendente != null ? atendente.getNome() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.CODIGO_OS.getId(), os.getCodigo() != null ? os.getCodigo().toString() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.ABERTURA.getId(), os.getDataOs() != null ? Util.formataDataHora((Temporal)os.getDataOs(), (String)"dd/MM/yyyy") : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.PROBLEMA_DESCRITO.getId(), os.getProblemaDescrito() != null ? os.getProblemaDescrito() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.PREVISAO_CONCLUSAO.getId(), os.getPrevisaoConclusao() != null ? Util.formataDataHora((Temporal)os.getPrevisaoConclusao(), (String)"dd/MM/yyyy") : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.DESCRICAO_ITEM.getId(), os.getDescricaoItem() != null ? os.getDescricaoItem() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.VALOR.getId(), os.getValor() != null ? os.getValor().toString() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA1_ORDEM_SERVICO.getId(), os.getExtra1() != null ? os.getExtra1() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA2_ORDEM_SERVICO.getId(), os.getExtra2() != null ? os.getExtra2() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA3_ORDEM_SERVICO.getId(), os.getExtra3() != null ? os.getExtra3() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA4_ORDEM_SERVICO.getId(), os.getExtra4() != null ? os.getExtra4() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA5_ORDEM_SERVICO.getId(), os.getExtra5() != null ? os.getExtra5() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA6_ORDEM_SERVICO.getId(), os.getExtra6() != null ? os.getExtra6() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA7_ORDEM_SERVICO.getId(), os.getExtra7() != null ? os.getExtra7() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA8_ORDEM_SERVICO.getId(), os.getExtra8() != null ? os.getExtra8() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA9_ORDEM_SERVICO.getId(), os.getExtra9() != null ? os.getExtra9() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA10_ORDEM_SERVICO.getId(), os.getExtra10() != null ? os.getExtra10() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA11_ORDEM_SERVICO.getId(), os.getExtra11() != null ? os.getExtra11() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA12_ORDEM_SERVICO.getId(), os.getExtra12() != null ? os.getExtra12() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA13_ORDEM_SERVICO.getId(), os.getExtra13() != null ? os.getExtra13() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA14_ORDEM_SERVICO.getId(), os.getExtra14() != null ? os.getExtra14() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA15_ORDEM_SERVICO.getId(), os.getExtra15() != null ? os.getExtra15() : "");
        mensagem = mensagem.replace(VariavelTextoGenerico.EXTRA16_ORDEM_SERVICO.getId(), os.getExtra16() != null ? os.getExtra16() : "");
        return mensagem;
    }

    public void loadFile(MultipartFile[] files, OrdemServico ordemServico) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            Map<Object, Object> mapImagens = !ListMapUtil.listNullOrEmpty((List)ordemServico.getImagens()) ? ordemServico.getImagens().stream().collect(Collectors.groupingBy(OrdemServicoImagem::getCaminho)) : new HashMap();
            if (!ListMapUtil.listNullOrEmpty((List)ordemServico.getArquivos())) {
                mapImagens.putAll(ordemServico.getArquivos().stream().collect(Collectors.groupingBy(OrdemServicoImagem::getCaminho)));
            }
            for (MultipartFile file : files) {
                Object[] split;
                String nomeArquivo = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)nomeArquivo) || ListMapUtil.arrayNullOrEmpty((Object[])(split = nomeArquivo.split("\\|")))) continue;
                try {
                    List arquivo;
                    String caminho;
                    Object fieldName = split[0];
                    if (((String)fieldName).equalsIgnoreCase("img")) {
                        List imagemOs = (List)mapImagens.get(split[1]);
                        if (ListMapUtil.listNullOrEmpty((List)imagemOs)) continue;
                        caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, file);
                        byte[] imagem = file.getBytes();
                        imagemOs.forEach(i -> {
                            i.setCaminhoOriginal(caminho);
                            if (this.saveFile.isTabela()) {
                                i.setArquivo(imagem);
                            }
                        });
                        continue;
                    }
                    if (!((String)fieldName).equalsIgnoreCase("file") || ListMapUtil.listNullOrEmpty((List)(arquivo = (List)mapImagens.get(split[1])))) continue;
                    caminho = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, file, false);
                    byte[] documento = file.getBytes();
                    arquivo.forEach(i -> {
                        i.setCaminhoOriginal(caminho);
                        if (this.saveFile.isTabela()) {
                            i.setArquivo(documento);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UnicoMensagemUsuarioException("WWW170", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
                }
            }
        }
    }

    @DBAutoCommit
    public OrdemServico read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        OrdemServico entity = ((OrdemServicoRN)this.rn).buscarPorIdComFilhos(id);
        if (entity == null) {
            throw new UnicoException("WWW658", id + " n\u00e3o encontrado(a)");
        }
        super.read((AbstractPojo)entity, modo, parentId);
        return entity;
    }

    @RequestMapping(value={"buscar-preco-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<OrdemServicoItemWeb> getPrecoProduto(@RequestBody OrdemServicoItemWrapper wrapper) {
        Promocao promocao;
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getItem().getIdProduto());
        Long pautaAtacarejo = null;
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            pautaAtacarejo = this.atacarejoService.buscaPautaAtacarejo(produto, wrapper.getQuantidade(), sessao);
        }
        ProdutoPreco produtoPreco = pautaAtacarejo != null && pautaAtacarejo >= 0L ? this.atacarejoService.getPrecoAtacarejo(pautaAtacarejo, produto, wrapper.getItem().getIdEmbalagem(), sessao) : ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(sessao.getFilial(), wrapper.getItem().getIdproduto(), wrapper.getItem().getPautaPreco(), VariacaoRN.getInstance().stringToMap(wrapper.getItem().getVariacoes()), wrapper.getItem().getIdEmbalagem()));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
            wrapper.getItem().setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
            wrapper.getItem().setPrecoProdutoOriginal((BigDecimal)map.get("precoProdutoOriginal"));
        } else {
            wrapper.getItem().setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            wrapper.getItem().setPrecoProdutoOriginal(produto.getPreco());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produtoPreco.getPrecoPromocao()) && NumberUtil.longNullOuZero((Long)wrapper.getItem().getIdEmbalagem())) {
            wrapper.getItem().setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            wrapper.getItem().setPreco(produtoPreco.getPrecoPromocao());
            wrapper.getItem().setIdPromocao(produtoPreco.getIdPromocao());
        } else {
            wrapper.getItem().setDescontoPromocao(BigDecimal.ZERO);
            wrapper.getItem().setPreco(produtoPreco.getPreco());
            wrapper.getItem().setIdPromocao(null);
        }
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        OrdemServicoItemWeb osItem = new OrdemServicoItemWeb();
        BeanUtil.copiarValores((Object)wrapper.getItem(), (Object)osItem, (boolean)false, (boolean)true, null);
        produtoItemWeb.setItem((ItemWeb)osItem);
        if (!NumberUtil.longNullOuZero((Long)((OrdemServicoItemWeb)produtoItemWeb.getItem()).getIdPromocao()) && (promocao = PromocaoRN.getInstance().buscarPorId(((OrdemServicoItemWeb)produtoItemWeb.getItem()).getIdPromocao())) != null) {
            produtoItemWeb.setPromocao(promocao);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/saldo-estoque"})
    @DBAutoCommit
    public BigDecimal getSaldoEstoque(@RequestParam(required=false) Long idFilial, @RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        return ProdutoRN.getInstance().getSaldoEstoque(SessaoUtil.getSessao(), idFilial, idProduto);
    }

    public ProdutoItemWeb<OrdemServicoItemWeb> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Long idCliente;
        Entidade cliente = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        if (parametros.containsKey((Object)"idCliente") && !NumberUtil.longNullOuZero((Long)(idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente")))) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        Long idCondicaoPgmto = null;
        if (parametros.containsKey((Object)"idCondicaoPgmto")) {
            idCondicaoPgmto = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCondicaoPgmto");
        }
        Long pauta = 0L;
        if (parametros.containsKey((Object)"pauta")) {
            pauta = StringUtil.convertFirstValueMapToLong(parametros, (String)"pauta");
        }
        List novosTipos = StringUtil.getAllValuesMap(parametros, (String)"tiposEmbalagem");
        if (!ListMapUtil.listNullOrEmpty(tipos)) {
            novosTipos.forEach(tipo -> {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, tipo);
                if (!tipos.contains(tipoEmbalagem)) {
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        OrdemServicoItemWeb ordemServico = new OrdemServicoItemWeb();
        ordemServico.setQuantidade(BigDecimal.ONE);
        produtoItem.setItem((ItemWeb)ordemServico);
        produtoItem.setProduto(produto);
        Sessao sessao = SessaoUtil.getSessao();
        new ProdutoItemRN().carregaItem(sessao, produtoItem, cliente, null, idCondicaoPgmto, pauta, false, true, true, TipoValorPreco.PRECO, false, false, false, null, tipos, false, (AtacarejoWeb)this.atacarejoService, 6, true);
        Produto prod = (Produto)ProdutoRN.getInstance().buscarPorId(produto.getId());
        ((OrdemServicoItemWeb)produtoItem.getItem()).setIdCfop(NaturezaOperacaoRN.getInstance().buscarIdNaturezaOperacaoOrdemServico(sessao, prod, cliente, false));
        ((OrdemServicoItemWeb)produtoItem.getItem()).setDescricaoUnidadeMedida(((OrdemServicoItemWeb)produtoItem.getItem()).getUnidadeMedida());
        ((OrdemServicoItemWeb)produtoItem.getItem()).setPautaPreco(pauta);
        ((OrdemServicoItemWeb)produtoItem.getItem()).setDataHora(DataHoraFactory.getDataHora());
        return produtoItem;
    }

    @RequestMapping(value={"/validar-retirada"})
    @DBAutoCommit
    public RetiradaWrapper validarRetirada(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        List listaOrdemServico = OrdemServicoRN.getInstance().validaOrdensSelecionadasParaRetirada(ids);
        RetiradaWrapper retirada = new RetiradaWrapper();
        if (listaOrdemServico.size() > 1) {
            retirada.setData(DataHoraFactory.getDataHora());
            retirada.setIdUsuarioEntrega(SessaoUtil.getSessao().getIdUsuario());
            retirada.setUsuarioRetirada(((OrdemServico)listaOrdemServico.get(0)).getNomeCliente());
        } else {
            OrdemServico ordemServico = (OrdemServico)listaOrdemServico.get(0);
            if (ordemServico.getDataHoraRetirada() != null) {
                retirada.setData(ordemServico.getDataHoraRetirada());
                retirada.setIdUsuarioEntrega(ordemServico.getIdUsuarioEntrega());
                retirada.setUsuarioRetirada(ordemServico.getNomeResponsavelRetirada());
            } else {
                retirada.setData(DataHoraFactory.getDataHora());
                retirada.setIdUsuarioEntrega(SessaoUtil.getSessao().getIdUsuario());
                retirada.setUsuarioRetirada(((OrdemServico)listaOrdemServico.get(0)).getNomeCliente());
            }
        }
        return retirada;
    }

    @RequestMapping(value={"/gravar-retirada"}, method={RequestMethod.POST})
    @DBTransaction
    public String gravarRetirada(@RequestBody RetiradaWrapper retirada) throws UnicoMensagemUsuarioException {
        List listaOrdemServico = OrdemServicoRN.getInstance().buscarListaPorIds(retirada.getIds());
        OrdemServicoRN.getInstance().retirarOrdemServico(SessaoUtil.getSessao(), listaOrdemServico, retirada.getData(), retirada.getIdUsuarioEntrega(), retirada.getUsuarioRetirada());
        return "Retirada gravada com sucesso!";
    }

    @RequestMapping(value={"/itens-mesclagem"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<OrdemServicoItem> buscarDadosMesclagem(@RequestBody List<Long> ids) {
        ArrayList<OrdemServicoItem> itens = new ArrayList<OrdemServicoItem>();
        for (Long id : ids) {
            itens.addAll(OrdemServicoItemRN.getInstance().buscarListaPorIdOrdemServico(id));
        }
        return itens;
    }

    @RequestMapping(value={"/mesclar-itens"}, method={RequestMethod.POST})
    @DBTransaction
    public String mesclarItens(@RequestBody MesclagemOrdemServico dados) throws UnicoMensagemUsuarioException {
        Long codigo = OrdemServicoRN.getInstance().mesclar(SessaoUtil.getSessao(), dados.getIds(), dados.getItens());
        return "Ordem de servi\u00e7o n\u00famero " + OrdemServicoRN.getInstance().getCodigoDavFormatado(codigo) + " gravada com sucesso";
    }

    @RequestMapping(value={"/verifica-iniciar-os"})
    @DBAutoCommit
    public boolean iniciarOs(@RequestParam Long id) {
        OrdemServico os = (OrdemServico)((OrdemServicoRN)this.rn).buscarPorId(id);
        if (os != null) {
            return StatusOrdemServico.ABERTA.getId().equals(os.getStatus());
        }
        return false;
    }

    @RequestMapping(value={"/carregar-objeto"})
    @DBAutoCommit
    public String carregarDadosObjeto(@RequestParam Long idObjeto) throws UnicoMensagemUsuarioException {
        Objeto objeto = (Objeto)ObjetoRN.getInstance().buscarPorId(idObjeto);
        AuxiliarOrderServico aux = (AuxiliarOrderServico)this.getObjetoAuxiliar();
        if (objeto != null) {
            Extras extras;
            StringBuilder detalhes = new StringBuilder();
            if (!Util.stringNullOrEmpty((String)objeto.getDescricao())) {
                if (TipoConfiguracaoOrdemServico.VEICULO.equals((Object)aux.getConfiguracao().getTipo())) {
                    detalhes.append("Ve\u00edculo: ").append(objeto.getDescricao()).append(" ");
                } else {
                    detalhes.append("Descri\u00e7\u00e3o: ").append(objeto.getDescricao()).append(" ");
                }
            }
            if (TipoConfiguracaoOrdemServico.VEICULO.equals((Object)aux.getConfiguracao().getTipo())) {
                if (!Util.stringNullOrEmpty((String)objeto.getMarca())) {
                    detalhes.append("Marca: ").append(objeto.getMarca()).append(" ");
                }
                if (!Util.stringNullOrEmpty((String)objeto.getModelo())) {
                    detalhes.append("Modelo: ").append(objeto.getModelo()).append(" ");
                }
                if (objeto.getAnoFabricacao() > 0) {
                    detalhes.append("Ano fabrica\u00e7\u00e3o: ").append(objeto.getAnoFabricacao()).append(" ");
                }
                if (!Util.stringNullOrEmpty((String)objeto.getPlaca())) {
                    detalhes.append("Placa: ").append(objeto.getPlaca()).append(" ");
                }
                if (!Util.stringNullOrEmpty((String)objeto.getRenavam())) {
                    detalhes.append("RENAVAM: ").append(objeto.getRenavam()).append(" ");
                }
            } else if (!Util.stringNullOrEmpty((String)objeto.getNumeroFabricacao())) {
                detalhes.append("N\u00famero de fabrica\u00e7\u00e3o: ").append(objeto.getNumeroFabricacao()).append(" ");
            }
            if ((extras = ExtrasRN.getInstance().buscarPorNomeTabela("objeto")) != null) {
                for (int i = 1; i <= 10; ++i) {
                    String valorCampo;
                    String textoCampo = (String)BeanUtil.get((Object)extras, (String)("extra" + i), (Object[])new Object[0]);
                    if (Util.stringNullOrEmpty((String)textoCampo) || textoCampo.contains("Campo adicional") || Util.stringNullOrEmpty((String)(valorCampo = (String)BeanUtil.get((Object)objeto, (String)("extra" + i), (Object[])new Object[0])))) continue;
                    detalhes.append(textoCampo).append(" ").append(valorCampo).append(" ");
                }
            }
            if (detalhes.length() > 0) {
                return detalhes.toString();
            }
        }
        return null;
    }

    @RequestMapping(value={"/atualizar-cfop"}, method={RequestMethod.POST})
    @DBTransaction
    public List<OrdemServicoItem> atualizarCfop(@RequestBody List<OrdemServicoItem> itens, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
        for (OrdemServicoItem item : itens) {
            String cfop = "";
            Long idCfop = NaturezaOperacaoRN.getInstance().buscarIdNaturezaOperacaoOrdemServico(SessaoUtil.getSessao(), (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdproduto()), entidade, item.getBrinde() == 1);
            if (!Util.longNullOuZero((Long)idCfop)) {
                NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(idCfop);
                cfop = naturezaOperacao != null ? naturezaOperacao.getCodigo() : "";
            }
            item.setCfop(cfop);
            item.setIdCfop(idCfop);
        }
        return itens;
    }

    @RequestMapping(value={"/atualizar-cfop-brinde"}, method={RequestMethod.POST})
    @DBAutoCommit
    public OrdemServicoItem carregaCfopBrinde(@RequestBody OrdemServicoItem item, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdproduto());
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
        item.setIdCfop(NaturezaOperacaoRN.getInstance().buscarIdNaturezaOperacaoOrdemServico(SessaoUtil.getSessao(), produto, entidade, item.getBrinde() == 1));
        return item;
    }

    @DBAutoCommit
    public List<OrdemServicoItem> getItens(Long id) {
        List itens = OrdemServicoItemRN.getInstance().buscarListaPorIdOrdemServico(id);
        OrdemServicoItemCommonRN.getInstance().buscarDadosProdutoServico(itens);
        itens.forEach(it -> {
            Unidademedida unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(it.getIdUnidadeMedida());
            if (unidadeMedida != null && !TipoValorUnidadeMedida.HORA.equals((Object)unidadeMedida.getTipoValor())) {
                it.setQuantidadeHora("");
            }
        });
        return this.agruparItensKit(itens);
    }

    protected String getCacheId() {
        return "ordem-servico".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<OrdemServicoRN> getGridBuilder() {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("currentTimeMillis", "currentTimeMillis", 0, false));
        colunas.add(new ColunaSQL("idAtendente", "idAtendente", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 80, true));
        colunas.add(new ColunaSQL("nome", "atendente", "Atendente", 150, true, new String[]{"fk_ordemservico_atendente"}));
        colunas.add(new ColunaSQL("id", "idCliente", "ID Cliente", 0, false, new String[]{"fk_ordemservico_entidade"}));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 150, true, new String[]{"fk_ordemservico_entidade"}));
        colunas.add(new ColunaSQL("cnpjcpf", "cnpjCpfCliente", "CNPJ/CPF", 120, true, new String[]{"fk_ordemservico_entidade"}));
        colunas.add(new ColunaSQL("descricaoitem", "Descri\u00e7\u00e3o do objeto", 170, true));
        colunas.add(new ColunaSQL("numerofabricacao", "Nro de fabrica\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("dataos", "Abertura", 100, true));
        colunas.add(new ColunaSQL("previsaoconclusao", "Previs\u00e3o conclus\u00e3o", 140, true));
        if (sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS()) {
            ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 100, sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS());
            colunaValor.setTotalizar(true);
            colunas.add(colunaValor);
        }
        if (sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS()) {
            ColunaSQL colunaSaldo = new ColunaSQL("valor", "saldo", "Saldo", 100, sessao.getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS(), new String[0]);
            colunaSaldo.setTotalizar(true);
            colunas.add(colunaSaldo);
        }
        colunas.add(new ColunaSQL("status", "Status", 80, true));
        ColunaSQL colunaStatus = new ColunaSQL("status", "codigoStatus", "Status", 0, false, new String[0]);
        colunaStatus.setNaoAlterarValorEnum(true);
        colunas.add(colunaStatus);
        colunas.add(new ColunaSQL("agendamento", "Agendamento", 100, true));
        colunas.add(new ColunaSQL("nome", "tecnicoAtual", "T\u00e9cnico atual", 130, true, new String[]{"fk_ordemservico_ultimo_tecnico"}));
        colunas.add(new ColunaSQL("existeevento", "Existe evento", 110, true));
        ColunaSQL colunaFaturouParaCupom = new ColunaSQL("faturouparacupom", "faturouparacupom_aux", "Faturou para cupon", 0, false, new String[0]);
        colunaFaturouParaCupom.setNaoAlterarValorEnum(true);
        colunas.add(colunaFaturouParaCupom);
        ColunaSQL colunaFaturouParaNota = new ColunaSQL("faturouparanota", "faturouparanota_aux", "Faturou para nota", 0, false, new String[0]);
        colunaFaturouParaNota.setNaoAlterarValorEnum(true);
        colunas.add(colunaFaturouParaNota);
        colunas.add(new ColunaSQL("valorprodutos", "valorprodutos_aux", "Valor do produtos", 0, false, new String[0]));
        colunas.add(new ColunaSQL("valorservicos", "valorservicos_aux", "Valor do servi\u00e7os", 0, false, new String[0]));
        colunas.add(new ColunaSQL("percentualdescontosubtotal", "percentualdescontosubtotal_aux", "Percentual de desconto do subtotal", 0, false, new String[0]));
        colunas.add(new ColunaSQL("inicioservico", "Inicio do servi\u00e7o", 140, true));
        colunas.add(new ColunaSQL("fimservico", "Fim do servi\u00e7o", 140, true));
        colunas.add(new ColunaSQL("validadeorcamento", "Validade do or\u00e7amento", 140, true));
        colunas.add(new ColunaSQL("aprovacaoorcamento", "Aprova\u00e7\u00e3o do or\u00e7amento", 140, true));
        colunas.add(new ColunaSQL("validadegarantia", "Validade da garantia", 140, true));
        for (StatusDataOrdemServico statusData : StatusDataOrdemServico.values()) {
            for (String campo : statusData.getCampoTabela()) {
                colunas.add(new ColunaSQL(campo, statusData.getDescricao(), 0, false));
            }
        }
        GridBuilder grid = new GridBuilder(OrdemServicoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, sessao.getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("dataos", "dataosordem"));
        grid.setOrdemDefault(new Ordem("dataosordem"));
        grid.setTratarPesquisaRapida((TratarPesquisaRapida)new OrdemServicoPesquisaNumeroSerie());
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        ConfiguracaoOrdemServico configuracaoOrdemServico = ((AuxiliarOrderServico)this.getObjetoAuxiliar()).getConfiguracao();
        boolean cupomNfe = configuracaoOrdemServico.getTipoGeracaoFaturamentoOS().equals((Object)TipoGeracaoFaturamentoOrdemServico.CUPOM_NFSE);
        int idxSaldo = this.getIndexColuna("saldo", colunas);
        dados.forEach(linha -> {
            if (idxSaldo > -1) {
                BigDecimal valorServicos;
                Integer status = (Integer)linha[this.getIndexColuna("codigoStatus", colunas)];
                BigDecimal saldo = BigDecimal.ZERO;
                BigDecimal valorProdutos = (BigDecimal)linha[this.getIndexColuna("valorprodutos_aux", colunas)];
                if (valorProdutos == null) {
                    valorProdutos = BigDecimal.ZERO;
                }
                if ((valorServicos = (BigDecimal)linha[this.getIndexColuna("valorservicos_aux", colunas)]) == null) {
                    valorServicos = BigDecimal.ZERO;
                }
                if (StatusOrdemServico.FATURADA.getId().equals(status) || StatusOrdemServico.FATURADO_PARCIALMENTE.getId().equals(status) || StatusOrdemServico.FATURADA_POR_NF_DAVOS.getId().equals(status) || StatusOrdemServico.RETIRADA.getId().equals(status)) {
                    if (cupomNfe) {
                        boolean faturouParaNota = EnumSimNao.SIM.getId().equals(linha[this.getIndexColuna("faturouparanota_aux", colunas)]);
                        boolean faturouParaCupom = EnumSimNao.SIM.getId().equals(linha[this.getIndexColuna("faturouparacupom_aux", colunas)]);
                        if (!faturouParaNota && !faturouParaCupom) {
                            saldo = (BigDecimal)linha[idxSaldo];
                        } else {
                            BigDecimal percDescontoSubtotal;
                            if (!faturouParaNota) {
                                saldo = valorServicos;
                            }
                            if (!faturouParaCupom) {
                                saldo = saldo.add(valorProdutos);
                            }
                            if ((percDescontoSubtotal = (BigDecimal)linha[this.getIndexColuna("percentualdescontosubtotal_aux", colunas)]) != null) {
                                saldo = Util.valorComDesconto((BigDecimal)saldo, (BigDecimal)percDescontoSubtotal, (int)2);
                            }
                        }
                    }
                } else {
                    saldo = (BigDecimal)linha[idxSaldo];
                }
                linha[idxSaldo] = saldo.setScale(2, 6);
            }
        });
    }

    protected void afterLoadColunaSQL(List<ColunaSQL> colunas) throws UnicoMensagemUsuarioException {
        boolean permitirVisualizar = SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario().isPermiteVisualizarPrecoOS();
        for (ColunaSQL coluna : colunas) {
            if (coluna.getAlias().equalsIgnoreCase("valor") && !permitirVisualizar) {
                coluna.setVisivel(false);
            }
            if (!coluna.getAlias().equalsIgnoreCase("saldo") || permitirVisualizar) continue;
            coluna.setVisivel(false);
        }
    }

    protected void afterUpdate(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        OrdemServicoItemCommonRN.getInstance().excluirPorIdOrdemServico(sessao, ordemServico.getId());
        OrdemServicoItemCommonRN.getInstance().gravaItensPorIdOrdemServico(sessao, ordemServico.getItens(), ordemServico);
    }

    protected void afterSave(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CONFIGURADOR_CAMPOS_ADICIONAIS) && ordemServico.getValoresExtras() != null) {
            ValorCampoExtraCommonRN.getInstance().gravarLista(SessaoUtil.getSessao(), 602, ordemServico.getId(), ordemServico.getValoresExtras());
        }
    }

    protected void afterCreate(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String msg = "Ordem de servi\u00e7o " + ordemServico.getCodigo() + " gravada com sucesso.";
        this.notificationService.notifyUser(SessaoUtil.getSessao().getIdUsuario(), msg, TipoNotificacaoSimples.SUCCESS, NotificationType.ORDEM_SERVICO);
    }

    protected void beforeRead(OrdemServico ordemServico, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        for (OrdemServicoItem ordemServicoItem : ordemServico.getItens()) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(ordemServicoItem.getIdProduto());
            if (produto != null) {
                ordemServicoItem.setCodigoProduto(produto.getCodigo());
                ordemServicoItem.setNomeProduto(produto.getNome());
                ordemServicoItem.setTipoProduto(produto.getTipo());
                ordemServicoItem.setPreco(ordemServicoItem.getPreco().setScale((int)produto.getCasasDecimais(), 6));
                if (Util.bigDecimalNullOrZero((BigDecimal)ordemServicoItem.getPrecoInformado())) {
                    ordemServicoItem.setPrecoInformado(ordemServicoItem.getPreco().setScale((int)produto.getCasasDecimais(), 6));
                } else {
                    ordemServicoItem.setPrecoInformado(ordemServicoItem.getPrecoInformado().setScale((int)produto.getCasasDecimais(), 6));
                }
                ordemServicoItem.setNomeFabricante(EntidadeRN.getInstance().buscarValoresPorID(produto.getIdFabricante(), new String[]{"nome"}).getOrDefault("nome", ""));
            }
            ordemServicoItem.setNomeTecnico(EntidadeRN.getInstance().buscarValoresPorID(ordemServicoItem.getIdTecnico(), new String[]{"nome"}).getOrDefault("nome", ""));
            Unidademedida unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(ordemServicoItem.getIdUnidadeMedida());
            if (unidade != null) {
                ordemServicoItem.setUnidadeMedida(unidade.getCodigo());
                Integer decimais = unidade.getCasasdecimais();
                if (TipoValorUnidadeMedida.HORA.equals((Object)unidade.getTipoValor())) {
                    decimais = 6;
                } else {
                    ordemServicoItem.setQuantidadeHora("");
                }
                ordemServicoItem.setQuantidade(ordemServicoItem.getQuantidade().setScale((int)decimais, 6));
            }
            ordemServicoItem.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)ordemServicoItem, !NumberUtil.longNullOuZero((Long)ordemServicoItem.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(ordemServicoItem.getIdPromocao()) : null));
            ordemServicoItem.setTotal(ordemServicoItem.getTotal().setScale(2, 6));
        }
        ordemServico.setItens(this.agruparItensKit(ordemServico.getItens()));
        List imagens = OrdemServicoImagemCommonRN.getInstance().buscarListaPorIdOrdemServicoTipoArquivo(ordemServico.getId(), TipoArquivoOS.IMAGEM);
        imagens.forEach(osImagem -> osImagem.setCaminhoOriginal(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, TipoImagem.TamanhoOriginal, osImagem.getCaminhoOriginal())));
        ordemServico.setImagens(imagens);
        imagens = OrdemServicoImagemCommonRN.getInstance().buscarListaPorIdOrdemServicoTipoArquivo(ordemServico.getId(), TipoArquivoOS.ARQUIVO);
        imagens.forEach(osImagem -> osImagem.setCaminhoOriginal(this.saveFile.publishArquivo(osImagem.getCaminhoOriginal())));
        ordemServico.setArquivos(imagens);
        if (modo == 7) {
            ordemServico.setIdOsOrigem(ordemServico.getId());
            ordemServico.setId(null);
            ordemServico.setDataHoraRetirada(null);
            ordemServico.setIdUsuarioEntrega(null);
            ordemServico.setNomeResponsavelRetirada(null);
            ordemServico.setCodigo(null);
            ordemServico.setData(DataHoraFactory.getDataHora());
            ordemServico.setDataOs(DataHoraFactory.getData());
            ordemServico.setFaturouParaCupom(false);
            ordemServico.setFaturouParaNota(false);
            ordemServico.setEcfmarca("");
            ordemServico.setEcfmfadicional("");
            ordemServico.setEcfmodelo("");
            ordemServico.setEcfserie("");
            ordemServico.setEcftipo("");
            ordemServico.setIdOsMesclada(null);
            ordemServico.setFimServico(null);
            if (!Util.intNullOuZero((Integer)ordemServico.getCooGer())) {
                ordemServico.setCooGer(Integer.valueOf(0));
                OrdemServico original = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId(ordemServico.getIdOsOrigem());
                if (original != null && original.getStatus().compareTo(StatusOrdemServico.FINALIZADA.getId()) == 0) {
                    original.setStatus(StatusOrdemServico.DUPLICADO.getId());
                    OrdemServicoRN.getInstance().alterar(original, SessaoUtil.getSessao());
                }
            }
        }
    }

    protected void beforeSave(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoOrdemServico configuracaoOrdemServico;
        List itens;
        Sessao sessao = SessaoUtil.getSessao();
        ordemServico.setIdusuarioaprovacaoorcamento(sessao.getUsuario().getId());
        BigDecimal descontoSubTotal = ordemServico.getDescontoSubTotal();
        if (descontoSubTotal.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal totalItens = ordemServico.getValorProdutos().add(ordemServico.getValorServicos());
            BigDecimal totalLiquido = ordemServico.getValor();
            if (totalLiquido.compareTo(totalItens.subtract(descontoSubTotal)) != 0) {
                throw new UnicoMensagemUsuarioException("WORS110", "Os totais do documento n\u00e3o foram validados! Verifique.");
            }
        } else {
            BigDecimal descontoSubTotalServico;
            BigDecimal descontoSubTotalProduto = ordemServico.getDescSubtotalProduto();
            if (descontoSubTotalProduto.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal totalProdutos = ordemServico.getItens().stream().filter(os -> os.getTipoProduto().equals((Object)TipoRegistroProduto.PRODUTO)).map(OrdemServicoItem::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalLiquido = ordemServico.getItens().stream().filter(os -> os.getTipoProduto().equals((Object)TipoRegistroProduto.PRODUTO)).map(item -> item.getTotal().subtract(item.getDescontoSubtotal())).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalLiquido.compareTo(totalProdutos.subtract(descontoSubTotalProduto)) != 0) {
                    throw new UnicoMensagemUsuarioException("WORS123", "Os totais dos produtos n\u00e3o foram validados! Verifique.");
                }
            }
            if ((descontoSubTotalServico = ordemServico.getDescSubtotalServico()).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal totalServicos = ordemServico.getItens().stream().filter(os -> os.getTipoProduto().equals((Object)TipoRegistroProduto.SERVICO)).map(OrdemServicoItem::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalLiquido = ordemServico.getItens().stream().filter(os -> os.getTipoProduto().equals((Object)TipoRegistroProduto.SERVICO)).map(item -> item.getTotal().subtract(item.getDescontoSubtotal())).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalLiquido.compareTo(totalServicos.subtract(descontoSubTotalServico)) != 0) {
                    throw new UnicoMensagemUsuarioException("WORS124", "Os totais dos servi\u00e7os n\u00e3o foram validados! Verifique.");
                }
            }
        }
        if (ordemServico.getId() == null) {
            ordemServico.setIdAtendente(sessao.getIdUsuario());
        }
        ordemServico.setItens(this.separarItensKit(ordemServico.getItens()));
        ordemServico.getItens().forEach(itOS -> {
            String dataHoraServico = "";
            if (!Util.listNullOrEmpty((List)itOS.getListaDataHora())) {
                for (OrdemServicoItemDataHora item : itOS.getListaDataHora()) {
                    dataHoraServico = dataHoraServico.concat(item.getDataHoraInicialServico().toString() + ":00=" + item.getDataHoraFinalServico().toString() + ":00;");
                }
            }
            dataHoraServico = dataHoraServico.replace("T", " ");
            itOS.setDataHoraServico(dataHoraServico);
        });
        boolean osOrcamento = ordemServico.isOrcamento() && !EnumSituacaoOrcamento.APROVADO.equals((Object)ordemServico.getOrcamentoAprovado());
        TipoConfiguracaoEstoqueNegativo tipoConfEstoqueNegativo = (TipoConfiguracaoEstoqueNegativo)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 1006);
        if (tipoConfEstoqueNegativo.equals((Object)TipoConfiguracaoEstoqueNegativo.BLOQUEAR) && !osOrcamento && (itens = ordemServico.getItens()) != null) {
            for (OrdemServicoItem ordemServicoItem : itens) {
                Produto produto;
                if (TipoKit.KIT_PAI.getId().intValue() == ordemServicoItem.getTipoKit() || (produto = (Produto)ProdutoRN.getInstance().buscarPorId(ordemServicoItem.getIdProduto())) != null && produto.getTipo() == TipoRegistroProduto.SERVICO) continue;
                BigDecimal saldoEstoque = ProdutoRN.getInstance().getSaldoEstoqueAtualOuPrevisto(true, sessao, sessao.getFilial().getId(), null, ordemServicoItem.getIdProduto(), 0, null, Collections.singletonList(ordemServico.getId()), null);
                BigDecimal quantidadeVendida = BigDecimal.ZERO;
                for (OrdemServicoItem item2 : itens) {
                    if (item2.getIdProduto() == null || !item2.getIdProduto().equals(ordemServicoItem.getIdProduto())) continue;
                    quantidadeVendida = quantidadeVendida.add(item2.getQuantidade());
                }
                if (saldoEstoque.subtract(quantidadeVendida).compareTo(BigDecimal.ZERO) >= 0) continue;
                String mascara = Util.getMascaraQuantidade((int)UnidademedidaRN.getInstance().getCasasDecimais(ordemServicoItem.getIdUnidadeMedida()));
                String msg = "Quantidade em estoque: " + Util.bigDecimal2String((BigDecimal)saldoEstoque, (String)mascara) + " Quantidade vendida: " + Util.bigDecimal2String((BigDecimal)quantidadeVendida, (String)mascara);
                msg = msg + " - Produto " + ordemServicoItem.getCodigoProduto() + " com saldo insuficiente em estoque. ";
                throw new UnicoMensagemUsuarioException("WORS15", msg + "Venda n\u00e3o permitida.");
            }
            ordemServico.setItens(itens);
        }
        AuxiliarOrderServico aux = (AuxiliarOrderServico)this.getObjetoAuxiliar();
        if (!NumberUtil.longNullOuZero((Long)ordemServico.getIdCliente()) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)ordemServico.getValor()) && !aux.getConfiguracao().isValidarLimiteCredito() && LimiteCreditoRN.getInstance().isVerificarLimiteCredito(sessao, ordemServico)) {
            LimiteCreditoRN.getInstance().validarLimiteCredito(sessao, ordemServico);
        }
        if (!NumberUtil.longNullOuZero((Long)ordemServico.getIdOrcamentoFaturamento())) {
            OrcamentoFaturamentoRN.getInstance().atualizarOrcamentoFaturamentoPorOS(sessao, ordemServico.getIdOrcamentoFaturamento());
        }
        if ((configuracaoOrdemServico = ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(sessao)).getTipoObjeto().equals((Object)TipoObjetoConfOrdemServico.PRODUTO) && !NumberUtil.longNullOuZero((Long)ordemServico.getIdProduto())) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(ordemServico.getIdProduto());
            ordemServico.setDescricaoItem(produto.getCodigo() + "-" + produto.getDescricao());
        }
    }

    protected void beforeCreate(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HashMap mapImagens;
        Sessao sessao = SessaoUtil.getSessao();
        ordemServico.setIdFilial(sessao.getIdFilial());
        if (ordemServico.isOrcamento() && !EnumSituacaoOrcamento.APROVADO.equals((Object)ordemServico.getOrcamentoAprovado())) {
            ordemServico.setStatus(StatusOrdemServico.ORCAMENTO.getId());
        } else if (ordemServico.getAgendamento() != null && ordemServico.getAgendamento().compareTo(ordemServico.getData()) > 0) {
            ordemServico.setStatus(StatusOrdemServico.AGENDADA.getId());
        } else {
            ordemServico.setStatus(StatusOrdemServico.ABERTA.getId());
        }
        Map map = mapImagens = !ListMapUtil.listNullOrEmpty((List)ordemServico.getImagens()) ? ordemServico.getImagens().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(OrdemServicoImagem::getId, Function.identity())) : new HashMap();
        if (!ListMapUtil.listNullOrEmpty((List)ordemServico.getArquivos())) {
            mapImagens.putAll(ordemServico.getArquivos().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(OrdemServicoImagem::getId, Function.identity())));
        }
        List imagens = OrdemServicoImagemCommonRN.getInstance().buscarListaPorIdOrdemServico(ordemServico.getIdOsOrigem());
        for (OrdemServicoImagem imagem : imagens) {
            if (mapImagens.containsKey(imagem.getId())) {
                OrdemServicoImagem ordemServicoImagem = (OrdemServicoImagem)mapImagens.get(imagem.getId());
                String arquivoRelativoImagem = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, TipoImagem.TamanhoOriginal, imagem.getCaminhoOriginal());
                if (StringUtil.stringNullOrEmpty((String)ordemServicoImagem.getCaminhoOriginal()) || !ordemServicoImagem.getCaminhoOriginal().equals(arquivoRelativoImagem)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, imagem.getCaminhoOriginal());
                    continue;
                }
                ordemServicoImagem.setCaminhoOriginal(imagem.getCaminhoOriginal());
                continue;
            }
            OrdemServicoImagemCommonRN.getInstance().excluir((AbstractPojo)imagem, sessao);
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, imagem.getCaminhoOriginal());
        }
    }

    protected void beforeUpdate(OrdemServico ordemServico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HashMap mapImagens;
        OrdemServico osAnterior = (OrdemServico)((OrdemServicoRN)this.rn).buscarPorId(ordemServico.getId());
        if (StatusOrdemServico.ABERTA.getId().equals(osAnterior.getStatus())) {
            if (ordemServico.getAgendamento() != null && ordemServico.getAgendamento().compareTo(ordemServico.getData()) > 0) {
                ordemServico.setStatus(StatusOrdemServico.AGENDADA.getId());
            } else if (!osAnterior.isOrcamento() && ordemServico.isOrcamento()) {
                ordemServico.setStatus(StatusOrdemServico.ORCAMENTO.getId());
            }
        } else if (StatusOrdemServico.ORCAMENTO.getId().equals(ordemServico.getStatus())) {
            if (!EnumSituacaoOrcamento.APROVADO.equals((Object)osAnterior.getOrcamentoAprovado()) && EnumSituacaoOrcamento.APROVADO.equals((Object)ordemServico.getOrcamentoAprovado())) {
                ordemServico.setStatus(StatusOrdemServico.ABERTA.getId());
                ordemServico.setAprovacaoOrcamento(DataHoraFactory.getData());
            } else if (osAnterior.isOrcamento() && !ordemServico.isOrcamento()) {
                ordemServico.setStatus(StatusOrdemServico.ABERTA.getId());
            }
        }
        Map map = mapImagens = !ListMapUtil.listNullOrEmpty((List)ordemServico.getImagens()) ? ordemServico.getImagens().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(OrdemServicoImagem::getId, Function.identity())) : new HashMap();
        if (!ListMapUtil.listNullOrEmpty((List)ordemServico.getArquivos())) {
            mapImagens.putAll(ordemServico.getArquivos().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(OrdemServicoImagem::getId, Function.identity())));
        }
        List imagens = OrdemServicoImagemCommonRN.getInstance().buscarListaPorIdOrdemServico(ordemServico.getId());
        for (OrdemServicoImagem imagem : imagens) {
            if (mapImagens.containsKey(imagem.getId())) {
                OrdemServicoImagem ordemServicoImagem = (OrdemServicoImagem)mapImagens.get(imagem.getId());
                String arquivoRelativoImagem = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, TipoImagem.TamanhoOriginal, imagem.getCaminhoOriginal());
                if (StringUtil.stringNullOrEmpty((String)ordemServicoImagem.getCaminhoOriginal()) || !ordemServicoImagem.getCaminhoOriginal().equals(arquivoRelativoImagem)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, imagem.getCaminhoOriginal());
                    continue;
                }
                ordemServicoImagem.setCaminhoOriginal(imagem.getCaminhoOriginal());
                continue;
            }
            OrdemServicoImagemCommonRN.getInstance().excluir((AbstractPojo)imagem, SessaoUtil.getSessao());
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.OrdemServico, imagem.getCaminhoOriginal());
        }
    }

    protected ObjetoAuxiliar getObjetoAuxiliar() throws UnicoMensagemUsuarioException {
        AuxiliarOrderServico auxiliarOrderServico = new AuxiliarOrderServico();
        auxiliarOrderServico.setConfiguracao(ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao()));
        auxiliarOrderServico.setExtras(ExtrasRN.getInstance().buscarPorNomeTabela(ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getIdFilial())));
        auxiliarOrderServico.setObjetoUsaCampoExtra(ExtrasRN.getInstance().buscarPorNomeTabela("objeto") != null);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CONFIGURADOR_CAMPOS_ADICIONAIS)) {
            auxiliarOrderServico.setListaConfiguracaoCampoExtra(ConfiguracaoCampoExtraCommonRN.getInstance().buscarPorPrograma(602));
        }
        return auxiliarOrderServico;
    }

    protected String getAliasTabelaCampoExtra() {
        return ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getIdFilial());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        StatusOrdemServico status = (StatusOrdemServico)EnumUtils.getPorId(StatusOrdemServico.class, (Object)OrdemServicoRN.getInstance().buscarValorPorID(id, "status"));
        if (status != null && status.isPermiteExcluir()) {
            OrdemServicoRN.getInstance().cancelarOrdemServico(SessaoUtil.getSessao(), id, false);
            this.gravarAuditoriaRegistro(id, null, 8);
            if (this.funcionalidadeService.isAtiva(Funcionalidade.CONFIGURADOR_CAMPOS_ADICIONAIS)) {
                ValorCampoExtraCommonRN.getInstance().excluirPorProgramaIdRegistro(SessaoUtil.getSessao(), 602, id);
            }
        } else {
            throw new UnicoMensagemUsuarioException("ORS213", "N\u00e3o \u00e9 permitido cancelar a ordem de servi\u00e7o selecionada");
        }
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    @RequestMapping(value={"/gerar-os"})
    @DBAutoCommit
    public OrdemServicoOrcamentoWrapper gerarOrdemServico(@RequestParam Long idOrcamento) throws UnicoMensagemUsuarioException {
        OrdemServicoOrcamentoWrapper orcamentoWrapper = new OrdemServicoOrcamentoWrapper();
        OrdemServico ordemServico = OrdemServicoRN.getInstance().gerarOrdemServicoPorOrcamentoFaturamento(SessaoUtil.getSessao(), idOrcamento);
        ordemServico.setItens(this.agruparItensKit(ordemServico.getItens()));
        ordemServico.setIdOrcamentoFaturamento(idOrcamento);
        orcamentoWrapper.setOrdemServico(ordemServico);
        orcamentoWrapper.setExtras(this.getConfiguracaoExtras());
        orcamentoWrapper.setAuxiliarOrderServico((AuxiliarOrderServico)this.getObjetoAuxiliar());
        return orcamentoWrapper;
    }

    @PostMapping(value={"/calcular-precos-atacarejo"})
    @DBAutoCommit
    public List<OrdemServicoItem> atualizaProdutosAtacarejo(@RequestBody OrdemServicoItemAtacarejoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            if (wrapper.getProduto() == null) {
                ProdutoDTOWeb prod = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getIdProduto());
                wrapper.setProduto(prod);
            }
            List produtos = wrapper.getItens().stream().filter(item -> item.getIdproduto().equals(wrapper.getProduto().getId())).collect(Collectors.toList());
            BigDecimal quantidade = produtos.stream().map(OrdemServicoItem::getQuantidade).reduce(BigDecimal.ZERO, BigDecimal::add);
            Long pauta = this.atacarejoService.buscaPautaAtacarejo(wrapper.getProduto(), quantidade, sessao);
            for (OrdemServicoItem item2 : produtos) {
                this.atualizaItemAtacarejo(item2, pauta, wrapper.getProduto(), wrapper.getIdCliente());
                if (item2.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
                GeradorKitVenda geradorKitVendaOS = new GeradorKitVenda();
                geradorKitVendaOS.calcularRateioKit(sessao, (ItemKit)item2, item2.getFilhosKit(), wrapper.getIdCondicaoPgmto());
            }
        }
        return wrapper.getItens();
    }

    private void atualizaItemAtacarejo(OrdemServicoItem item, Long pauta, ProdutoDTOWeb produto, Long idCliente) {
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoPreco produtoPreco = null;
        if (produto == null) {
            produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdproduto());
        }
        BigDecimal ultimoPrecoUnitarioInformadoPauta = BigDecimal.ZERO;
        if (item.getMapPrecoUnitarioInformadoPorPauta() != null) {
            ultimoPrecoUnitarioInformadoPauta = item.getMapPrecoUnitarioInformadoPorPauta().getOrDefault(pauta, BigDecimal.ZERO);
        }
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, idCliente) && pauta != null && pauta >= 0L) {
            produtoPreco = this.atacarejoService.getPrecoAtacarejo(pauta, produto, item.getIdEmbalagem(), sessao);
        } else if (NumberUtil.bigDecimalNullOrZero((BigDecimal)ultimoPrecoUnitarioInformadoPauta)) {
            produtoPreco = ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(sessao.getFilial(), item.getIdproduto(), pauta, VariacaoRN.getInstance().stringToMap(item.getVariacoes()), item.getIdEmbalagem()));
        }
        if (produtoPreco != null) {
            item.setPrecoOriginal(produtoPreco.getPreco());
            item.setIdPromocao(produtoPreco.getIdPromocao());
            if (produtoPreco.getPrecoPromocao().compareTo(BigDecimal.ZERO) > 0 && produtoPreco.getPrecoPromocao().compareTo(produtoPreco.getPreco()) < 0) {
                item.setPreco(produtoPreco.getPrecoPromocao());
                item.setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            } else {
                item.setPreco(produtoPreco.getPreco());
            }
        } else {
            item.setIdPromocao(null);
            item.setPreco(ultimoPrecoUnitarioInformadoPauta);
        }
        BigDecimal desconto = item.getDesconto();
        if (item.getTipoValorDesconto().equals((Object)TipoDescontoItem.PERCENTUAL)) {
            desconto = Util.valorDesconto((BigDecimal)item.getPreco().multiply(item.getQuantidade()), (BigDecimal)item.getPercentualDesconto(), (int)2);
        }
        item.setDesconto(desconto);
        BigDecimal total = item.getTotalSemDecontoSubTotal();
        total = total.subtract(item.getDescontoSubTotal()).setScale(2, RoundingMode.HALF_EVEN);
        item.setTotal(total);
        if (item.getMapPrecoUnitarioInformadoPorPauta() != null && !item.getMapPrecoUnitarioInformadoPorPauta().containsKey(pauta)) {
            item.getMapPrecoUnitarioInformadoPorPauta().put(pauta, item.getPrecoComAcrecimo());
        }
    }

    private void enviarEmailAviso(OrdemServico ordemServico) throws UnicoMensagemUsuarioException {
        String emailPara = null;
        Entidade entidade = (Entidade)new EntidadeRN().buscarPorId(ordemServico.getIdCliente());
        if (entidade != null) {
            emailPara = entidade.getEmail();
        }
        if (Util.stringNullOrEmpty(emailPara)) {
            throw new UnicoMensagemUsuarioException("WORS34", "E-mail do cliente da OS n\u00e3o cadastrado.");
        }
        String assunto = "Ordem de servi\u00e7o " + OrdemServicoRN.getInstance().getCodigoDavFormatado(ordemServico.getCodigo()) + " finalizada";
        String mensagem = "Problema descrito: " + ordemServico.getProblemaDescrito() + Util.newLine() + Util.newLine() + "Solu\u00e7\u00e3o: " + ordemServico.getServicoExecutado();
        String arquivoGerado = "ordem_servico_" + ordemServico.getCodigo() + ".pdf";
        ModeloImpressaoCabecalho modeloImpressaoEmail = ModeloImpressaoCabecalhoRN.getInstance().buscarModeloPadraoEmail(TipoModelo.ORDEMSERVICO);
        if (modeloImpressaoEmail == null) {
            throw new UnicoMensagemUsuarioException("WORS81", "Nenhum modelo de e-mail configurado. Verifique");
        }
        ImpressaoOrdemServico ior = new ImpressaoOrdemServico(SessaoUtil.getSessao(), FilialRN.getInstance().aplicaRegrasDoPafEcf(SessaoUtil.getSessao()));
        UnicoByteArrayDataSource dataSourcePdf = new UnicoByteArrayDataSource(ior.imprimir(modeloImpressaoEmail, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{ordemServico.getId()}).getMalote().extrai("pdf"), arquivoGerado, "application/pdf");
        ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)SessaoUtil.getSessao(), (String)emailPara, null, (String)assunto, (String)mensagem);
        parametrosEmail.setAnexos(new DataSource[]{dataSourcePdf});
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Ordem servi\u00e7o");
        taskEmail.createTask((Object)parametrosEmail, assunto);
    }

    private void calculaTotalItem(OrdemServicoItemWeb item) {
        BigDecimal qtd = item.getQuantidade();
        BigDecimal preco = item.getPreco();
        BigDecimal desconto = item.getDesconto();
        BigDecimal total = preco.multiply(qtd).subtract(desconto);
        item.setTotal(total.setScale(2, RoundingMode.HALF_EVEN));
    }

    protected List<OrdemServicoItemWeb> afterRateioKit(ItemKitWrapper<OrdemServico, OrdemServicoItemWeb> wrapper, List<OrdemServicoItemWeb> itensParaRateio) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)((OrdemServicoItemWeb)wrapper.getItem()).getIdCfop())) {
            String cfop = (String)NaturezaOperacaoRN.getInstance().buscarValorPorID(((OrdemServicoItemWeb)wrapper.getItem()).getIdCfop(), "codigo");
            ((OrdemServicoItemWeb)wrapper.getItem()).setCfop(cfop);
        }
        if (!Util.longNullOuZero((Long)((OrdemServicoItemWeb)wrapper.getItem()).getIdTecnico())) {
            String nomeTecnico = (String)EntidadeRN.getInstance().buscarValorPorID(((OrdemServicoItemWeb)wrapper.getItem()).getIdTecnico(), "nome");
            ((OrdemServicoItemWeb)wrapper.getItem()).setNomeTecnico(nomeTecnico);
        }
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(wrapper.getIdCliente());
        Long idCfopPai = NaturezaOperacaoRN.getInstance().buscarIdNaturezaOperacaoOrdemServico(SessaoUtil.getSessao(), (Produto)ProdutoRN.getInstance().buscarPorId(((OrdemServicoItemWeb)wrapper.getItem()).getIdproduto()), cliente, ((OrdemServicoItemWeb)wrapper.getItem()).getBrinde() == 1);
        boolean usuarioTrocouCfop = !Util.longNullOuZero((Long)((OrdemServicoItemWeb)wrapper.getItem()).getIdCfop()) && !((OrdemServicoItemWeb)wrapper.getItem()).getIdCfop().equals(idCfopPai);
        for (OrdemServicoItemWeb ordemServicoItemWeb : itensParaRateio) {
            if (usuarioTrocouCfop) {
                ordemServicoItemWeb.setIdCfop(((OrdemServicoItemWeb)wrapper.getItem()).getIdCfop());
                ordemServicoItemWeb.setCfop(((OrdemServicoItemWeb)wrapper.getItem()).getCfop());
            } else {
                Long idCfopItem = NaturezaOperacaoRN.getInstance().buscarIdNaturezaOperacaoOrdemServico(SessaoUtil.getSessao(), (Produto)ProdutoRN.getInstance().buscarPorId(ordemServicoItemWeb.getIdproduto()), cliente, ordemServicoItemWeb.getBrinde() == 1);
                ordemServicoItemWeb.setIdCfop(idCfopItem);
                if (!Util.longNullOuZero((Long)idCfopItem)) {
                    String cfop = (String)NaturezaOperacaoRN.getInstance().buscarValorPorID(idCfopItem, "codigo");
                    ordemServicoItemWeb.setCfop(cfop);
                }
            }
            ordemServicoItemWeb.setIdTecnico(((OrdemServicoItemWeb)wrapper.getItem()).getIdTecnico());
            ordemServicoItemWeb.setNomeTecnico(((OrdemServicoItemWeb)wrapper.getItem()).getNomeTecnico());
        }
        return itensParaRateio;
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridTecnicoLogado());
    }
}

