/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ordemservico;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TipoModelo;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.OrdemServico;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.ordemservico.impressao.ImpressaoLaudoTecnico;
import br.intelidata.commons.modulo.ordemservico.impressao.ImpressaoOrdemServico;
import br.intelidata.commons.modulo.ordemservico.regranegocio.OrdemServicoRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.TrataModeloIReportWebImpl;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/ordem-servico"})
public class OrdemServicoJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    private final TrataModeloIReportWebImpl trataModeloIReportWeb;

    public OrdemServicoJobController(TaskManager taskManager, TrataModeloIReportWebImpl trataModeloIReportWeb) {
        super(taskManager);
        this.trataModeloIReportWeb = trataModeloIReportWeb;
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        String arquivoGerado = "";
        ModeloImpressaoCabecalho modeloImpressaoEmail = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(compartilhamento.getIdModelo());
        OrdemServico ordemServico = (OrdemServico)OrdemServicoRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        ImpressaoOrdemServico impressaoOrdemServico = null;
        if (TipoModelo.ORDEMSERVICO.getSerie().equals(modeloImpressaoEmail.getIdSerie())) {
            arquivoGerado = "ordem_servico_" + ordemServico.getCodigo() + ".pdf";
            impressaoOrdemServico = new ImpressaoOrdemServico(sessao, FilialRN.getInstance().aplicaRegrasDoPafEcf(sessao));
        } else if (TipoModelo.LAUDO_TECNICO.getSerie().equals(modeloImpressaoEmail.getIdSerie())) {
            arquivoGerado = "laudo_tecnico_" + ordemServico.getCodigo() + ".pdf";
            impressaoOrdemServico = new ImpressaoLaudoTecnico(sessao);
        }
        if (impressaoOrdemServico == null) {
            throw new UnicoMensagemUsuarioException("ORS170", "N\u00e3o foi poss\u00edvel carregar o modelo de impress\u00e3o.");
        }
        Malote malote = new Malote();
        impressaoOrdemServico.setTrataImagemWeb((TrataImagemWeb)this);
        byte[] arquivo = impressaoOrdemServico.imprimir(modeloImpressaoEmail, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{ordemServico.getId()}).getMalote().extrai("pdf");
        malote.inclui(arquivoGerado, arquivo);
        UnicoByteArrayDataSource dataSource = new UnicoByteArrayDataSource(arquivo, arquivoGerado, "application/pdf");
        notificacao.setMalote(malote);
        notificacao.setDataSources(new DataSource[]{dataSource});
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Ordem servi\u00e7o");
        taskEmail.createTask((Object)parametrosEmail, parametrosEmail.getAssunto());
    }
}

