/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosgnre;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.common.enums.TipoCertificado;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Certificado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.gnre.ParametroGNRE;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CertificadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-gnre"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Par\u00e2metros da GNRE On-line", ROTA="/gnre/parametros-gnre", PROGRAMA=1000019)
public class ParametroGnreCrudController
extends SimpleCrudController<ParametroGNRE, FilialRN> {
    public ParametroGnreCrudController() {
        super((AbstractRegraNegocio)FilialRN.getInstance());
    }

    @DBAutoCommit
    public ParametroGNRE get(Long parentId) {
        return ((Filial)FilialRN.getInstance().buscarPorId(SessaoUtil.getSessao().getIdFilial())).getParametroGNRE();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroGNRE entity) throws UnicoMensagemUsuarioException {
        Certificado certificado = (Certificado)CertificadoRN.getInstance().buscarPorId(entity.getIdCertificadoGnre());
        if (TipoCertificado.A3.equals((Object)certificado.getTipoCertificado())) {
            throw new UnicoMensagemUsuarioException("WCOM236302", "N\u00e3o \u00e9 poss\u00edvel selecionar um certificado A3 para a GNRE. Selecione um certificado A1 ou Reposit\u00f3rio do Windows");
        }
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(SessaoUtil.getSessao().getIdFilial());
        filial.setParametroGNRE(entity);
        filial.setNaoGravarListas(true);
        FilialRN.getInstance().gravar(1, filial, true, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)entity);
        return filial.getId();
    }
}

