/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosmdfe;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.common.enums.TipoAmbiente;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.manifesto.ParametroMDFE;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-mdfe"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Par\u00e2metros da MDF-e", ROTA="/manifesto-documento/parametros-mdfe", PROGRAMA=1000022)
public class ParametroMdfeCrudController
extends SimpleCrudController<ParametroMDFE, FilialRN> {
    private final LicencaService licencaService;

    @Autowired
    public ParametroMdfeCrudController(LicencaService licencaService) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.Damdfe);
        this.licencaService = licencaService;
    }

    @DBAutoCommit
    public ParametroMDFE get(Long parentId) {
        ParametroMDFE parametro = ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroMDFE();
        if (!StringUtil.stringNullOrEmpty((String)parametro.getArquivoImagemDamdfe())) {
            String url = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Damdfe, TipoImagem.Pequena, parametro.getArquivoImagemDamdfe(), parametro.getImagemDamdfe());
            parametro.setArquivoImagemDamdfe(url);
        }
        return parametro;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroMDFE entity) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial());
        ParametroMDFE parametrosOriginais = filial.getParametroMDFE();
        if (parametrosOriginais != null && !StringUtil.stringNullOrEmpty((String)parametrosOriginais.getArquivoImagemDamdfe())) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Damdfe, TipoImagem.Pequena, parametrosOriginais.getArquivoImagemDamdfe());
            if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDamdfe()) || !entity.getArquivoImagemDamdfe().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Damdfe, parametrosOriginais.getArquivoImagemDamdfe());
                if (StringUtil.stringNullOrEmpty((String)entity.getArquivoImagemDamdfe())) {
                    entity.setImagemDamdfe(null);
                }
            } else {
                entity.setArquivoImagemDamdfe(parametrosOriginais.getArquivoImagemDamdfe());
            }
        }
        filial.setParametroMDFE(entity);
        if (this.licencaService.getDadosLicenca().isDemonstracao()) {
            filial.getParametroMDFE().setTipoAmbienteMdfe(TipoAmbiente.HOMOLOGACAO);
        }
        filial.setNaoGravarListas(true);
        FilialRN.getInstance().gravar(1, filial, true, SessaoUtil.getSessao());
        this.afterSave((AbstractPojo)entity);
        return filial.getId();
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }
}

