/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosspedcontribuicao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.sped.contribuicoes.IndicadorIncidenciaTributaria;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-sped-contribuicao"})
@SubMenuMapping(MENU="SubMenuPainelContadorParametrosAuxiliarSpedContribuicao", NOME="Par\u00e2metros do SPED contribui\u00e7\u00f5es", ROTA="/speds/parametros-sped-contribuicao", PROGRAMA=61)
public class ParametroSpedContribuicaoCrudController
extends SimpleCrudController<Filial, FilialRN> {
    public ParametroSpedContribuicaoCrudController() {
        super((AbstractRegraNegocio)FilialRN.getInstance());
    }

    @DBAutoCommit
    public Filial get(Long parentId) throws UnicoMensagemUsuarioException {
        Filial matriz = FilialCommonRN.getInstance().getMatrizDaFilialAtual(SessaoUtil.getSessao());
        Filial filial = SessaoUtil.getSessao().getFilial();
        if (matriz == null) {
            throw new UnicoMensagemUsuarioException("WCOM149", "Cadastre uma matriz antes de informar os parametros para a SPED Contribui\u00e7\u00f5es");
        }
        filial.setCfopVenda(matriz.getCfopVenda());
        filial.setCfopVendaST(matriz.getCfopVendaST());
        filial.setCfopFabricacaoPropria(matriz.getCfopFabricacaoPropria());
        filial.setCfopFabricacaoPropriaST(matriz.getCfopFabricacaoPropriaST());
        filial.setCfopVendaServico(matriz.getCfopVendaServico());
        filial.setFormatarNumeroSerieC100(matriz.isFormatarNumeroSerieC100());
        return filial;
    }

    public void beforeUpdate(Filial filial) throws UnicoMensagemUsuarioException {
        if (filial.getParametroSpedPisCofins().getIndicadorLucroPresumido() != null && filial.getParametroSpedPisCofins().getIncidenciaTributaria() != null && !filial.getParametroSpedPisCofins().getIncidenciaTributaria().equals((Object)IndicadorIncidenciaTributaria.CUMULATIVO_2)) {
            throw new UnicoMensagemUsuarioException("WCOM150", "Crit\u00e9rio escritura\u00e7\u00e3o cumulativo inv\u00e1lido para Incid\u00eancia tribut\u00e1ria. Verifique! ");
        }
        filial.setNaoGravarListas(true);
    }

    public void afterSave(Filial filial) throws UnicoMensagemUsuarioException {
        Filial matriz = FilialCommonRN.getInstance().getMatrizDaFilialAtual(SessaoUtil.getSessao());
        if (matriz != null) {
            matriz.setCfopVenda(filial.getCfopVenda());
            matriz.setCfopVendaST(filial.getCfopVendaST());
            matriz.setCfopVendaServico(filial.getCfopVendaServico());
            matriz.setCfopFabricacaoPropria(filial.getCfopFabricacaoPropria());
            matriz.setCfopFabricacaoPropriaST(filial.getCfopFabricacaoPropriaST());
            matriz.setFormatarNumeroSerieC100(filial.isFormatarNumeroSerieC100());
            FilialRN.getInstance().alterar((AbstractPojo)matriz, SessaoUtil.getSessao());
        }
    }
}

