/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Pagamento;
import br.intelidata.commons.domain.pojo.RelacionaBandeira;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoFinalizador;
import br.intelidata.commons.domain.pojo.enuns.TipoFormaPagamentoTef;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartao;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartao;
import br.intelidata.commons.domain.pojo.pafecf.Finalizador;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.RelacionaBandeiraRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class InicioPagamentoWeb {
    private static final int AVISTA = 0;
    private static final int PARCELADO_ADMINISTRADORA = 3;

    public List<Pagamento> gerarParcelas(Sessao sessao, List<Pagamento> pagamentos, Operacao operacao) throws UnicoMensagemUsuarioException {
        ArrayList<Pagamento> novosPagamentos = new ArrayList<Pagamento>();
        int contador = 1;
        int grupo = 0;
        for (Pagamento pagamento : pagamentos) {
            ++grupo;
            Finalizador finalizador = FinalizadorRN.getInstance().buscarPorCodigo(pagamento.getFinalizador());
            if (finalizador != null && !NumberUtil.longNullOuZero((Long)finalizador.getIdContaCorrente())) {
                pagamento.setIdContaCorrente(finalizador.getIdContaCorrente());
            }
            if (finalizador != null && (finalizador.getTipoDocumento().equals((Object)TipoDocumentoFinalizador.CHEQUE) || finalizador.getTipoDocumento().equals((Object)TipoDocumentoFinalizador.CREDIARIO) || finalizador.getTipoDocumento().equals((Object)TipoDocumentoFinalizador.CMC7))) {
                this.validarCliente(sessao, operacao.getIdCliente());
            }
            if (Util.longNullOuZero((Long)pagamento.getIdCondicaoPagamento())) {
                pagamento.setContador(Integer.valueOf(contador++));
                pagamento.setGrupoFinalizador(Integer.valueOf(grupo));
                if (pagamento.getDataVencimento() == null) {
                    pagamento.setDataVencimento(DataHoraFactory.getData());
                }
                pagamento.setContador(Integer.valueOf(1));
                pagamento.setValorParcela(pagamento.getValorTotal());
                this.carregarPagamentoPOS(sessao, pagamento);
                novosPagamentos.add(pagamento);
                continue;
            }
            CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(pagamento.getIdCondicaoPagamento());
            if (condicaoPagamento == null) {
                throw new UnicoMensagemUsuarioException("WWW297", "Condi\u00e7\u00e3o de pagamento n\u00e3o encontrada");
            }
            this.validarCliente(sessao, operacao.getIdCliente());
            boolean isPorPrazo = !Util.stringNullOrEmpty((String)condicaoPagamento.getPrazos());
            String[] prazo = condicaoPagamento.getPrazos().split("\\.");
            int n = isPorPrazo ? prazo.length : condicaoPagamento.getParcelas();
            int numeroParcela = 0;
            BigDecimal valorParcelas = pagamento.getValorTotal().divide(new BigDecimal(n), 2, RoundingMode.HALF_DOWN);
            BigDecimal valorDiferenca = pagamento.getValorTotal().subtract(valorParcelas.multiply(new BigDecimal(n))).setScale(2, RoundingMode.HALF_DOWN);
            BigDecimal valorPrimeiraParcela = valorParcelas.add(valorDiferenca);
            for (int i = 0; i < n; ++i) {
                ++numeroParcela;
                LocalDate vencimento = DataHoraFactory.getData();
                if (isPorPrazo) {
                    vencimento = vencimento.plusDays(Integer.parseInt(prazo[i]));
                } else {
                    int dia = condicaoPagamento.getDiaVencimento() == 0 ? 1 : condicaoPagamento.getDiaVencimento();
                    vencimento = vencimento.withDayOfMonth(dia);
                    vencimento = vencimento.plusMonths(i + 1);
                }
                Pagamento pagamento1 = (Pagamento)pagamento.clonar();
                pagamento1.setId(null);
                pagamento1.setContador(Integer.valueOf(contador++));
                pagamento1.setGrupoFinalizador(Integer.valueOf(grupo));
                pagamento1.setIdOperacao(operacao.getId());
                pagamento1.setValorParcela(i == 0 ? valorPrimeiraParcela : valorParcelas);
                pagamento1.setCoo(operacao.getCoo());
                pagamento1.setEcfSerie(operacao.getEcfSerie());
                pagamento1.setEcfModelo(operacao.getEcfModelo());
                pagamento1.setEcfMfAdicional(operacao.getEcfMfAdicional());
                pagamento1.setEcfProprietario(operacao.getEcfProprietario());
                pagamento1.setFinalizador(pagamento.getFinalizador());
                pagamento1.setNomeFinalizador(pagamento.getNomeFinalizador());
                pagamento1.setIdContaCorrente(pagamento.getIdContaCorrente());
                pagamento1.setIndicadorEstorno("N");
                pagamento1.setGnf(operacao.getCcfgnf());
                pagamento1.setCcf(Integer.valueOf(0));
                if (numeroParcela > 1) {
                    pagamento1.setTroco(BigDecimal.ZERO);
                }
                pagamento1.setNumeroParcela(Integer.valueOf(numeroParcela));
                pagamento1.setTotalParcelas(Integer.valueOf(n));
                pagamento1.setDataVencimento(vencimento);
                novosPagamentos.add(pagamento1);
            }
        }
        return novosPagamentos;
    }

    private void validarCliente(Sessao sessao, Long idEntidade) throws UnicoMensagemUsuarioException {
        if (EntidadeRN.getInstance().isEntidadeBloqueadaPorAtrasoPDV(sessao, idEntidade)) {
            String msg = (String)PropriedadeRN.getInstance().getPropriedade(sessao.getFilial(), 307);
            if (Util.stringNullOrEmpty((String)msg)) {
                msg = "Cliente em atraso. Venda n\u00e3o permitida";
            }
            throw new UnicoMensagemUsuarioException("WWW723", msg);
        }
    }

    private void carregarPagamentoPOS(Sessao sessao, Pagamento pagamento) {
        AdministradoraCartao adm = null;
        if (!StringUtil.stringNullOrEmpty((String)pagamento.getRede())) {
            adm = AdministradoraCartaoRN.getInstance().buscarPorRede(pagamento.getRede());
        } else if (!StringUtil.stringNullOrEmpty((String)pagamento.getNomeRede())) {
            adm = AdministradoraCartaoRN.getInstance().buscarPorNome(pagamento.getNomeRede());
        }
        if (adm != null) {
            LocalDate dataVencimento;
            pagamento.setCnpjRede(Util.apenasNumeros((String)adm.getCnpj()));
            LocalDate hoje = DataHoraFactory.getData();
            BandeiraCartao bandeiraCartao = BandeiraCartaoRN.getInstance().buscarBandeiraPorCodigoOrNome(pagamento.getCodigoBandeira(), pagamento.getNomeBandeira());
            if (bandeiraCartao != null) {
                RelacionaBandeira rb = RelacionaBandeiraRN.getInstance().getRelacionaBandeiraPorIdAdmIdBandeira(adm.getId(), bandeiraCartao.getId());
                dataVencimento = pagamento.getTefFormaPagamento().equals(TipoFormaPagamentoTef.CREDITO.getId()) ? hoje.plusDays(rb.getPrazoVencimentoCredito()) : hoje.plusDays(rb.getPrazoVencimentoDebito());
                pagamento.setCodigoBandeira(bandeiraCartao.getCodigoBandeira());
            } else {
                dataVencimento = pagamento.getTefFormaPagamento().equals(TipoFormaPagamentoTef.CREDITO.getId()) ? hoje.plusDays(adm.getPrazoVencimentoCredito()) : hoje.plusDays(adm.getPrazoVencimentoDebito());
            }
            dataVencimento = FinanceiroDadoRN.getInstance().ajustarParaProximoDiaUtil(dataVencimento, sessao);
            pagamento.setDataVencimento(dataVencimento);
            if (pagamento.getTotalParcelas() > 1) {
                if (adm.getParcelamentoPosCred() != null) {
                    pagamento.setTefParcelamento(adm.getParcelamentoPosCred().getId());
                } else {
                    pagamento.setTefParcelamento(Integer.valueOf(3));
                }
            } else {
                pagamento.setTefParcelamento(Integer.valueOf(0));
            }
        }
    }
}

