/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.PosIntegrado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.PosIntegradoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pos-integrado"})
@SubMenuMapping(MENU="SubMenuPdvGeral", NOME="POS Integrado", ROTA="/pdvs/pos-integrado", PROGRAMA=930, ICONE="icon icon-trabalharcom")
public class PosIntegradoCrudController
extends CrudController<PosIntegrado, PosIntegradoRN> {
    public PosIntegradoCrudController() {
        super((AbstractRegraNegocio)PosIntegradoRN.getInstance(), PosIntegrado::new, true, true);
    }

    protected String getCacheId() {
        return "pos-integrado";
    }

    protected GridBuilder<PosIntegradoRN> getGridBuilder() {
        List colunas = PosIntegradoRN.getInstance().getColunasPadraoGrid();
        GridBuilder grid = new GridBuilder(PosIntegradoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(pos -> {
            int idxIdentificadorLicenca = this.getIndexColuna("identificadorLicenca", colunas);
            int idxLicenciado = this.getIndexColuna("licenciado", colunas);
            if (idxIdentificadorLicenca > -1 && idxLicenciado > -1) {
                pos[idxLicenciado] = PosIntegradoRN.getInstance().isIdentificadorLicenciado((String)pos[idxIdentificadorLicenca]) ? EnumSimNao.SIM.name() : EnumSimNao.NAO.name();
            }
        });
    }
}

